/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.modules;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.array.functions.SelectFunctions;
import dmLab.array.meta.AttributesMetaInfo;
import dmLab.classifier.Classifier;
import dmLab.classifier.PredictionResult;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.mcfsEngine.modules.Split;
import dmLab.utils.ArrayUtils;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;
import dmLab.utils.roulette.RouletteInput;
import dmLab.utils.roulette.RouletteItem;
import dmLab.utils.roulette.RouletteSelection;
import dmLab.utils.statList.StatsList;
import dmLab.utils.statList.StatsObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public final class Projection {
    private MCFSParams mcfsParams;
    private Split split;
    private StatsList splitsStats;
    private SelectFunctions selectFunctions;

    /*
     * WARNING - void declaration
     */
    public Projection(MCFSParams mcfsParams, Random random) {
        void var2_2;
        void var1_1;
        this.mcfsParams = mcfsParams;
        this.split = new Split((MCFSParams)var1_1, random);
        this.selectFunctions = new SelectFunctions((Random)var2_2);
    }

    public final ConfusionMatrix projectionLoop(Classifier classifier, FArray inputArray, AttributesRI[] attrRI, AttributesID attrIDependencies) {
        Object object;
        Object object2;
        Object[] objectArray;
        Object object3;
        Object object4;
        ConfusionMatrix confusionMatrix;
        this.splitsStats = new StatsList();
        if (inputArray.isTargetNominal()) {
            confusionMatrix = new ConfusionMatrix(inputArray.getColNames(true)[inputArray.getDecAttrIdx()], ((Array)inputArray).getDecValuesStr());
            this.splitsStats.addHeader$505d15af("acc,wAcc,errors");
        } else {
            confusionMatrix = null;
            this.splitsStats.addHeader$505d15af("pearson,MAE,RMSE,SMAPE");
        }
        int projectionSize22 = this.mcfsParams.projectionSizeValue;
        Object object5 = inputArray;
        if (projectionSize22 >= ((Array)object5).attributes.length) {
            object5 = inputArray;
            projectionSize22 = ((Array)object5).attributes.length - 1;
        }
        int n = projectionSize22;
        FArray fArray = inputArray;
        object5 = this.selectFunctions;
        Object object6 = fArray.buildAttributesMetaInfo(false);
        if (n >= ((Array)fArray).colsNumber()) {
            object4 = new int[((Array)fArray).colsNumber()];
            Arrays.fill((int[])object4, 1);
        } else {
            object3 = object6;
            objectArray = ((AttributesMetaInfo)object3).getWeights();
            object2 = new RouletteInput();
            for (int i = 0; i < objectArray.length; ++i) {
                ((RouletteInput)object2).addItem(new RouletteItem(objectArray[i], ((AttributesMetaInfo)object3).getIndexArray(objectArray[i]).length));
            }
            ((RouletteInput)object2).init();
            object = object2;
            RouletteSelection rouletteSelection = new RouletteSelection(((SelectFunctions)object5).arrayUtils.random);
            rouletteSelection.run((RouletteInput)object, n);
            int[] nArray = rouletteSelection.select((AttributesMetaInfo)object6, (RouletteInput)object);
            object4 = nArray;
            nArray[fArray.getDecAttrIdx()] = 1;
        }
        int[] projectionSize22 = object4;
        int[] colIdx = Array.colMask2colIdx((int[])object4);
        for (int i = 0; i < attrRI.length; ++i) {
            attrRI[i].addProjections(inputArray.getColNames(colIdx, false));
        }
        for (int j = 0; j < this.mcfsParams.splits; ++j) {
            float[] stats;
            Object rowIdx;
            if (this.mcfsParams.splitSetClassSizes != null) {
                int[] nArray = this.mcfsParams.splitSetClassSizes;
                fArray = inputArray;
                object5 = this.selectFunctions;
                object4 = new ArrayList();
                object6 = fArray.getDecValues();
                object = fArray.getDecisionValuesTable();
                int n2 = 0;
                for (int i = 0; i < ((Object)object6).length; ++i) {
                    objectArray = (int[])((HashMap)object).get(Float.valueOf((float)object6[i]));
                    object2 = ((SelectFunctions)object5).arrayUtils.randomSelectValues((int[])objectArray, nArray[i]);
                    n2 += ((Object)object2).length;
                    ((ArrayList)object4).add(object2);
                }
                object3 = new int[n2];
                int n3 = 0;
                for (int i = 0; i < ((ArrayList)object4).size(); ++i) {
                    object = (int[])((ArrayList)object4).get(i);
                    for (int k = 0; k < ((Object)object).length; ++k) {
                        object3[n3++] = object[k];
                    }
                }
                Arrays.sort((int[])object3);
                rowIdx = object3;
            } else {
                rowIdx = ArrayUtils.seq(0, ((Array)inputArray).rowsNumber());
                if (this.mcfsParams.splitSetSize < ((int[])rowIdx).length) {
                    rowIdx = this.selectFunctions.arrayUtils.randomSelectValues((int[])rowIdx, this.mcfsParams.splitSetSize);
                }
            }
            FArray splitArray = inputArray.cloneByIdx(colIdx, (int[])rowIdx);
            PredictionResult predRes = this.split.splitLoop(classifier, splitArray, attrRI, attrIDependencies);
            if (inputArray.isTargetNominal()) {
                ConfusionMatrix matrix = predRes.confusionMatrix;
                confusionMatrix.add(matrix);
                stats = new float[]{(float)QualityMeasure.calcAcc(matrix.getMatrix()), (float)QualityMeasure.calcWAcc(matrix.getMatrix()), QualityMeasure.errors(matrix.getMatrix())};
                this.splitsStats.add(new StatsObject(stats));
                continue;
            }
            stats = new float[]{(float)stats.getPredQuality(QualityMeasure.PEARSON), (float)stats.getPredQuality(QualityMeasure.MAE), (float)stats.getPredQuality(QualityMeasure.RMSE), (float)stats.getPredQuality(QualityMeasure.SMAPE)};
            this.splitsStats.add(new StatsObject(stats));
        }
        return confusionMatrix;
    }

    public final StatsList getSplitsStats() {
        return this.splitsStats;
    }
}

