/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.loader.fileLoader;

import dmLab.array.loader.fileLoader.FileLoader;
import dmLab.array.meta.Attribute;
import dmLab.array.meta.AttributeRole;
import dmLab.utils.FileUtils;
import dmLab.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;

public final class FileLoaderADX
extends FileLoader {
    private boolean allDecision = false;

    @Override
    protected final boolean myInit() {
        this.separator = (char)44;
        this.nullLabels.clear();
        this.nullLabels.add("");
        this.nullLabels.add("?");
        this.nullLabels.add("NaN");
        this.nullLabels.add("NA");
        this.nullLabels.add("Null");
        this.commentChar = "#";
        this.fileType = 0;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean parseInputFile(File inputFile) {
        String line;
        boolean attributeSection = false;
        boolean eventSection = false;
        boolean bracketOpen = false;
        int lineCount = 0;
        BufferedReader fileReader = FileUtils.openFile(inputFile);
        if (fileReader == null) {
            FileUtils.closeFile(fileReader);
            return false;
        }
        do {
            void var1_2;
            try {
                line = fileReader.readLine();
                ++lineCount;
            }
            catch (Exception exception) {
                System.err.println("Error reading input file.");
                return false;
            }
            if (line == null || (line = this.trimComments(line)).equalsIgnoreCase("")) continue;
            if ((line.toLowerCase().indexOf("attributes") != -1 || line.toLowerCase().indexOf("events") != -1) && line.toLowerCase().indexOf("{") != -1) {
                if (line.toLowerCase().indexOf("attributes") > line.toLowerCase().indexOf("{")) {
                    System.err.println("Bracket Before Declaration of 'attributes' section! Line: " + String.valueOf(lineCount));
                    return false;
                }
                if (line.toLowerCase().indexOf("attributes") != -1) {
                    attributeSection = true;
                    bracketOpen = true;
                }
                if (line.toLowerCase().indexOf("events") > line.toLowerCase().indexOf("{")) {
                    System.err.println("Bracket Before Declaration of 'events' section! Line: " + String.valueOf(lineCount));
                    return false;
                }
                if (line.toLowerCase().indexOf("events") != -1) {
                    eventSection = true;
                    bracketOpen = true;
                }
            } else {
                if (line.toLowerCase().indexOf("attributes") != -1) {
                    attributeSection = true;
                } else if (line.toLowerCase().indexOf("events") != -1) {
                    eventSection = true;
                }
                if (line.toLowerCase().indexOf("{") != -1 && !attributeSection && !eventSection) {
                    System.err.println("Unexpected Bracket Opening! Line: " + String.valueOf(lineCount));
                    return false;
                }
                if (line.toLowerCase().indexOf("}") != -1 && !attributeSection && !eventSection) {
                    System.err.println("Unexpected Bracket Closing! Line " + String.valueOf(lineCount));
                    return false;
                }
                if (line.toLowerCase().indexOf("{") != -1 && (attributeSection || eventSection)) {
                    bracketOpen = true;
                } else if (line.toLowerCase().equalsIgnoreCase("}") && (attributeSection || eventSection)) {
                    bracketOpen = false;
                    attributeSection = false;
                    eventSection = false;
                }
            }
            if (!bracketOpen) continue;
            int startLine = line.indexOf("{") + 1;
            int stopLine = line.indexOf("}");
            if (startLine == -1) {
                startLine = 0;
            }
            if (stopLine == -1) {
                stopLine = line.length();
            }
            if (startLine == stopLine) continue;
            if (attributeSection) {
                if (!line.substring(startLine, stopLine).equalsIgnoreCase("")) {
                    if (line.indexOf("ignore") == -1) {
                        ++this.attributesNumber;
                    } else {
                        ++this.ignoredAttributesNumber;
                    }
                }
                if (line.endsWith("}")) {
                    bracketOpen = false;
                    attributeSection = false;
                }
            }
            if (!eventSection) continue;
            if (!line.substring((int)var1_2, stopLine).equalsIgnoreCase("")) {
                ++this.eventsNumber;
            }
            if (!line.endsWith("}")) continue;
            bracketOpen = false;
            eventSection = false;
        } while (line != null);
        return FileUtils.closeFile(fileReader);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean readInputFile(File inputFile) {
        String line;
        int attrIndex = 0;
        int eventIndex = 0;
        boolean attributeSection = false;
        boolean eventSection = false;
        boolean bracketOpen = false;
        int lineCount = 0;
        int attributeCount = 0;
        BufferedReader fileReader = FileUtils.openFile(inputFile);
        if (fileReader == null) {
            return false;
        }
        do {
            void var1_2;
            try {
                line = fileReader.readLine();
                ++lineCount;
            }
            catch (Exception exception) {
                System.err.println("Error reading input file.");
                return false;
            }
            if (line == null || (line = this.trimComments(line)).equalsIgnoreCase("")) continue;
            if (line.toLowerCase().indexOf("attributes") != -1) {
                attributeSection = true;
            } else if (line.toLowerCase().indexOf("events") != -1) {
                eventSection = true;
            }
            if (line.toLowerCase().indexOf("{") != -1 && (attributeSection || eventSection)) {
                bracketOpen = true;
            } else if (line.toLowerCase().equalsIgnoreCase("}") && (attributeSection || eventSection)) {
                bracketOpen = false;
                attributeSection = false;
                eventSection = false;
            }
            if (!bracketOpen) continue;
            int startLine = line.indexOf("{") + 1;
            int stopLine = line.indexOf("}");
            if (startLine == -1) {
                startLine = 0;
            }
            if (stopLine == -1) {
                stopLine = line.length();
            }
            if (startLine == stopLine) continue;
            if (attributeSection) {
                if (line.substring(startLine, stopLine).endsWith("ignore")) {
                    this.ignoredAttributeMask[attributeCount++] = true;
                } else {
                    boolean bl;
                    int n = attrIndex;
                    Object object = line.substring(startLine, stopLine);
                    FileLoaderADX fileLoaderADX = this;
                    if ((object = FileLoaderADX.parseAttribute((String)object)) == null) {
                        bl = false;
                    } else {
                        fileLoaderADX.myArray.attributes[n] = object;
                        if (((AttributeRole)object).role == AttributeRole.ROLE_DECISION) {
                            fileLoaderADX.myArray.setDecAttrIdx(n);
                            if (((AttributeRole)object).decValues != null && ((AttributeRole)object).decValues.length > 0) {
                                fileLoaderADX.myArray.setDecValues(((AttributeRole)object).decValues);
                            } else {
                                fileLoaderADX.allDecision = true;
                            }
                        }
                        bl = true;
                    }
                    if (!bl) {
                        System.err.println("Error reading attribute! Line: " + lineCount);
                        return false;
                    }
                    this.ignoredAttributeMask[attributeCount++] = false;
                    ++attrIndex;
                }
                if (line.endsWith("}")) {
                    bracketOpen = false;
                    attributeSection = false;
                }
            }
            if (!eventSection) continue;
            if (!this.loadEvent(line.substring((int)var1_2, stopLine), eventIndex)) {
                System.err.println("Error reading event. Line: " + lineCount);
                return false;
            }
            if (line.endsWith("}")) {
                bracketOpen = false;
                eventSection = false;
            }
            ++eventIndex;
        } while (line != null);
        if (this.allDecision) {
            this.myArray.setAllDecValues();
        }
        return FileUtils.closeFile(fileReader);
    }

    /*
     * WARNING - void declaration
     */
    public static AttributeRole parseAttribute(String inputString) {
        void var1_1;
        Object decision;
        AttributeRole attr = new AttributeRole();
        int decisionIndex = (inputString = inputString.trim()).toLowerCase().lastIndexOf("decision");
        if (decisionIndex > 0) {
            String[] decisionValues;
            String[] stringArray;
            block27: {
                decision = inputString.substring(decisionIndex);
                attr.role = AttributeRole.ROLE_DECISION;
                int n = 44;
                String[] stringArray2 = decision;
                if (decision.trim().equalsIgnoreCase("decision")) {
                    stringArray = new String[]{};
                } else if (stringArray2.indexOf("(") == -1 || stringArray2.indexOf(")") == -1) {
                    System.err.println("Missing bracket!");
                    stringArray = null;
                } else if (stringArray2.indexOf(")") < stringArray2.indexOf("(")) {
                    System.err.println("Unexpected bracket closing.");
                    stringArray = null;
                } else if ((stringArray2 = stringArray2.substring(stringArray2.indexOf("(") + 1, stringArray2.indexOf(")")).trim()).length() == 0) {
                    System.err.println("Decision values are not defined.");
                    stringArray = null;
                } else if ((stringArray2 = StringUtils.tokenizeString((String)stringArray2, new char[]{','}, false)).length == 1 && stringArray2[0].equalsIgnoreCase("all")) {
                    stringArray = new String[]{};
                } else {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (stringArray2[i].length() != 0) continue;
                        System.err.println("Missing decision value!");
                        stringArray = null;
                        break block27;
                    }
                    stringArray = decisionValues = stringArray2;
                }
            }
            if (stringArray == null) {
                System.err.println("Incorrect definition of decision attribute (expected: 'decision(all)'): " + (String)decision);
                return null;
            }
            attr.decValues = decisionValues;
        } else {
            decisionIndex = inputString.length();
        }
        String[] list = StringUtils.tokenize(inputString.substring(0, decisionIndex), new char[]{' ', '\t'}, new char[]{'\"'});
        if (list.length < 2) {
            System.err.println("Incorrect definition of the attribute (expected: 'name type [weight] role').");
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            void var3_3;
            String token = list[i];
            if (i == 0) {
                if (token.startsWith("\"") || token.startsWith("'")) {
                    token = StringUtils.trimQuotation(token);
                }
                attr.name = token;
                continue;
            }
            if (i == 1) {
                if (Attribute.type2Int(token) != -1) {
                    attr.type = Attribute.type2Int(token);
                    continue;
                }
                System.err.println("Incorrect type of attribute: " + list[0] + " type: " + token);
                return null;
            }
            if (i < 2) continue;
            if (token.equalsIgnoreCase("ignore")) {
                if (attr.role != AttributeRole.ROLE_INPUT) {
                    System.err.println("Role of attribute is already defined: " + list[0] + " role: " + token);
                    return null;
                }
                attr.role = AttributeRole.ROLE_IGNORE;
                continue;
            }
            if (token.startsWith("[") && token.endsWith("]")) {
                int weight;
                try {
                    decision = Float.valueOf(Float.parseFloat(token.substring(1, token.length() - 1)));
                    weight = decision.intValue();
                }
                catch (Exception exception) {
                    System.err.println("Incorrect weight of attribute: " + list[0] + " weight: " + token);
                    return null;
                }
                if (weight <= 0 || weight > Short.MAX_VALUE) {
                    System.err.println("Incorrect weight of attribute: " + list[0] + " weight: " + token);
                    return null;
                }
                attr.weight = (short)weight;
                continue;
            }
            System.err.println("Incorrect role of attribute: " + list[0] + " role: " + (String)var3_3);
            return null;
        }
        if (attr.type == 0) {
            String[] stringArray;
            System.err.println("Type is not defined for attribute: " + stringArray[0]);
            return null;
        }
        return var1_1;
    }

    @Override
    protected final boolean readHeaderFile(File inputFile) {
        return true;
    }

    @Override
    protected final File getDataFile(File inputFile) {
        return inputFile;
    }
}

