/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array;

import dmLab.array.Array;
import dmLab.array.domain.ADXDomain;
import dmLab.array.domain.Domain;
import dmLab.array.domain.FDomain;
import dmLab.array.meta.Attribute;
import dmLab.array.meta.Dictionary;
import dmLab.array.meta.DiscRanges;
import dmLab.array.saver.Array2ADH;
import dmLab.array.saver.Array2ADX;
import dmLab.array.saver.Array2CSV;
import dmLab.array.saver.Array2String;
import dmLab.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public final class FArray
extends Array {
    private float[][] valuesArray;
    private float[] decisionValues;
    private HashMap<Float, int[]> decisionValuesTable;
    private Domain[] domains;
    public Dictionary dictionary;
    public DiscRanges[] discRanges;

    public FArray() {
        this.dictionary = new Dictionary();
        this.domains = null;
        this.discRanges = null;
    }

    /*
     * WARNING - void declaration
     */
    public FArray(int columns, int rows) {
        void var2_2;
        void var1_1;
        ((Array)this).init((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void init(int columns, int rows) {
        void var2_2;
        void var1_1;
        this.initAttributes$255f295(columns);
        this.dictionary = new Dictionary();
        this.valuesArray = new float[var1_1][var2_2];
        this.domains = null;
        this.discRanges = null;
    }

    @Override
    public final FArray clone() {
        return this.clone(null, null);
    }

    @Override
    private FArray clone(boolean[] colMask, boolean[] rowMask) {
        FArray fArray = this;
        int srcColumns = fArray.attributes.length;
        fArray = this;
        int srcRows = fArray.valuesArray[0].length;
        if (colMask == null) {
            colMask = new boolean[srcColumns];
            Arrays.fill(colMask, true);
        }
        if (rowMask == null) {
            rowMask = new boolean[srcRows];
            Arrays.fill(rowMask, true);
        }
        int destColumns = ArrayUtils.count(colMask, true);
        int destRows = ArrayUtils.count(rowMask, true);
        FArray dstArray = null;
        if (srcColumns != colMask.length) {
            System.err.println("Incorrect length of colMask: " + colMask.length);
        } else if (srcRows != rowMask.length) {
            System.err.println("Incorrect length of rowMask: " + rowMask.length);
        } else {
            int currentColumn = 0;
            dstArray = new FArray(destColumns, destRows);
            if (this.discRanges != null) {
                dstArray.discRanges = new DiscRanges[destColumns];
            }
            if (this.domains != null) {
                dstArray.domains = new Domain[destColumns];
            }
            for (int i = 0; i < srcColumns; ++i) {
                if (!colMask[i]) continue;
                dstArray.attributes[currentColumn] = this.attributes[i].clone();
                if (i == this.decAttrIdx) {
                    dstArray.decAttrIdx = currentColumn;
                    if (this.decisionValues != null) {
                        dstArray.decisionValues = (float[])this.decisionValues.clone();
                    }
                }
                if (this.discRanges != null && this.discRanges[i] != null) {
                    dstArray.discRanges[currentColumn] = this.discRanges[i].clone();
                }
                if (this.domains != null && this.domains[i] != null) {
                    dstArray.domains[currentColumn] = this.domains[i].clone();
                }
                ++currentColumn;
            }
            dstArray.dictionary = this.dictionary.clone();
            int currentRow = 0;
            for (int j = 0; j < srcRows; ++j) {
                currentColumn = 0;
                if (!rowMask[j]) continue;
                for (int i = 0; i < srcColumns; ++i) {
                    if (!colMask[i]) continue;
                    dstArray.valuesArray[currentColumn][currentRow] = this.valuesArray[i][j];
                    ++currentColumn;
                }
                ++currentRow;
            }
            if (dstArray.decAttrIdx == -1) {
                FArray fArray2 = dstArray;
                fArray2.decAttrIdx = fArray2.attributes.length - 1;
                ((Array)dstArray).setAllDecValues();
            }
        }
        return dstArray;
    }

    public final FArray cloneByIdx(int[] colIdx, int[] rowIdx) {
        FArray fArray = this;
        int srcColumns = fArray.attributes.length;
        fArray = this;
        int srcRows = fArray.valuesArray[0].length;
        int destColumns = colIdx.length;
        int destRows = rowIdx.length;
        FArray dstArray = null;
        if (srcColumns < destColumns) {
            System.err.println("Incorrect length of colIdx: " + colIdx.length);
        } else if (srcRows < destRows) {
            System.err.println("Incorrect length of rowMask: " + rowIdx.length);
        } else {
            int currentDstColumn = 0;
            dstArray = new FArray(destColumns, destRows);
            if (this.discRanges != null) {
                dstArray.discRanges = new DiscRanges[destColumns];
            }
            if (this.domains != null) {
                dstArray.domains = new Domain[destColumns];
            }
            for (int i = 0; i < colIdx.length; ++i) {
                int currentSrcColumn = colIdx[i];
                dstArray.attributes[currentDstColumn] = this.attributes[currentSrcColumn].clone();
                if (currentSrcColumn == this.decAttrIdx) {
                    dstArray.decAttrIdx = currentDstColumn;
                    if (this.decisionValues != null) {
                        dstArray.decisionValues = (float[])this.decisionValues.clone();
                    }
                }
                if (this.discRanges != null && this.discRanges[currentSrcColumn] != null) {
                    dstArray.discRanges[currentDstColumn] = this.discRanges[currentSrcColumn].clone();
                }
                if (this.domains != null && this.domains[currentSrcColumn] != null) {
                    dstArray.domains[currentDstColumn] = this.domains[currentSrcColumn].clone();
                }
                ++currentDstColumn;
            }
            dstArray.dictionary = this.dictionary.clone();
            int currentDstRow = 0;
            for (int j = 0; j < rowIdx.length; ++j) {
                int currentSrcRow = rowIdx[j];
                currentDstColumn = 0;
                for (int i = 0; i < colIdx.length; ++i) {
                    int currentSrcColumn = colIdx[i];
                    dstArray.valuesArray[currentDstColumn][currentDstRow] = this.valuesArray[currentSrcColumn][currentSrcRow];
                    ++currentDstColumn;
                }
                ++currentDstRow;
            }
            if (dstArray.decAttrIdx == -1) {
                FArray fArray2 = dstArray;
                fArray2.decAttrIdx = fArray2.attributes.length - 1;
                ((Array)dstArray).setAllDecValues();
            }
        }
        return dstArray;
    }

    @Override
    public final void cbind(Array array) {
        Object discRangesTMP;
        FArray fArray = this;
        if (fArray.valuesArray[0].length != array.rowsNumber()) {
            System.err.println("Function cbind cannot be used. Arrays have different numbers of rows.");
            return;
        }
        this.bindAttributes(array.attributes);
        FArray srcArray = (FArray)array;
        if (((Array)this).domainsCreated()) {
            this.domains = new FDomain[this.attributes.length];
        }
        if (this.discRanges != null) {
            discRangesTMP = this.discRanges;
            this.discRanges = new DiscRanges[this.attributes.length];
            for (int i = 0; i < this.discRanges.length; ++i) {
                this.discRanges[i] = i < ((DiscRanges[])discRangesTMP).length ? discRangesTMP[i] : srcArray.discRanges[0].clone();
            }
        }
        discRangesTMP = this;
        int rows = discRangesTMP.valuesArray[0].length;
        float[][] valuesArrayTMP = this.valuesArray;
        this.valuesArray = new float[this.attributes.length][rows];
        int j = 0;
        for (int i = 0; i < this.valuesArray.length; ++i) {
            if (i < valuesArrayTMP.length) {
                this.valuesArray[i] = valuesArrayTMP[i];
                continue;
            }
            if (srcArray.attributes[j].type == 2) {
                this.valuesArray[i] = (float[])srcArray.valuesArray[j++].clone();
                continue;
            }
            if (srcArray.attributes[j].type == 1) {
                for (int k = 0; k < rows; ++k) {
                    ((Array)this).writeValueStr(i, k, ((Array)srcArray).readValueStr(j, k));
                }
                ++j;
                continue;
            }
            System.err.println("Function cbind cannot copy the attribute. Type of attribute: " + srcArray.attributes[j].name + " is not NUMERICAL or NOMINAL.");
        }
        if (this.domains != null) {
            ((Array)this).findDomains();
        }
    }

    @Override
    public final int colsNumber() {
        return this.attributes.length;
    }

    @Override
    public final int rowsNumber() {
        return this.valuesArray[0].length;
    }

    public final boolean isDiscretized() {
        return this.discRanges != null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isDiscretized(int column) {
        void var1_1;
        return this.discRanges != null && this.discRanges[column] != null && this.discRanges[var1_1].getSize() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final float[] getColumn(int column) {
        void var1_1;
        return this.valuesArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getColumnStr(int column) {
        void var1_1;
        void var2_3 = var1_1;
        FArray fArray = this;
        return this.dictionary.toString(fArray.valuesArray[var2_3]);
    }

    public final boolean setColumn(int column, float[] values) {
        block6: {
            block5: {
                FArray fArray = this;
                if (values.length != fArray.valuesArray[0].length) {
                    return false;
                }
                if (column < 0) break block5;
                fArray = this;
                if (column <= fArray.attributes.length) break block6;
            }
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            this.valuesArray[column][i] = values[i];
        }
        return true;
    }

    public final float[] getDecValues() {
        return this.decisionValues;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDecValues(float[] decValues) {
        if (decValues != null) {
            void var1_1;
            this.decisionValues = (float[])var1_1.clone();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getDecValuesStr() {
        void var1_1;
        Object[] decValuesStr = null;
        if (this.attributes[this.decAttrIdx].type == 1) {
            decValuesStr = this.dictionary.toString(this.decisionValues);
        } else if (this.attributes[this.decAttrIdx].type == 2 && this.decisionValues != null) {
            decValuesStr = this.decisionValues;
            String[] stringArray = new String[this.decisionValues.length];
            for (int i = 0; i < decValuesStr.length; ++i) {
                stringArray[i] = Float.toString((float)decValuesStr[i]);
            }
            decValuesStr = stringArray;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean setDecValues(String[] decValues) {
        if (decValues != null) {
            this.decisionValues = new float[((String[])decValues).length];
            if (this.attributes[this.decAttrIdx].type == 1) {
                String[] stringArray = decValues;
                decValues = this.dictionary;
                float[] fArray = new float[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    fArray[i] = ((Dictionary)decValues).toFloat(stringArray[i]);
                }
                this.decisionValues = fArray;
            } else if (this.attributes[this.decAttrIdx].type == 2) {
                void var1_1;
                this.decisionValues = ArrayUtils.string2float((String[])var1_1);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private float[] getUniqueValues$2558073() {
        Float[] floatArray;
        void var1_1;
        HashSet<Float> set = new HashSet<Float>();
        FArray fArray = this;
        int rows = fArray.valuesArray[0].length;
        for (int i = 0; i < rows; ++i) {
            FArray fArray2 = this;
            set.add(Float.valueOf(fArray2.readValue(fArray2.decAttrIdx, i)));
        }
        Float[] floatValues = new Float[1];
        floatArray = (Float[])var1_1.toArray(floatArray);
        return ArrayUtils.float2Float(floatArray);
    }

    @Override
    public final boolean setAllDecValues() {
        this.decisionValues = (float[])(this.attributes[this.decAttrIdx].type == 1 ? this.getUniqueValues$2558073() : null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final float readValue(int column, int row) {
        void var2_2;
        void var1_1;
        return this.valuesArray[var1_1][var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public final void writeValue(int column, int row, float value) {
        void var3_3;
        this.valuesArray[var1_1][var2_2] = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String readValueStr(int column, int row) {
        if (this.attributes[column].type == 1) {
            return this.dictionary.toString(this.valuesArray[column][row]);
        }
        if (this.attributes[column].type == 2) {
            void var2_2;
            void var1_1;
            String strValue = Dictionary.toStringSpecial(this.valuesArray[column][row]);
            if (strValue != null) {
                void var3_3;
                return var3_3;
            }
            return Float.toString(this.valuesArray[var1_1][var2_2]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean writeValueStr(int column, int row, String value) {
        if (this.attributes[column].type == 1) {
            this.valuesArray[column][row] = this.dictionary.toFloat(value);
        } else if (this.attributes[column].type == 2) {
            Float floatValue = Dictionary.toFloatSpecial(value);
            if (floatValue == null) {
                try {
                    floatValue = Float.valueOf(Float.parseFloat(value));
                }
                catch (NumberFormatException numberFormatException) {
                    void var3_3;
                    System.err.println("Error parsing float value: " + (String)var3_3);
                    return false;
                }
            }
            this.valuesArray[var1_1][var2_2] = floatValue.floatValue();
        }
        return true;
    }

    public final boolean checkDecisionValues() {
        if (this.decAttrIdx == -1) {
            System.err.println("Decision Attribute is not Defined!");
            return false;
        }
        if (this.attributes[this.decAttrIdx].type != 1) {
            this.decisionValues = null;
            return true;
        }
        FArray fArray = this;
        int cfr_ignored_0 = fArray.decAttrIdx;
        Float[] uniqueValues = ArrayUtils.float2Float(fArray.getUniqueValues$2558073());
        HashSet set = new HashSet();
        Collections.addAll(set, uniqueValues);
        for (int i = 0; i < this.decisionValues.length; ++i) {
            if (set.contains(Float.valueOf(this.decisionValues[i]))) continue;
            System.err.println("Decision Value is not Present in the Dataset! Value: " + this.dictionary.toString(this.decisionValues[i]));
            return false;
        }
        return true;
    }

    public final boolean calcDecisionValuesTable() {
        int i;
        if (!this.isTargetNominal()) {
            return false;
        }
        System.out.println("Calculation of DecisionValuesTable...");
        HashMap decisionValuesTableTmp = new HashMap();
        for (int i2 = 0; i2 < this.decisionValues.length; ++i2) {
            decisionValuesTableTmp.put(Float.valueOf(this.decisionValues[i2]), new ArrayList());
        }
        int rows = this.valuesArray[this.decAttrIdx].length;
        for (i = 0; i < rows; ++i) {
            float val = this.valuesArray[this.decAttrIdx][i];
            ((ArrayList)decisionValuesTableTmp.get(Float.valueOf(val))).add(i);
        }
        this.decisionValuesTable = new HashMap();
        for (i = 0; i < this.decisionValues.length; ++i) {
            Integer[] tmpInt = new Integer[1];
            this.decisionValuesTable.put(Float.valueOf(this.decisionValues[i]), ArrayUtils.Integer2int(((ArrayList)decisionValuesTableTmp.get(Float.valueOf(this.decisionValues[i]))).toArray(tmpInt)));
        }
        return true;
    }

    public final HashMap<Float, int[]> getDecisionValuesTable() {
        if (this.decisionValuesTable == null) {
            this.calcDecisionValuesTable();
        }
        return this.decisionValuesTable;
    }

    @Override
    public final boolean findDomains() {
        this.domains = new FDomain[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].type != 1) continue;
            this.domains[i] = new FDomain();
            int n = i;
            FArray fArray = this;
            ((FDomain)this.domains[i]).createDomain(fArray.valuesArray[n]);
        }
        return true;
    }

    public final boolean findADXDomains() {
        this.domains = new ADXDomain[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            FArray fArray;
            int n;
            this.domains[i] = new ADXDomain();
            if (this.isDiscretized(i)) {
                n = i;
                fArray = this;
                float[] fArray2 = fArray.valuesArray[n];
                FArray fArray3 = this;
                n = fArray3.decAttrIdx;
                fArray = fArray3;
                ((ADXDomain)this.domains[i]).createDomain(this.discRanges[i].getRanges(), fArray2, fArray3.valuesArray[n], this.decisionValues);
                continue;
            }
            n = i;
            fArray = this;
            float[] fArray4 = fArray.valuesArray[n];
            FArray fArray5 = this;
            n = fArray5.decAttrIdx;
            fArray = fArray5;
            ((ADXDomain)this.domains[i]).createDomain(null, fArray4, fArray5.valuesArray[n], this.decisionValues);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDomain$7a46d43b(int column, FDomain domain) {
        if (this.domains != null) {
            void var2_2;
            this.domains[var1_1] = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final FDomain getFDomain(int column) {
        if (this.domains == null || this.domains[column] == null) {
            return null;
        }
        if (this.domains[column] instanceof FDomain) {
            void var1_1;
            return (FDomain)this.domains[var1_1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final ADXDomain getADXDomain(int column) {
        if (this.domains == null || this.domains[column] == null) {
            return null;
        }
        if (this.domains[column] instanceof ADXDomain) {
            void var1_1;
            return (ADXDomain)this.domains[var1_1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getDomainStr(int column) {
        void var1_1;
        if (this.domains == null || this.domains[column] == null) {
            return null;
        }
        String[] stringArray = this.dictionary.toString(this.domains[var1_1].getDomainValues());
        return stringArray;
    }

    @Override
    public final boolean domainsCreated() {
        return this.domains != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void swapColumns(int source, int destination) {
        void var2_2;
        void var3_3;
        Attribute attributeTmp = this.attributes[source];
        this.attributes[source] = this.attributes[destination];
        this.attributes[destination] = attributeTmp;
        if (this.isDiscretized()) {
            DiscRanges discRangesTmp = this.discRanges[source];
            this.discRanges[source] = this.discRanges[destination];
            this.discRanges[destination] = discRangesTmp;
        }
        if (((Array)this).domainsCreated()) {
            Domain domainTmp = this.domains[source];
            this.domains[source] = this.domains[destination];
            this.domains[destination] = domainTmp;
        }
        float[] eventsArrayTmp = this.valuesArray[source];
        this.valuesArray[source] = this.valuesArray[destination];
        this.valuesArray[destination] = var3_3;
        if (this.decAttrIdx == source) {
            this.decAttrIdx = destination;
            return;
        }
        if (this.decAttrIdx == var2_2) {
            void var1_1;
            this.decAttrIdx = var1_1;
        }
    }

    public final String toString() {
        FArray fArray = this;
        Array2ADX array2ADX = new Array2ADX();
        return ((Array2String)array2ADX).toString(fArray);
    }

    public final String toADH() {
        Array2ADH array2ADH = new Array2ADH();
        return ((Array2String)array2ADH).toString(this);
    }

    public final String toCSV() {
        Array2CSV array2CSV = new Array2CSV();
        return ((Array2String)array2CSV).toString(this);
    }
}

