/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class Randomize
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 8854479785121877582L;
    protected int m_Seed = 42;
    protected Random m_Random;

    public String globalInfo() {
        return "Randomly shuffles the order of instances passed through it. The random number generator is reset with the seed value whenever a new set of instances is passed in.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tSpecify the random number seed (default 42)", "S", 1, "-S <num>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String seedString = Utils.getOption('S', options);
        if (seedString.length() != 0) {
            this.setRandomSeed(Integer.parseInt(seedString));
        } else {
            this.setRandomSeed(42);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        options[current++] = "-S";
        options[current++] = "" + this.getRandomSeed();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String randomSeedTipText() {
        return "Seed for the random number generator.";
    }

    public int getRandomSeed() {
        return this.m_Seed;
    }

    public void setRandomSeed(int newRandomSeed) {
        this.m_Seed = newRandomSeed;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_Random = new Random(this.m_Seed);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.getInputFormat().randomize(this.m_Random);
        }
        int i = 0;
        while (i < this.getInputFormat().numInstances()) {
            this.push(this.getInputFormat().instance(i));
            ++i;
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5548 $");
    }

    public static void main(String[] argv) {
        Randomize.runFilter(new Randomize(), argv);
    }
}

