/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class RELAGGS
extends SimpleBatchFilter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -3333791375278589231L;
    protected int m_MaxCardinality = 20;
    protected Range m_SelectedRange = new Range("first-last");
    protected Hashtable<String, AttributeStats> m_AttStats = new Hashtable();

    @Override
    public String globalInfo() {
        return "A propositionalization filter inspired by the RELAGGS algorithm.\nIt processes all relational attributes that fall into the user defined range (all others are skipped, i.e., not added to the output). Currently, the filter only processes one level of nesting.\nThe class attribute is not touched.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "M.-A. Krogel and S. Wrobel");
        result.setValue(TechnicalInformation.Field.TITLE, "Facets of Aggregation Approaches to Propositionalization");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Work-in-Progress Track at the Thirteenth International Conference on Inductive Logic Programming (ILP)");
        result.setValue(TechnicalInformation.Field.EDITOR, "T. Horvath and A. Yamamoto");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.PDF, "http://kd.cs.uni-magdeburg.de/~krogel/papers/aggs.pdf");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tSpecify list of string attributes to convert to words.\n\t(default: select all relational attributes)", "R", 1, "-R <index1,index2-index4,...>"));
        result.addElement(new Option("\tInverts the matching sense of the selection.", "V", 0, "-V"));
        result.addElement(new Option("\tMax. cardinality of nominal attributes. If a nominal attribute\n\thas more values than this upper limit, then it will be skipped.\n\t(default: 20)", "C", 1, "-C <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setSelectedRange(tmpStr);
        } else {
            this.setSelectedRange("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setMaxCardinality(Integer.parseInt(tmpStr));
        } else {
            this.setMaxCardinality(20);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-R");
        result.add(this.getSelectedRange().getRanges());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        result.add("-C");
        result.add("" + this.getMaxCardinality());
        return result.toArray(new String[result.size()]);
    }

    public String maxCardinalityTipText() {
        return "The maximum number of values a nominal attribute can have before it's skipped.";
    }

    public void setMaxCardinality(int value) {
        this.m_MaxCardinality = value;
    }

    public int getMaxCardinality() {
        return this.m_MaxCardinality;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on; this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; Specify an inclusive range with \"-\"; eg: \"first-3,5,6-10,last\".";
    }

    public void setSelectedRange(String value) {
        this.m_SelectedRange = new Range(value);
    }

    public Range getSelectedRange() {
        return this.m_SelectedRange;
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected attributes in the range will be worked on; if true, only non-selected attributes will be processed.";
    }

    public void setInvertSelection(boolean value) {
        this.m_SelectedRange.setInvert(value);
    }

    public boolean getInvertSelection() {
        return this.m_SelectedRange.getInvert();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_SelectedRange.setUpper(inputFormat.numAttributes() - 1);
        FastVector atts = new FastVector();
        int clsIndex = -1;
        int i = 0;
        while (i < inputFormat.numAttributes()) {
            if (i == inputFormat.classIndex()) {
                clsIndex = atts.size();
                atts.addElement(inputFormat.attribute(i).copy());
            } else if (!inputFormat.attribute(i).isRelationValued()) {
                atts.addElement(inputFormat.attribute(i).copy());
            } else if (!this.m_SelectedRange.isInRange(i)) {
                if (this.getDebug()) {
                    System.out.println("Attribute " + (i + 1) + " (" + inputFormat.attribute(i).name() + ") skipped.");
                }
            } else {
                String prefix = String.valueOf(inputFormat.attribute(i).name()) + "_";
                Instances relFormat = inputFormat.attribute(i).relation();
                int n = 0;
                while (n < relFormat.numAttributes()) {
                    Attribute att = relFormat.attribute(n);
                    if (att.isNumeric()) {
                        atts.addElement(new Attribute(String.valueOf(prefix) + att.name() + "_MIN"));
                        atts.addElement(new Attribute(String.valueOf(prefix) + att.name() + "_MAX"));
                        atts.addElement(new Attribute(String.valueOf(prefix) + att.name() + "_AVG"));
                        atts.addElement(new Attribute(String.valueOf(prefix) + att.name() + "_STDEV"));
                        atts.addElement(new Attribute(String.valueOf(prefix) + att.name() + "_SUM"));
                    } else if (att.isNominal()) {
                        if (att.numValues() <= this.m_MaxCardinality) {
                            int m = 0;
                            while (m < att.numValues()) {
                                atts.addElement(new Attribute(String.valueOf(prefix) + att.name() + "_" + att.value(m) + "_CNT"));
                                ++m;
                            }
                        } else if (this.getDebug()) {
                            System.out.println("Attribute " + (i + 1) + "/" + (n + 1) + " (" + inputFormat.attribute(i).name() + "/" + att.name() + ") skipped, " + att.numValues() + " > " + this.m_MaxCardinality + ".");
                        }
                    } else if (this.getDebug()) {
                        System.out.println("Attribute " + (i + 1) + "/" + (n + 1) + " (" + inputFormat.attribute(i).name() + "/" + att.name() + ") skipped.");
                    }
                    ++n;
                }
            }
            ++i;
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(clsIndex);
        this.initOutputLocators(result, new int[0]);
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        AttributeStats stats;
        Attribute att;
        int n;
        Instances relInstances;
        int k;
        Instances result = this.getOutputFormat();
        this.m_AttStats.clear();
        int i = 0;
        while (i < instances.numAttributes()) {
            if (i != instances.classIndex() && instances.attribute(i).isRelationValued() && this.m_SelectedRange.isInRange(i)) {
                k = 0;
                while (k < instances.numInstances()) {
                    relInstances = instances.instance(k).relationalValue(i);
                    n = 0;
                    while (n < relInstances.numAttributes()) {
                        att = relInstances.attribute(n);
                        stats = null;
                        if (att.isNumeric() || att.isNominal() && att.numValues() <= this.m_MaxCardinality) {
                            stats = relInstances.attributeStats(n);
                            this.m_AttStats.put(String.valueOf(k) + "-" + i + "-" + n, stats);
                        }
                        ++n;
                    }
                    ++k;
                }
            }
            ++i;
        }
        k = 0;
        while (k < instances.numInstances()) {
            Instance inst = instances.instance(k);
            Instance newInst = new Instance(result.numAttributes());
            newInst.setWeight(inst.weight());
            int l = 0;
            i = 0;
            while (i < instances.numAttributes()) {
                if (!instances.attribute(i).isRelationValued()) {
                    newInst.setValue(l, inst.value(i));
                    ++l;
                } else if (this.m_SelectedRange.isInRange(i)) {
                    relInstances = inst.relationalValue(i);
                    n = 0;
                    while (n < relInstances.numAttributes()) {
                        att = relInstances.attribute(n);
                        stats = this.m_AttStats.get(String.valueOf(k) + "-" + i + "-" + n);
                        if (att.isNumeric()) {
                            newInst.setValue(l, stats.numericStats.min);
                            newInst.setValue(++l, stats.numericStats.max);
                            newInst.setValue(++l, stats.numericStats.mean);
                            newInst.setValue(++l, stats.numericStats.stdDev);
                            newInst.setValue(++l, stats.numericStats.sum);
                            ++l;
                        } else if (att.isNominal() && att.numValues() <= this.m_MaxCardinality) {
                            int m = 0;
                            while (m < att.numValues()) {
                                newInst.setValue(l, (double)stats.nominalCounts[m]);
                                ++l;
                                ++m;
                            }
                        }
                        ++n;
                    }
                }
                ++i;
            }
            result.add(newInst);
            ++k;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5547 $");
    }

    public static void main(String[] args) {
        RELAGGS.runFilter(new RELAGGS(), args);
    }
}

