## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(nlist)

## -----------------------------------------------------------------------------
nlist <- nlist(
  x = 1:2,
  y = matrix(c(4:1), nrow = 2),
  z = 5.1
)
print(nlist)
str(nlist)

## -----------------------------------------------------------------------------
nlists <- nlists(
  nlist,
  nlist,
  nlist(
    x = 2:3,
    y = matrix(c(5:8), nrow = 2),
    z = 8
  )
)
print(nlists)
str(nlists)

## -----------------------------------------------------------------------------
as_mcmc(nlist)
as_mcmc(nlists)
str(as_mcmc(nlists))

## -----------------------------------------------------------------------------
as_nlist(as_mcmc(nlist))
as_nlists(as_mcmc(nlists))

## -----------------------------------------------------------------------------
unlist(nlist)

## -----------------------------------------------------------------------------
list <- unlist(nlist)
list[1] <- 100
list["z"] <- -999
relist_nlist(list, nlist)

## -----------------------------------------------------------------------------
as_nlist(data.frame(x = 1:2, y = c(3, 5)))

## -----------------------------------------------------------------------------
as_term_frame(nlist)
as_term_frame(nlists)

## -----------------------------------------------------------------------------
str(as_term_frame(nlists))

