/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.tools;

import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.global.scheduling.FakeResource;
import choco.kernel.solver.constraints.global.scheduling.IResource;
import choco.kernel.solver.constraints.global.scheduling.ResourceParameters;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;

public final class TaskUtils {
    private TaskUtils() {
    }

    public static IResource<TaskVar> createFakeResource(Solver s, Constraint c) {
        ResourceParameters params;
        ComponentConstraint ct;
        if (c.getConstraintType() == ConstraintType.DISJUNCTIVE && c instanceof ComponentConstraint && (ct = (ComponentConstraint)c).getParameters() instanceof ResourceParameters && (params = (ResourceParameters)ct.getParameters()).isRegular()) {
            return new FakeResource((ITask[])VariableUtils.getTaskVar(s, ct.getVariables(), 0, params.getNbRegularTasks()));
        }
        return null;
    }

    public static IResource<?>[] createFakeResources(Solver s, Constraint ... c) {
        IResource[] r = new IResource[c.length];
        for (int i = 0; i < c.length; ++i) {
            r[i] = TaskUtils.createFakeResource(s, c[i]);
        }
        return r;
    }

    public static boolean hasCompulsoryPart(ITask t) {
        return t.getECT() > t.getLST();
    }

    public static boolean hasEnumeratedDomain(TaskVar task) {
        return task.start().hasEnumeratedDomain() || task.end().hasEnumeratedDomain();
    }

    public static int getMinConsumption(IRTask t) {
        int h = t.getMinHeight();
        int d = h > 0 ? t.getTaskVar().getMinDuration() : t.getTaskVar().getMaxDuration();
        return h * d;
    }

    public static int getMaxConsumption(IRTask t) {
        int h = t.getMaxHeight();
        int d = h > 0 ? t.getTaskVar().getMaxDuration() : t.getTaskVar().getMinDuration();
        return h * d;
    }

    public static boolean isRegular(IntDomainVar usage) {
        return usage.isInstantiatedTo(1);
    }

    public static boolean isOptional(IntDomainVar usage) {
        return !usage.isInstantiated();
    }

    public static boolean isEliminated(IntDomainVar usage) {
        return usage.isInstantiatedTo(0);
    }

    public static int getDoubleCentroid(ITask t) {
        return t.getECT() + t.getLST();
    }

    public static int getSlack(ITask t) {
        return t.getLST() - t.getEST();
    }

    public static int getTotalSlack(ITask t1, ITask t2) {
        return TaskUtils.getSlack(t1) + TaskUtils.getSlack(t2);
    }

    public static long getA(IntDomainVar x, IntDomainVar y) {
        return (long)(y.getSup() - y.getInf() + 1) * (long)(x.getSup() - x.getInf() + 1);
    }

    public static long getB(IntDomainVar x, IntDomainVar y) {
        long v = y.getSup() - x.getInf();
        return (v + 1L) * (v + 2L);
    }

    public static long getCmin(IntDomainVar x, IntDomainVar y) {
        long a = y.getInf() - x.getInf();
        return a > 0L ? a * (a + 1L) : 0L;
    }

    public static long getCmax(IntDomainVar x, IntDomainVar y) {
        long a = y.getSup() - x.getSup();
        return a > 0L ? a * (a + 1L) : 0L;
    }

    public static long getPreservedDividend(IntDomainVar x, IntDomainVar y) {
        return TaskUtils.getB(x, y) - TaskUtils.getCmin(x, y) - TaskUtils.getCmax(x, y);
    }

    public static long getPreservedDivisor(IntDomainVar x, IntDomainVar y) {
        return 2L * TaskUtils.getA(x, y);
    }

    public static final double getPreserved(IntDomainVar x, IntDomainVar y) {
        assert (TaskUtils.getPreservedDividend(x, y) <= TaskUtils.getPreservedDivisor(x, y));
        return (double)TaskUtils.getPreservedDividend(x, y) / (double)TaskUtils.getPreservedDivisor(x, y);
    }

    public static final double getPreserved(TaskVar t1, TaskVar t2) {
        return TaskUtils.getPreserved(t1.end(), t2.start());
    }

    public static final double getTotalPreserved(TaskVar t1, TaskVar t2) {
        return TaskUtils.getPreserved(t1, t2) + TaskUtils.getPreserved(t2, t1);
    }

    public static long getPreservedDividend(TaskVar t1, TaskVar t2) {
        return TaskUtils.getPreservedDividend(t1.end(), t2.start());
    }

    public static long getPreservedDivisor(TaskVar t1, TaskVar t2) {
        return TaskUtils.getPreservedDivisor(t1.end(), t2.start());
    }
}

