/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.set;

import choco.cp.solver.variables.delta.BitSetDeltaDomain;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.variables.delta.IDeltaDomain;
import choco.kernel.solver.variables.set.SetSubDomain;
import choco.kernel.solver.variables.set.SetVar;

public class BitSetEnumeratedDomain
implements SetSubDomain {
    protected final int offset;
    protected IStateInt size;
    protected IStateBitSet contents;
    private final int capacity;
    private final IDeltaDomain delatDom;

    public BitSetEnumeratedDomain(SetVar v, int a, int b, boolean full, IEnvironment environment) {
        this.capacity = b - a + 1;
        this.offset = a;
        this.size = full ? environment.makeInt(this.capacity) : environment.makeInt(0);
        this.contents = environment.makeBitSet(this.capacity);
        if (full) {
            for (int i = 0; i < this.capacity; ++i) {
                this.contents.set(i);
            }
        }
        this.delatDom = new BitSetDeltaDomain(this.capacity, this.offset);
    }

    public BitSetEnumeratedDomain(SetVar v, int[] sortedValues, boolean full, IEnvironment environment) {
        int a = sortedValues[0];
        int b = sortedValues[sortedValues.length - 1];
        this.capacity = b - a + 1;
        this.offset = a;
        this.size = full ? environment.makeInt(sortedValues.length) : environment.makeInt(0);
        this.contents = environment.makeBitSet(this.capacity);
        if (full) {
            for (int sortedValue : sortedValues) {
                this.contents.set(sortedValue - a);
            }
        }
        this.delatDom = new BitSetDeltaDomain(this.capacity, this.offset);
    }

    private BitSetEnumeratedDomain(SetVar v, IEnvironment environment) {
        this.capacity = 0;
        this.offset = 0;
        this.size = environment.makeInt(0);
        this.contents = environment.makeBitSet(this.capacity);
        this.delatDom = new BitSetDeltaDomain(this.capacity, this.offset);
    }

    public static BitSetEnumeratedDomain empty(SetVar v, IEnvironment environment) {
        return new BitSetEnumeratedDomain(v, environment);
    }

    @Override
    public int getFirstVal() {
        if (this.size.get() > 0) {
            return this.contents.nextSetBit(0) + this.offset;
        }
        return -1;
    }

    @Override
    public int getLastVal() {
        if (this.size.get() > 0) {
            return this.contents.prevSetBit(this.capacity - 1) + this.offset;
        }
        return -1;
    }

    @Override
    public boolean contains(int x) {
        int i = x - this.offset;
        return i >= 0 && i < this.capacity && this.contents.get(i);
    }

    @Override
    public boolean remove(int x) {
        int i = x - this.offset;
        if (this.contents.get(i)) {
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    private void removeIndex(int i) {
        this.contents.clear(i);
        this.delatDom.remove(i + this.offset);
        if (this.contents.get(i)) {
            LOGGER.severe("etrange etrange");
        }
        this.size.add(-1);
    }

    public boolean add(int x) {
        int i = x - this.offset;
        if (!this.contents.get(i)) {
            this.addIndex(i);
            return true;
        }
        return false;
    }

    private void addIndex(int i) {
        this.contents.set(i);
        this.delatDom.remove(i + this.offset);
        if (!this.contents.get(i)) {
            LOGGER.severe("etrange etrange");
        }
        this.size.add(1);
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public int getNextValue(int x) {
        int i = x - this.offset;
        int val = this.contents.nextSetBit(i + 1);
        if (val > 0) {
            return val + this.offset;
        }
        return -1;
    }

    public int getPrevValue(int x) {
        int i = x - this.offset;
        int val = this.contents.prevSetBit(i - 1);
        if (val > 0) {
            return val + this.offset;
        }
        return -1;
    }

    public boolean hasNextValue(int x) {
        int i = x - this.offset;
        return this.contents.nextSetBit(i + 1) != -1;
    }

    public boolean hasPrevValue(int x) {
        int i = x - this.offset;
        return this.contents.prevSetBit(i - 1) != -1;
    }

    @Override
    public DisposableIntIterator getDeltaIterator() {
        return this.delatDom.iterator();
    }

    @Override
    public IDeltaDomain copyDelta() {
        return this.delatDom.copy();
    }

    @Override
    public void freezeDeltaDomain() {
        this.delatDom.freeze();
    }

    @Override
    public boolean releaseDeltaDomain() {
        return this.delatDom.release();
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return this.delatDom.isReleased();
    }

    @Override
    public void clearDeltaDomain() {
        this.delatDom.clear();
    }

    @Override
    public String pretty() {
        StringBuilder buf = new StringBuilder("{");
        int maxDisplay = 15;
        int count = 0;
        int val = this.getFirstVal();
        if (val > -1) {
            do {
                if (++count > 1) {
                    buf.append(", ");
                }
                buf.append(val);
            } while ((val = this.getNextValue(val)) > -1 && count < maxDisplay);
        }
        if (this.getSize() > maxDisplay) {
            buf.append("..., ");
            buf.append(this.getLastVal());
        }
        buf.append('}');
        return buf.toString();
    }
}

