/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.TimingUtils;
import moa.evaluation.LearningEvaluation;
import moa.options.ClassOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.MainTask;
import moa.tasks.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureStreamSpeed
extends MainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to measure.", InstanceStream.class, "generators.RandomTreeGenerator");
    public IntOption generateSizeOption = new IntOption("generateSize", 'g', "Number of examples.", 10000000, 0, Integer.MAX_VALUE);

    @Override
    public String getPurposeString() {
        return "Measures the speed of a stream.";
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        int numInstances;
        TimingUtils.enablePreciseTiming();
        InstanceStream stream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        long genStartTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
        for (numInstances = 0; numInstances < this.generateSizeOption.getValue(); ++numInstances) {
            stream.nextInstance();
        }
        double genTime = TimingUtils.nanoTimeToSeconds(TimingUtils.getNanoCPUTimeOfCurrentThread() - genStartTime);
        return new LearningEvaluation(new Measurement[]{new Measurement("Number of instances generated", numInstances), new Measurement("Time elapsed", genTime), new Measurement("Instances per second", (double)numInstances / genTime)});
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningEvaluation.class;
    }
}

