/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.algorithm.gengap;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.base.RepeatRecombinator;
import net.sourceforge.jclec.selector.BettersSelector;
import net.sourceforge.jclec.selector.RandomSelector;
import net.sourceforge.jclec.selector.RouletteSelector;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class G3
extends PopulationAlgorithm {
    private static final long serialVersionUID = -2649346083463795286L;
    protected int mu;
    protected int lambda;
    protected RepeatRecombinator recombinator;
    protected int r;
    protected transient List<IIndividual> lset = new ArrayList<IIndividual>();
    protected transient RandomSelector parentsSelector;
    protected transient RandomSelector replacementSelector;
    protected transient RouletteSelector updateSelector;
    protected transient BettersSelector bettersSelector;

    public IRecombinator getRecombinator() {
        return this.recombinator.getDecorated();
    }

    public void setRecombinator(IRecombinator recombinator) {
        if (this.recombinator == null) {
            this.recombinator = new RepeatRecombinator(this);
        }
        this.recombinator.setDecorated(recombinator);
    }

    public final int getMu() {
        return this.mu;
    }

    public final void setMu(int mu) {
        this.mu = mu;
    }

    public final int getLambda() {
        return this.lambda;
    }

    public final void setLambda(int lambda) {
        this.lambda = lambda;
    }

    public final int getR() {
        return this.r;
    }

    public final void setR(int r) {
        this.r = r;
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        int mu = configuration.getInt("mu");
        this.setMu(mu);
        int lambda = configuration.getInt("lambda");
        this.setLambda(lambda);
        try {
            String recombinatorClassname = configuration.getString("recombinator[@type]");
            Class<?> recombinatorClass = Class.forName(recombinatorClassname);
            IRecombinator recombinator = (IRecombinator)recombinatorClass.newInstance();
            if (recombinator instanceof IConfigure) {
                Configuration recombinatorConfiguration = configuration.subset("recombinator");
                ((IConfigure)((Object)recombinator)).configure(recombinatorConfiguration);
            }
            this.setRecombinator(recombinator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal recombinator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        int r = configuration.getInt("r");
        this.setR(r);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof G3) {
            G3 cother = (G3)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.mu, cother.mu);
            eb.append(this.lambda, cother.lambda);
            eb.append(this.recombinator, cother.recombinator);
            eb.append(this.r, cother.r);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public void doInit() {
        super.doInit();
        this.parentsSelector = new RandomSelector(this);
        this.replacementSelector = new RandomSelector(this);
        this.updateSelector = new RouletteSelector(this);
        this.bettersSelector = new BettersSelector(this);
        this.setNumberOfRecombinatorRepetitions();
    }

    @Override
    protected void doSelection() {
        IIndividual bestInB = this.bettersSelector.select(this.bset, 1).get(0);
        this.bset.remove(bestInB);
        this.pset = this.parentsSelector.select(this.bset, this.mu - 1);
        this.pset.add(bestInB);
        this.bset.add(bestInB);
    }

    @Override
    protected void doGeneration() {
        this.cset = this.recombinator.recombine(this.pset);
        this.evaluator.evaluate(this.cset);
    }

    @Override
    protected void doReplacement() {
        this.rset = this.replacementSelector.select(this.bset, this.r, false);
        this.bset.removeAll(this.rset);
    }

    @Override
    protected void doUpdate() {
        this.cset.addAll(this.rset);
        List<IIndividual> rprimeset = this.bettersSelector.select(this.cset, this.r);
        this.bset.addAll(rprimeset);
    }

    private final void setNumberOfRecombinatorRepetitions() {
        int ppl = this.recombinator.getDecorated().getPpl();
        int spl = this.recombinator.getDecorated().getSpl();
        int nor = this.lambda * ppl / (this.mu * spl);
        this.recombinator.setNumberOfRepetitions(nor);
    }
}

