/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cycles;

import java.util.BitSet;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropAcyclic
extends Propagator<GraphVar<?>> {
    private final GraphVar<?> g;
    private final IGraphDeltaMonitor gdm;
    private final int n;
    private final BitSet rfFrom;
    private final BitSet rfTo;
    private final int[] fifo;

    public PropAcyclic(GraphVar<?> g) {
        super((Variable[])new GraphVar[]{g}, (Priority)PropagatorPriority.LINEAR, true);
        this.g = g;
        this.n = g.getNbMaxNodes();
        this.fifo = new int[this.n];
        this.rfFrom = new BitSet(this.n);
        this.rfTo = new BitSet(this.n);
        this.gdm = g.monitorDelta(this);
    }

    @Override
    public int getPropagationConditions(int idx) {
        return GraphEventType.ADD_EDGE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.g.removeEdge(i, i, this);
            if (this.g.getMandatorySuccessorsOf(i).size() <= 0) continue;
            for (int j = 0; j < this.n; ++j) {
                if (!this.g.getMandatorySuccessorsOf(i).contains(j)) continue;
                this.propagateIJ(i, j);
            }
        }
        this.gdm.startMonitoring();
    }

    @Override
    public void propagate(int idx, int mask) throws ContradictionException {
        this.gdm.forEachEdge(this::propagateIJ, GraphEventType.ADD_EDGE);
    }

    private void propagateIJ(int from, int to) throws ContradictionException {
        int j;
        ISetIterator iSetIterator;
        ISet nei;
        if (this.g.isDirected()) {
            this.g.removeEdge(to, from, this);
        }
        int first = 0;
        int last = 0;
        int ik = to;
        this.rfTo.clear();
        this.fifo[last++] = ik;
        this.rfTo.set(ik);
        while (first < last) {
            ik = this.fifo[first++];
            nei = this.g.getMandatorySuccessorsOf(ik);
            iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (j == from || this.rfTo.get(j)) continue;
                this.rfTo.set(j);
                this.fifo[last++] = j;
            }
        }
        first = 0;
        last = 0;
        ik = from;
        this.rfFrom.clear();
        this.fifo[last++] = ik;
        this.rfFrom.set(ik);
        while (first < last) {
            ik = this.fifo[first++];
            nei = this.g.getMandatoryPredecessorsOf(ik);
            iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (j == to || this.rfFrom.get(j)) continue;
                this.rfFrom.set(j);
                this.fifo[last++] = j;
            }
        }
        ISetIterator iSetIterator2 = this.g.getPotentialNodes().iterator();
        while (iSetIterator2.hasNext()) {
            int i = (Integer)iSetIterator2.next();
            if (!this.rfTo.get(i)) continue;
            ISet nei2 = this.g.getPotentialSuccessorsOf(i);
            ISetIterator iSetIterator3 = nei2.iterator();
            while (iSetIterator3.hasNext()) {
                int j2 = (Integer)iSetIterator3.next();
                if (!this.rfFrom.get(j2) || i == from && j2 == to || i == to && j2 == from) continue;
                this.g.removeEdge(i, j2, this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.g instanceof UndirectedGraphVar) {
            ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
            while (iSetIterator.hasNext()) {
                int root = (Integer)iSetIterator.next();
                boolean[] visited = new boolean[this.g.getNbMaxNodes()];
                int[] parent = new int[this.g.getNbMaxNodes()];
                visited[root] = true;
                parent[root] = root;
                int[] stack = new int[this.g.getNbMaxNodes()];
                int last = 0;
                stack[last] = root;
                while (last >= 0) {
                    int current = stack[last--];
                    ISetIterator iSetIterator2 = this.g.getMandatorySuccessorsOf(current).iterator();
                    while (iSetIterator2.hasNext()) {
                        int j = (Integer)iSetIterator2.next();
                        if (visited[j]) {
                            if (j != current && j == parent[current]) continue;
                            return ESat.FALSE;
                        }
                        visited[j] = true;
                        parent[j] = current;
                        stack[++last] = j;
                    }
                }
            }
        } else {
            StrongConnectivityFinder scfinder = new StrongConnectivityFinder((DirectedGraph)this.g.getLB());
            scfinder.findAllSCC();
            if (this.g.getMandatoryNodes().size() - scfinder.getNbSCC() > 0) {
                return ESat.FALSE;
            }
        }
        if (!this.isCompletelyInstantiated()) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }
}

