/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.basic;

import java.util.BitSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.nvalue.amnv.mis.F;
import org.chocosolver.solver.constraints.nary.nvalue.amnv.mis.MDRk;
import org.chocosolver.solver.constraints.nary.nvalue.amnv.rules.R;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropNbCliques
extends Propagator<Variable> {
    private final UndirectedGraphVar g;
    private final UndirectedGraph support;
    private final IntVar[] nb;
    private final R[] rules;
    private final F heur;
    private int delta;

    public PropNbCliques(UndirectedGraphVar g, IntVar nb) {
        super(new Variable[]{g, nb}, (Priority)PropagatorPriority.QUADRATIC, false);
        this.g = g;
        this.support = new UndirectedGraph(g.getNbMaxNodes(), SetType.BITSET, false);
        this.nb = new IntVar[]{nb};
        this.rules = new R[]{new Rcustom()};
        this.heur = new MDRk(this.support, 30);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        int n = this.g.getNbMaxNodes();
        this.support.getNodes().clear();
        for (int i2 = 0; i2 < n; ++i2) {
            this.support.getNeighborsOf(i2).clear();
        }
        ISet nodes = this.g.getMandatoryNodes();
        R[] rArray = nodes.iterator();
        while (rArray.hasNext()) {
            i = (Integer)rArray.next();
            this.support.addNode(i);
        }
        rArray = nodes.iterator();
        while (rArray.hasNext()) {
            i = (Integer)rArray.next();
            ISet nei = this.g.getPotentialNeighborsOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.support.addEdge(i, j);
            }
        }
        this.delta = n - this.g.getMandatoryNodes().size();
        this.heur.prepare();
        do {
            this.heur.computeMIS();
            for (R rule : this.rules) {
                rule.filter(this.nb, this.support, this.heur, this);
            }
        } while (this.heur.hasNextMIS());
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    class Rcustom
    implements R {
        Rcustom() {
        }

        @Override
        public void filter(IntVar[] nbCliques, UndirectedGraph graph, F heur, Propagator aCause) throws ContradictionException {
            assert (nbCliques.length == 1);
            int n = graph.getNbMaxNodes();
            BitSet mis = heur.getMIS();
            int LB = heur.getMIS().cardinality() - PropNbCliques.this.delta;
            nbCliques[0].updateLowerBound(LB, (ICause)aCause);
            if (LB == nbCliques[0].getUB()) {
                int i = mis.nextClearBit(0);
                while (i >= 0 && i < n) {
                    int mate = -1;
                    ISet nei = graph.getNeighborsOf(i);
                    ISetIterator iSetIterator = nei.iterator();
                    while (iSetIterator.hasNext()) {
                        int j = (Integer)iSetIterator.next();
                        if (!mis.get(j)) continue;
                        if (mate == -1) {
                            mate = j;
                            continue;
                        }
                        if (mate < 0) continue;
                        mate = -2;
                        break;
                    }
                    if (mate >= 0) {
                        PropNbCliques.this.g.enforceEdge(i, mate, aCause);
                    }
                    i = mis.nextClearBit(i + 1);
                }
            }
        }
    }
}

