/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.lns.neighbors.IntNeighbor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.MathUtils;

public class PropagationGuidedNeighborhood
extends IntNeighbor {
    protected final int n;
    protected int[] curDoms;
    protected int[] befDoms;
    protected int[] all;
    protected Random rd;
    final double desiredSize;
    double size;
    int listSize;
    double logSum = 0.0;
    List<Integer> candidates;
    protected BitSet fragment;
    protected Model mModel;

    public PropagationGuidedNeighborhood(IntVar[] vars, double desiredSize, int listSize, long seed) {
        super(vars);
        this.mModel = vars[0].getModel();
        this.n = vars.length;
        this.rd = new Random(seed);
        this.desiredSize = desiredSize;
        this.listSize = listSize;
        this.all = new int[this.n];
        this.candidates = new ArrayList<Integer>();
        this.fragment = new BitSet(this.n);
    }

    @Override
    public void fixSomeVariables() throws ContradictionException {
        this.logSum = Arrays.stream(this.variables).mapToDouble(v -> MathUtils.log2(v.getDomainSize())).sum();
        System.arraycopy(this.curDoms, 0, this.befDoms, 0, this.curDoms.length);
        this.fragment.set(0, this.n);
        this.update();
    }

    protected void update() throws ContradictionException {
        while (this.logSum > this.size && this.fragment.cardinality() > 0) {
            int id = this.selectVariable();
            if (this.variables[id].contains(this.values[id])) {
                this.freeze(id);
                this.mModel.getSolver().propagate();
                this.fragment.clear(id);
                this.logSum = 0.0;
                for (int i2 = 0; i2 < this.n; ++i2) {
                    int ds = this.variables[i2].getDomainSize();
                    this.logSum += Math.log(ds);
                    if (!this.fragment.get(i2)) continue;
                    if (ds == 1) {
                        this.fragment.clear(i2);
                        continue;
                    }
                    if (this.curDoms[i2] - ds <= 0) continue;
                    this.all[i2] = this.befDoms[i2] - ds;
                    this.befDoms[i2] = ds;
                }
                this.candidates = IntStream.range(0, this.n).filter(i -> this.fragment.get(i) && this.all[i] > 0).boxed().sorted(Comparator.comparingInt(i -> -this.all[i])).limit(this.listSize).collect(Collectors.toList());
                continue;
            }
            this.fragment.clear(id);
            this.logSum -= Math.log(this.variables[id].getDomainSize());
        }
    }

    int selectVariable() {
        int id;
        if (this.candidates.isEmpty()) {
            id = this.fragment.nextSetBit(0);
            for (int cc = this.rd.nextInt(this.fragment.cardinality()); id >= 0 && cc > 0; --cc) {
                id = this.fragment.nextSetBit(id + 1);
            }
        } else {
            id = this.candidates.remove(0);
        }
        return id;
    }

    @Override
    public void loadFromSolution(Solution solution) {
        super.loadFromSolution(solution);
        this.size = this.desiredSize;
    }

    @Override
    public void recordSolution() {
        super.recordSolution();
        this.size = this.desiredSize;
    }

    @Override
    public void restrictLess() {
        this.size *= 1.01;
    }

    @Override
    public void init() {
        this.curDoms = new int[this.n];
        this.befDoms = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.curDoms[i] = this.variables[i].getDomainSize();
        }
    }
}

