/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnumValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.VersionUtil;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.visitors.AbstractVisitor;

public abstract class VersionInspector
extends AbstractVisitor {
    public abstract void handleAdded(PMMLObject var1, AnnotatedElement var2, Added var3);

    public abstract void handleRemoved(PMMLObject var1, AnnotatedElement var2, Removed var3);

    public abstract void handleOptional(PMMLObject var1, AnnotatedElement var2, Optional var3);

    public abstract void handleRequired(PMMLObject var1, AnnotatedElement var2, Required var3);

    @Override
    public VisitorAction visit(PMMLObject object) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            this.inspect(object, clazz);
        }
        List<Field> fields = ReflectionUtil.getFields(object.getClass());
        for (Field field : fields) {
            Field enumField;
            Object value = ReflectionUtil.getFieldValue(field, object);
            this.inspect(object, field, value);
            if (!(value instanceof Enum)) continue;
            Enum enumValue = (Enum)value;
            try {
                Class<?> enumClazz = enumValue.getClass();
                enumField = enumClazz.getField(enumValue.name());
            }
            catch (NoSuchFieldException nsfe) {
                throw new RuntimeException(nsfe);
            }
            this.inspect(object, enumField);
        }
        return super.visit(object);
    }

    @Override
    public VisitorAction visit(Apply apply) {
        String function = apply.getFunction();
        final Version version = VersionUtil.getVersion(function);
        if (version != null) {
            Added added = new Added(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Added.class;
                }

                @Override
                public Version value() {
                    return version;
                }

                @Override
                public boolean removable() {
                    return false;
                }
            };
            this.handleAdded(apply, PMMLAttributes.APPLY_FUNCTION, added);
        }
        return super.visit(apply);
    }

    private void inspect(PMMLObject object, AnnotatedElement element) {
        Removed removed;
        Added added = element.getAnnotation(Added.class);
        if (added != null) {
            this.handleAdded(object, element, added);
        }
        if ((removed = element.getAnnotation(Removed.class)) != null) {
            this.handleRemoved(object, element, removed);
        }
    }

    private void inspect(PMMLObject object, Field field, Object value) {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            if (ReflectionUtil.isDefaultValue(value)) {
                return;
            }
        } else if (VersionInspector.isNull(value)) {
            Required required;
            Optional optional = field.getAnnotation(Optional.class);
            if (optional != null) {
                this.handleOptional(object, field, optional);
            }
            if ((required = field.getAnnotation(Required.class)) != null) {
                this.handleRequired(object, field, required);
            }
            return;
        }
        this.inspect(object, field);
    }

    private static boolean isNull(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty();
        }
        return value == null;
    }

    protected static boolean isAttribute(Field field) {
        XmlAttribute xmlAttribute = field.getAnnotation(XmlAttribute.class);
        return xmlAttribute != null;
    }

    protected static boolean isEnumValue(Field field) {
        XmlEnumValue xmlEnumValue = field.getAnnotation(XmlEnumValue.class);
        return xmlEnumValue != null;
    }

    protected static boolean isElement(Field field) {
        XmlElement xmlElement = field.getAnnotation(XmlElement.class);
        XmlElements xmlElements = field.getAnnotation(XmlElements.class);
        return xmlElement != null || xmlElements != null;
    }
}

