/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.Alphabet;
import cc.mallet.types.BiNormalSeparation;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.RankedFeatureVector;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBiNormalSeparation
extends TestCase {
    public TestBiNormalSeparation(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestBiNormalSeparation.class);
    }

    public void testBiNormalSeparation() {
        BinaryTestData binaryTestData = new BinaryTestData(4);
        binaryTestData.addInstance(new int[]{0, 1}, true);
        binaryTestData.addInstance(new int[]{0, 2}, true);
        binaryTestData.addInstance(new int[]{2, 3}, false);
        binaryTestData.addInstance(new int[]{3}, false);
        InstanceList iList = binaryTestData.getInstanceList();
        RankedFeatureVector rankedFeatureVector = new BiNormalSeparation.Factory().newRankedFeatureVector(iList);
        TestBiNormalSeparation.assertEquals(6.58, rankedFeatureVector.getValueAtRank(0), 0.005);
        TestBiNormalSeparation.assertEquals(3.29, rankedFeatureVector.getValueAtRank(2), 0.005);
        TestBiNormalSeparation.assertEquals(0.0, rankedFeatureVector.getValueAtRank(3), 0.0);
        TestBiNormalSeparation.assertEquals(6.58, rankedFeatureVector.getValueAtRank(1), 0.005);
        TestBiNormalSeparation.assertEquals(2, rankedFeatureVector.getIndexAtRank(3));
        TestBiNormalSeparation.assertEquals(1, rankedFeatureVector.getIndexAtRank(2));
    }

    static class BinaryTestData {
        InstanceList iList;
        Alphabet dataAlphabet;
        Label posLabel;
        Label negLabel;

        BinaryTestData(int numFeatures) {
            LabelAlphabet labelAlphabet = new LabelAlphabet();
            this.posLabel = labelAlphabet.lookupLabel("pos", true);
            this.negLabel = labelAlphabet.lookupLabel("neg", true);
            ArrayList<String> featureNames = new ArrayList<String>();
            for (int i = 0; i < numFeatures; ++i) {
                featureNames.add(Integer.toString(i));
            }
            this.dataAlphabet = new Alphabet(featureNames.toArray());
            this.iList = new InstanceList(this.dataAlphabet, labelAlphabet);
        }

        void addInstance(int[] features, boolean positive) {
            FeatureVector featureVector = new FeatureVector(this.dataAlphabet, features);
            Instance instance = new Instance(featureVector, positive ? this.posLabel : this.negLabel, null, null);
            this.iList.add(instance);
        }

        InstanceList getInstanceList() {
            return this.iList;
        }
    }
}

