/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationConverter;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.regression.IUserSource;
import ec.tstoolkit.timeseries.regression.TsVariables;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class TsVariable
extends AbstractSingleTsVariable
implements IUserSource {
    private String name;
    private String desc_ = "";
    private TsData tsdata_;
    private static final InformationConverter<TsVariable> tsvar = new TsVariableConverter();

    public TsVariable(TsData tsdata) {
        this.tsdata_ = tsdata;
    }

    public TsVariable(String desc, TsData tsdata) {
        this.desc_ = desc;
        this.tsdata_ = tsdata;
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        int n;
        if (this.tsdata_ == null) {
            return;
        }
        TsDomain domain = this.tsdata_.getDomain();
        int istart = start.minus(domain.getStart());
        int iend = istart + data.getLength();
        int jstart = 0;
        int jend = data.getLength();
        if (istart < 0) {
            data.range(0, -istart).set(0.0);
            jstart = -istart;
            istart = 0;
        }
        if (iend > (n = domain.getLength())) {
            data.range(jend - iend + n, jend).set(0.0);
            jend = jend - iend + n;
            iend = n;
        }
        data.range(jstart, jend).copy(new DataBlock(this.tsdata_.internalStorage(), istart, iend, 1));
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return this.tsdata_ != null ? this.tsdata_.getFrequency() : null;
    }

    @Override
    public String getDescription(TsFrequency context) {
        return this.desc_;
    }

    @Override
    public TsDomain getDefinitionDomain() {
        return this.tsdata_ != null ? this.tsdata_.getDomain() : null;
    }

    public TsData getTsData() {
        return this.tsdata_;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        if (this.tsdata_ == null) {
            return false;
        }
        if (domain.getFrequency() != this.tsdata_.getFrequency()) {
            return false;
        }
        TsDomain idom = domain.intersection(this.tsdata_.getDomain());
        if (idom.isEmpty()) {
            return false;
        }
        int start = idom.getStart().minus(this.tsdata_.getStart());
        return !new DataBlock(this.tsdata_.internalStorage(), start, start + idom.getLength(), 1).isZero();
    }

    protected void setDescription(String desc) {
        this.desc_ = desc;
    }

    protected void setData(TsData s) {
        this.tsdata_ = s;
    }

    @Override
    public String getName() {
        return this.name == null ? "var" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static void register() {
        TsVariables.LINKER.register("static time series", TsVariable.class, tsvar);
    }

    private static class TsVariableConverter
    implements InformationConverter<TsVariable> {
        static final String TYPE = "static time series";
        static final String DATA = "data";
        static final String DESC = "description";

        private TsVariableConverter() {
        }

        @Override
        public TsVariable decode(InformationSet info) {
            TsData data = info.get(DATA, TsData.class);
            String desc = info.get(DESC, String.class);
            return new TsVariable(desc, data);
        }

        @Override
        public InformationSet encode(TsVariable t, boolean verbose) {
            InformationSet info = new InformationSet();
            info.set(DATA, t.getTsData());
            info.set(DESC, t.getDescription());
            return info;
        }

        @Override
        public Class<TsVariable> getInformationType() {
            return TsVariable.class;
        }

        @Override
        public String getTypeDescription() {
            return TYPE;
        }
    }
}

