/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.ast.ASTConditionalExpression;
import net.sourceforge.pmd.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.ast.ASTEqualityExpression;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.ast.SimpleNode;

public class ConfusingTernary
extends AbstractRule {
    public Object visit(ASTIfStatement node, Object data) {
        SimpleNode jnode;
        SimpleNode inode;
        if (node.jjtGetNumChildren() == 3 && (inode = (SimpleNode)node.jjtGetChild(0)) instanceof ASTExpression && inode.jjtGetNumChildren() == 1 && ConfusingTernary.isMatch(jnode = (SimpleNode)inode.jjtGetChild(0))) {
            this.addViolation(data, node);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        SimpleNode inode;
        if (node.jjtGetNumChildren() > 0 && ConfusingTernary.isMatch(inode = (SimpleNode)node.jjtGetChild(0))) {
            this.addViolation(data, node);
        }
        return super.visit(node, data);
    }

    private static boolean isMatch(SimpleNode node) {
        return ConfusingTernary.isUnaryNot(node) || ConfusingTernary.isNotEquals(node) || ConfusingTernary.isConditionalWithAllMatches(node) || ConfusingTernary.isParenthesisAroundMatch(node);
    }

    private static boolean isUnaryNot(SimpleNode node) {
        return node instanceof ASTUnaryExpressionNotPlusMinus && "!".equals(node.getImage());
    }

    private static boolean isNotEquals(SimpleNode node) {
        return node instanceof ASTEqualityExpression && "!=".equals(node.getImage());
    }

    private static boolean isConditionalWithAllMatches(SimpleNode node) {
        if (!(node instanceof ASTConditionalAndExpression) && !(node instanceof ASTConditionalOrExpression)) {
            return false;
        }
        int i_max = node.jjtGetNumChildren();
        if (i_max <= 0) {
            return false;
        }
        for (int i = 0; i < i_max; ++i) {
            SimpleNode inode = (SimpleNode)node.jjtGetChild(i);
            if (ConfusingTernary.isMatch(inode)) continue;
            return false;
        }
        return true;
    }

    private static boolean isParenthesisAroundMatch(SimpleNode node) {
        if (!(node instanceof ASTPrimaryExpression) || node.jjtGetNumChildren() != 1) {
            return false;
        }
        SimpleNode inode = (SimpleNode)node.jjtGetChild(0);
        if (!(inode instanceof ASTPrimaryPrefix) || inode.jjtGetNumChildren() != 1) {
            return false;
        }
        SimpleNode jnode = (SimpleNode)inode.jjtGetChild(0);
        if (!(jnode instanceof ASTExpression) || jnode.jjtGetNumChildren() != 1) {
            return false;
        }
        SimpleNode knode = (SimpleNode)jnode.jjtGetChild(0);
        return ConfusingTernary.isMatch(knode);
    }
}

