/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.PageSequence;
import org.apache.fop.complexscripts.bidi.BidiResolver;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractPageSequenceLayoutManager;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageBreaker;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;
import org.apache.fop.traits.MinOptMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSequenceLayoutManager
extends AbstractPageSequenceLayoutManager {
    private static Log log = LogFactory.getLog(PageSequenceLayoutManager.class);
    private PageProvider pageProvider;
    private PageBreaker pageBreaker;
    private List<List<KnuthElement>> tableHeaderFootnotes;
    private List<List<KnuthElement>> tableFooterFootnotes;
    private int startIntrusionAdjustment;
    private int endIntrusionAdjustment;

    public PageSequenceLayoutManager(AreaTreeHandler ath, org.apache.fop.fo.pagination.PageSequence pseq) {
        super(ath, pseq);
        this.pageProvider = new PageProvider(ath, pseq);
    }

    public PageProvider getPageProvider() {
        return this.pageProvider;
    }

    protected org.apache.fop.fo.pagination.PageSequence getPageSequence() {
        return (org.apache.fop.fo.pagination.PageSequence)this.pageSeq;
    }

    @Override
    public PageSequenceLayoutManager getPSLM() {
        return this;
    }

    public FlowLayoutManager getFlowLayoutManager() {
        if (this.pageBreaker == null) {
            throw new IllegalStateException("This method can be called only during layout");
        }
        return this.pageBreaker.getCurrentChildLM();
    }

    @Override
    public void activateLayout() {
        this.initialize();
        if (this.areaTreeHandler.isComplexScriptFeaturesEnabled()) {
            BidiResolver.resolveInlineDirectionality(this.getPageSequence());
        }
        LineArea title = null;
        if (this.getPageSequence().getTitleFO() != null) {
            try {
                ContentLayoutManager clm = this.getLayoutManagerMaker().makeContentLayoutManager(this, this.getPageSequence().getTitleFO());
                Area parentArea = clm.getParentArea(null);
                assert (parentArea instanceof LineArea);
                title = (LineArea)parentArea;
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        AreaTreeModel areaTreeModel = this.areaTreeHandler.getAreaTreeModel();
        PageSequence pageSequenceAreaObject = new PageSequence(title);
        this.transferExtensions(pageSequenceAreaObject);
        pageSequenceAreaObject.setLocale(this.getPageSequence().getLocale());
        areaTreeModel.startPageSequence(pageSequenceAreaObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting layout");
        }
        this.curPage = this.makeNewPage(false);
        this.pageBreaker = new PageBreaker(this);
        int flowBPD = this.getCurrentPV().getBodyRegion().getRemainingBPD();
        this.pageBreaker.doLayout(flowBPD);
        this.finishPage();
    }

    @Override
    public void finishPageSequence() {
        if (this.pageSeq.hasId()) {
            this.idTracker.signalIDProcessed(this.pageSeq.getId());
        }
        this.pageSeq.getRoot().notifyPageSequenceFinished(this.currentPageNum, this.currentPageNum - this.startPageNum + 1);
        this.areaTreeHandler.notifyPageSequenceFinished(this.pageSeq, this.currentPageNum - this.startPageNum + 1);
        this.getPageSequence().releasePageSequence();
        String masterReference = this.getPageSequence().getMasterReference();
        PageSequenceMaster pageSeqMaster = this.pageSeq.getRoot().getLayoutMasterSet().getPageSequenceMaster(masterReference);
        if (pageSeqMaster != null) {
            pageSeqMaster.reset();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ending layout");
        }
    }

    @Override
    protected Page createPage(int pageNumber, boolean isBlank) {
        return this.pageProvider.getPage(isBlank, pageNumber, 0);
    }

    @Override
    protected Page makeNewPage(boolean isBlank) {
        Page newPage = super.makeNewPage(isBlank);
        if (!isBlank) {
            while (!this.getPageSequence().getMainFlow().getFlowName().equals(newPage.getSimplePageMaster().getRegion(58).getRegionName())) {
                newPage = super.makeNewPage(isBlank);
            }
        }
        return newPage;
    }

    private void layoutSideRegion(int regionID) {
        SideRegion reg = (SideRegion)this.curPage.getSimplePageMaster().getRegion(regionID);
        if (reg == null) {
            return;
        }
        StaticContent sc = this.getPageSequence().getStaticContent(reg.getRegionName());
        if (sc == null) {
            return;
        }
        StaticContentLayoutManager lm = this.getLayoutManagerMaker().makeStaticContentLayoutManager(this, sc, reg);
        lm.doLayout();
    }

    @Override
    protected void finishPage() {
        this.layoutSideRegion(57);
        this.layoutSideRegion(56);
        this.layoutSideRegion(61);
        this.layoutSideRegion(59);
        super.finishPage();
    }

    protected int getForcedLastPageNum(int lastPageNum) {
        int forcedLastPageNum = lastPageNum;
        int relativeLastPage = lastPageNum - this.startPageNum + 1;
        if (relativeLastPage % 2 != 0 && (this.getPageSequence().getForcePageCount() == 43 || this.getPageSequence().getForcePageCount() == 40)) {
            ++forcedLastPageNum;
        } else if (relativeLastPage % 2 == 0 && (this.getPageSequence().getForcePageCount() == 99 || this.getPageSequence().getForcePageCount() == 41)) {
            ++forcedLastPageNum;
        }
        return forcedLastPageNum;
    }

    boolean isOnFirstPage(int partIndex) {
        return this.pageProvider.isOnFirstPage(partIndex);
    }

    public void addTableHeaderFootnotes(List<List<KnuthElement>> headerFootnotes) {
        if (this.tableHeaderFootnotes == null) {
            this.tableHeaderFootnotes = new ArrayList<List<KnuthElement>>();
        }
        this.tableHeaderFootnotes.addAll(headerFootnotes);
    }

    public List<List<KnuthElement>> getTableHeaderFootnotes() {
        return this.getTableFootnotes(this.tableHeaderFootnotes);
    }

    public void addTableFooterFootnotes(List<List<KnuthElement>> footerFootnotes) {
        if (this.tableFooterFootnotes == null) {
            this.tableFooterFootnotes = new ArrayList<List<KnuthElement>>();
        }
        this.tableFooterFootnotes.addAll(footerFootnotes);
    }

    public List<List<KnuthElement>> getTableFooterFootnotes() {
        return this.getTableFootnotes(this.tableFooterFootnotes);
    }

    private List<List<KnuthElement>> getTableFootnotes(List<List<KnuthElement>> tableFootnotes) {
        if (tableFootnotes == null) {
            List<List<KnuthElement>> emptyList = Collections.emptyList();
            return emptyList;
        }
        return tableFootnotes;
    }

    public void clearTableHeadingFootnotes() {
        if (this.tableHeaderFootnotes != null) {
            this.tableHeaderFootnotes.clear();
        }
        if (this.tableFooterFootnotes != null) {
            this.tableFooterFootnotes.clear();
        }
    }

    public void setStartIntrusionAdjustment(int sia) {
        this.startIntrusionAdjustment = sia;
    }

    public void setEndIntrusionAdjustment(int eia) {
        this.endIntrusionAdjustment = eia;
    }

    public int getStartIntrusionAdjustment() {
        return this.startIntrusionAdjustment;
    }

    public int getEndIntrusionAdjustment() {
        return this.endIntrusionAdjustment;
    }

    public void recordEndOfFloat(int fHeight) {
        this.pageBreaker.handleEndOfFloat(fHeight);
    }

    public boolean handlingEndOfFloat() {
        return this.pageBreaker.handlingEndOfFloat();
    }

    public int getOffsetDueToFloat() {
        return this.pageBreaker.getOffsetDueToFloat();
    }

    public void recordStartOfFloat(int fHeight, int fYOffset) {
        this.pageBreaker.handleStartOfFloat(fHeight, fYOffset);
    }

    public boolean handlingStartOfFloat() {
        return this.pageBreaker.handlingStartOfFloat();
    }

    public int getFloatHeight() {
        return this.pageBreaker.getFloatHeight();
    }

    public int getFloatYOffset() {
        return this.pageBreaker.getFloatYOffset();
    }

    public int getCurrentColumnWidth() {
        int flowIPD = this.getCurrentPV().getCurrentSpan().getColumnWidth();
        return flowIPD -= this.startIntrusionAdjustment + this.endIntrusionAdjustment;
    }

    public void holdFootnotes(List fl, List ll, int tfl, int ifl, boolean fp, boolean nf, int fnfi, int fli, int fei, MinOptMax fsl, int pfli, int pfei) {
        if (fl != null && fl.size() > 0) {
            this.pageBreaker.holdFootnotes(fl, ll, tfl, ifl, fp, nf, fnfi, fli, fei, fsl, pfli, pfei);
        }
    }

    public void retrieveFootnotes(PageBreakingAlgorithm alg) {
        this.pageBreaker.retrieveFootones(alg);
    }
}

