/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.XBLOMContentElement;
import org.apache.batik.apps.svgbrowser.DOMDocumentTree;
import org.apache.batik.apps.svgbrowser.DOMDocumentTreeController;
import org.apache.batik.apps.svgbrowser.DOMViewerController;
import org.apache.batik.apps.svgbrowser.DropDownHistoryModel;
import org.apache.batik.apps.svgbrowser.ElementOverlayController;
import org.apache.batik.apps.svgbrowser.ElementOverlayManager;
import org.apache.batik.apps.svgbrowser.HistoryBrowser;
import org.apache.batik.apps.svgbrowser.HistoryBrowserInterface;
import org.apache.batik.apps.svgbrowser.NodePickerController;
import org.apache.batik.apps.svgbrowser.NodePickerPanel;
import org.apache.batik.apps.svgbrowser.NodeTemplates;
import org.apache.batik.bridge.svg12.ContentManager;
import org.apache.batik.bridge.svg12.DefaultXBLManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.dom.xbl.NodeXBL;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.batik.util.gui.DropDownComponent;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.resources.ResourceManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class DOMViewer
extends JFrame
implements ActionMap {
    protected static final String RESOURCE = "org.apache.batik.apps.svgbrowser.resources.DOMViewerMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.DOMViewerMessages", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected Map listeners = new HashMap();
    protected ButtonFactory buttonFactory;
    protected Panel panel;
    protected boolean showWhitespace = true;
    protected boolean isCapturingClickEnabled;
    protected DOMViewerController domViewerController;
    protected ElementOverlayManager elementOverlayManager;
    protected boolean isElementOverlayEnabled;
    protected HistoryBrowserInterface historyBrowserInterface;
    protected boolean canEdit = true;
    protected JToggleButton overlayButton;

    public DOMViewer(DOMViewerController dOMViewerController) {
        super(resources.getString("Frame.title"));
        this.setSize(resources.getInteger("Frame.width"), resources.getInteger("Frame.height"));
        this.domViewerController = dOMViewerController;
        this.elementOverlayManager = this.domViewerController.createSelectionManager();
        if (this.elementOverlayManager != null) {
            this.elementOverlayManager.setController(new DOMViewerElementOverlayController());
        }
        this.historyBrowserInterface = new HistoryBrowserInterface(new HistoryBrowser.DocumentCommandController(dOMViewerController));
        this.listeners.put("CloseButtonAction", new CloseButtonAction());
        this.listeners.put("UndoButtonAction", new UndoButtonAction());
        this.listeners.put("RedoButtonAction", new RedoButtonAction());
        this.listeners.put("CapturingClickButtonAction", new CapturingClickButtonAction());
        this.listeners.put("OverlayButtonAction", new OverlayButtonAction());
        this.panel = new Panel();
        this.getContentPane().add(this.panel);
        JPanel jPanel = new JPanel(new BorderLayout());
        JCheckBox jCheckBox = new JCheckBox(resources.getString("ShowWhitespaceCheckbox.text"));
        jCheckBox.setSelected(this.showWhitespace);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DOMViewer.this.setShowWhitespace(itemEvent.getStateChange() == 1);
            }
        });
        jPanel.add((Component)jCheckBox, "West");
        jPanel.add((Component)this.getButtonFactory().createJButton("CloseButton"), "East");
        this.getContentPane().add((Component)jPanel, "South");
        Document document = this.domViewerController.getDocument();
        if (document != null) {
            this.panel.setDocument(document, null);
        }
    }

    public void setShowWhitespace(boolean bl) {
        this.showWhitespace = bl;
        if (this.panel.document != null) {
            this.panel.setDocument(this.panel.document);
        }
    }

    public void setDocument(Document document) {
        this.panel.setDocument(document);
    }

    public void setDocument(Document document, ViewCSS viewCSS) {
        this.panel.setDocument(document, viewCSS);
    }

    public boolean canEdit() {
        return this.domViewerController.canEdit() && this.canEdit;
    }

    public void setEditable(boolean bl) {
        this.canEdit = bl;
    }

    public void selectNode(Node node) {
        this.panel.selectNode(node);
    }

    public void resetHistory() {
        this.historyBrowserInterface.getHistoryBrowser().resetHistory();
    }

    private ButtonFactory getButtonFactory() {
        if (this.buttonFactory == null) {
            this.buttonFactory = new ButtonFactory(bundle, (ActionMap)this);
        }
        return this.buttonFactory;
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    private void addChangesToHistory() {
        this.historyBrowserInterface.performCurrentCompoundCommand();
    }

    protected void toggleOverlay() {
        this.isElementOverlayEnabled = this.overlayButton.isSelected();
        if (!this.isElementOverlayEnabled) {
            this.overlayButton.setToolTipText(resources.getString("OverlayButton.tooltip"));
        } else {
            this.overlayButton.setToolTipText(resources.getString("OverlayButton.disableText"));
        }
        if (this.elementOverlayManager != null) {
            this.elementOverlayManager.setOverlayEnabled(this.isElementOverlayEnabled);
            this.elementOverlayManager.repaint();
        }
    }

    protected static class ContentNodeInfo
    extends NodeInfo {
        public ContentNodeInfo(Node node) {
            super(node);
        }

        @Override
        public String toString() {
            return "selected content";
        }
    }

    protected static class ShadowNodeInfo
    extends NodeInfo {
        public ShadowNodeInfo(Node node) {
            super(node);
        }

        @Override
        public String toString() {
            return "shadow tree";
        }
    }

    protected static class NodeInfo {
        protected Node node;

        public NodeInfo(Node node) {
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }

        public String toString() {
            Element element;
            String string;
            if (this.node instanceof Element && (string = (element = (Element)this.node).getAttribute("id")).length() != 0) {
                return this.node.getNodeName() + " \"" + string + "\"";
            }
            return this.node.getNodeName();
        }
    }

    public class Panel
    extends JPanel {
        public static final String NODE_INSERTED = "DOMNodeInserted";
        public static final String NODE_REMOVED = "DOMNodeRemoved";
        public static final String ATTRIBUTE_MODIFIED = "DOMAttrModified";
        public static final String CHAR_DATA_MODIFIED = "DOMCharacterDataModified";
        protected Document document;
        protected EventListener nodeInsertion;
        protected EventListener nodeRemoval;
        protected EventListener attrModification;
        protected EventListener charDataModification;
        protected EventListener capturingListener;
        protected ViewCSS viewCSS;
        protected DOMDocumentTree tree;
        protected JSplitPane splitPane;
        protected JPanel rightPanel;
        protected JTable propertiesTable;
        protected NodePickerPanel attributePanel;
        protected GridBagConstraints attributePanelLayout;
        protected GridBagConstraints propertiesTableLayout;
        protected JPanel elementPanel;
        protected CharacterPanel characterDataPanel;
        protected JTextArea documentInfo;
        protected JPanel documentInfoPanel;

        public Panel() {
            super(new BorderLayout());
            this.rightPanel = new JPanel(new BorderLayout());
            this.propertiesTable = new JTable();
            this.attributePanel = new NodePickerPanel(new DOMViewerNodePickerController());
            this.attributePanel.addListener(new NodePickerPanel.NodePickerAdapter(){

                @Override
                public void updateElement(NodePickerPanel.NodePickerEvent nodePickerEvent) {
                    String string = nodePickerEvent.getResult();
                    Element element = (Element)nodePickerEvent.getContextNode();
                    Element element2 = this.wrapAndParse(string, element);
                    DOMViewer.this.addChangesToHistory();
                    HistoryBrowserInterface.CompoundUpdateCommand compoundUpdateCommand = DOMViewer.this.historyBrowserInterface.createNodeChangedCommand(element2);
                    Node node = element.getParentNode();
                    Node node2 = element.getNextSibling();
                    compoundUpdateCommand.addCommand(DOMViewer.this.historyBrowserInterface.createRemoveChildCommand(node, element));
                    compoundUpdateCommand.addCommand(DOMViewer.this.historyBrowserInterface.createInsertChildCommand(node, node2, element2));
                    DOMViewer.this.historyBrowserInterface.performCompoundUpdateCommand(compoundUpdateCommand);
                    Panel.this.attributePanel.setPreviewElement(element2);
                }

                @Override
                public void addNewElement(NodePickerPanel.NodePickerEvent nodePickerEvent) {
                    String string = nodePickerEvent.getResult();
                    Element element = (Element)nodePickerEvent.getContextNode();
                    Element element2 = this.wrapAndParse(string, element);
                    DOMViewer.this.addChangesToHistory();
                    DOMViewer.this.historyBrowserInterface.appendChild(element, element2);
                    Panel.this.attributePanel.setPreviewElement(element2);
                }

                private Element wrapAndParse(String string, Node node) {
                    Object object;
                    Object object2;
                    Object object3;
                    Node node2;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    int n = 0;
                    for (node2 = node; node2 != null; node2 = node2.getParentNode()) {
                        object3 = node2.getAttributes();
                        for (int i = 0; object3 != null && i < object3.getLength(); ++i) {
                            String string2;
                            object2 = (Attr)object3.item(i);
                            object = object2.getPrefix();
                            String string3 = object2.getLocalName();
                            String string4 = object2.getValue();
                            if (object != null && ((String)object).equals("xmlns") && !hashMap.containsKey(string2 = "xmlns:" + string3)) {
                                hashMap.put(string2, string4);
                            }
                            if (n == 0 && node2 != Panel.this.document.getDocumentElement() || !object2.getNodeName().equals("xmlns") || hashMap.containsKey("xmlns")) continue;
                            hashMap.put("xmlns", object2.getNodeValue());
                        }
                        ++n;
                    }
                    node2 = DOMViewer.this.panel.document;
                    object3 = new SAXDocumentFactory(node2.getImplementation(), XMLResourceDescriptor.getXMLParserClassName());
                    URL uRL = null;
                    if (node2 instanceof SVGOMDocument) {
                        uRL = ((SVGOMDocument)node2).getURLObject();
                    }
                    object2 = uRL == null ? "" : uRL.toString();
                    object = DOMUtilities.parseXML(string, (Document)node2, (String)object2, hashMap, "svg", (SAXDocumentFactory)object3);
                    return (Element)object.getFirstChild();
                }

                private void selectNewNode(final Element element) {
                    DOMViewer.this.domViewerController.performUpdate(new Runnable(){

                        @Override
                        public void run() {
                            Panel.this.selectNode(element);
                        }
                    });
                }
            });
            this.attributePanelLayout = new GridBagConstraints();
            this.attributePanelLayout.gridx = 1;
            this.attributePanelLayout.gridy = 1;
            this.attributePanelLayout.gridheight = 2;
            this.attributePanelLayout.weightx = 1.0;
            this.attributePanelLayout.weighty = 1.0;
            this.attributePanelLayout.fill = 1;
            this.propertiesTableLayout = new GridBagConstraints();
            this.propertiesTableLayout.gridx = 1;
            this.propertiesTableLayout.gridy = 3;
            this.propertiesTableLayout.weightx = 1.0;
            this.propertiesTableLayout.weighty = 1.0;
            this.propertiesTableLayout.fill = 1;
            this.elementPanel = new JPanel(new GridBagLayout());
            JComponent jComponent = new JScrollPane();
            jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("CSSValuesPanel.title")), BorderFactory.createLoweredBevelBorder())));
            ((JScrollPane)jComponent).getViewport().add(this.propertiesTable);
            this.elementPanel.add((Component)this.attributePanel, this.attributePanelLayout);
            this.elementPanel.add((Component)jComponent, this.propertiesTableLayout);
            this.characterDataPanel = new CharacterPanel(new BorderLayout());
            this.characterDataPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("CDataPanel.title")), BorderFactory.createLoweredBevelBorder())));
            jComponent = new JScrollPane();
            JComponent jComponent2 = new JTextArea();
            this.characterDataPanel.setTextArea((JTextArea)jComponent2);
            ((JScrollPane)jComponent).getViewport().add(jComponent2);
            this.characterDataPanel.add(jComponent);
            ((JTextComponent)jComponent2).setEditable(true);
            jComponent2.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (DOMViewer.this.canEdit()) {
                        Node node = Panel.this.characterDataPanel.getNode();
                        String string = Panel.this.characterDataPanel.getTextArea().getText();
                        switch (node.getNodeType()) {
                            case 3: 
                            case 4: 
                            case 8: {
                                DOMViewer.this.addChangesToHistory();
                                DOMViewer.this.historyBrowserInterface.setNodeValue(node, string);
                            }
                        }
                    }
                }
            });
            this.documentInfo = new JTextArea();
            this.documentInfoPanel = new JPanel(new BorderLayout());
            this.documentInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("DocumentInfoPanel.title")), BorderFactory.createLoweredBevelBorder())));
            jComponent = new JScrollPane();
            ((JScrollPane)jComponent).getViewport().add(this.documentInfo);
            this.documentInfoPanel.add(jComponent);
            this.documentInfo.setEditable(false);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("DOMViewerPanel.title")));
            jComponent = new JToolBar(resources.getString("DOMViewerToolbar.name"));
            ((JToolBar)jComponent).setFloatable(false);
            jComponent2 = DOMViewer.this.getButtonFactory().createJToolbarButton("UndoButton");
            ((AbstractButton)jComponent2).setDisabledIcon(new ImageIcon(this.getClass().getResource(resources.getString("UndoButton.disabledIcon"))));
            DropDownComponent dropDownComponent = new DropDownComponent((JButton)jComponent2);
            dropDownComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            dropDownComponent.setMaximumSize(new Dimension(44, 25));
            dropDownComponent.setPreferredSize(new Dimension(44, 25));
            jComponent.add((Component)dropDownComponent);
            DropDownHistoryModel.UndoPopUpMenuModel undoPopUpMenuModel = new DropDownHistoryModel.UndoPopUpMenuModel(dropDownComponent.getPopupMenu(), DOMViewer.this.historyBrowserInterface);
            dropDownComponent.getPopupMenu().setModel((DropDownComponent.ScrollablePopupMenuModel)undoPopUpMenuModel);
            JButton jButton = DOMViewer.this.getButtonFactory().createJToolbarButton("RedoButton");
            jButton.setDisabledIcon(new ImageIcon(this.getClass().getResource(resources.getString("RedoButton.disabledIcon"))));
            DropDownComponent dropDownComponent2 = new DropDownComponent(jButton);
            dropDownComponent2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            dropDownComponent2.setMaximumSize(new Dimension(44, 25));
            dropDownComponent2.setPreferredSize(new Dimension(44, 25));
            jComponent.add((Component)dropDownComponent2);
            DropDownHistoryModel.RedoPopUpMenuModel redoPopUpMenuModel = new DropDownHistoryModel.RedoPopUpMenuModel(dropDownComponent2.getPopupMenu(), DOMViewer.this.historyBrowserInterface);
            dropDownComponent2.getPopupMenu().setModel((DropDownComponent.ScrollablePopupMenuModel)redoPopUpMenuModel);
            JToggleButton jToggleButton = DOMViewer.this.getButtonFactory().createJToolbarToggleButton("CapturingClickButton");
            jToggleButton.setEnabled(true);
            jToggleButton.setPreferredSize(new Dimension(32, 25));
            jComponent.add(jToggleButton);
            DOMViewer.this.overlayButton = DOMViewer.this.getButtonFactory().createJToolbarToggleButton("OverlayButton");
            DOMViewer.this.overlayButton.setEnabled(true);
            DOMViewer.this.overlayButton.setPreferredSize(new Dimension(32, 25));
            jComponent.add(DOMViewer.this.overlayButton);
            this.add((Component)jComponent, "North");
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(resources.getString("EmptyDocument.text"));
            this.tree = new DOMDocumentTree((TreeNode)defaultMutableTreeNode, new DOMViewerDOMDocumentTreeController());
            this.tree.setCellRenderer(new NodeRenderer());
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            this.tree.addListener(new DOMDocumentTree.DOMDocumentTreeAdapter(){

                @Override
                public void dropCompleted(DOMDocumentTree.DOMDocumentTreeEvent dOMDocumentTreeEvent) {
                    DOMDocumentTree.DropCompletedInfo dropCompletedInfo = (DOMDocumentTree.DropCompletedInfo)dOMDocumentTreeEvent.getSource();
                    DOMViewer.this.addChangesToHistory();
                    HistoryBrowserInterface.CompoundUpdateCommand compoundUpdateCommand = DOMViewer.this.historyBrowserInterface.createNodesDroppedCommand(dropCompletedInfo.getChildren());
                    int n = dropCompletedInfo.getChildren().size();
                    for (int i = 0; i < n; ++i) {
                        Node node = (Node)dropCompletedInfo.getChildren().get(i);
                        if (DOMUtilities.isAnyNodeAncestorOf(dropCompletedInfo.getChildren(), node)) continue;
                        compoundUpdateCommand.addCommand(DOMViewer.this.historyBrowserInterface.createInsertChildCommand(dropCompletedInfo.getParent(), dropCompletedInfo.getSibling(), node));
                    }
                    DOMViewer.this.historyBrowserInterface.performCompoundUpdateCommand(compoundUpdateCommand);
                }
            });
            this.tree.addTreeSelectionListener(new DOMTreeSelectionListener());
            this.tree.addMouseListener(new TreePopUpListener());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("DOMViewer.title")), BorderFactory.createLoweredBevelBorder())));
            jScrollPane.getViewport().add(this.tree);
            this.splitPane = new JSplitPane(1, true, jScrollPane, this.rightPanel);
            int n = resources.getInteger("SplitPane.dividerLocation");
            this.splitPane.setDividerLocation(n);
            this.add(this.splitPane);
        }

        public void setDocument(Document document) {
            this.setDocument(document, null);
        }

        public void setDocument(Document document, ViewCSS viewCSS) {
            if (this.document != null) {
                if (this.document != document) {
                    this.removeDomMutationListeners(this.document);
                    this.addDomMutationListeners(document);
                    this.removeCapturingListener(this.document);
                    this.addCapturingListener(document);
                }
            } else {
                this.addDomMutationListeners(document);
                this.addCapturingListener(document);
            }
            DOMViewer.this.resetHistory();
            this.document = document;
            this.viewCSS = viewCSS;
            MutableTreeNode mutableTreeNode = this.createTree(document, DOMViewer.this.showWhitespace);
            ((DefaultTreeModel)this.tree.getModel()).setRoot(mutableTreeNode);
            if (this.rightPanel.getComponentCount() != 0) {
                this.rightPanel.remove(0);
                this.splitPane.revalidate();
                this.splitPane.repaint();
            }
        }

        protected void addDomMutationListeners(Document document) {
            EventTarget eventTarget = (EventTarget)((Object)document);
            this.nodeInsertion = new NodeInsertionHandler();
            eventTarget.addEventListener(NODE_INSERTED, this.nodeInsertion, true);
            this.nodeRemoval = new NodeRemovalHandler();
            eventTarget.addEventListener(NODE_REMOVED, this.nodeRemoval, true);
            this.attrModification = new AttributeModificationHandler();
            eventTarget.addEventListener(ATTRIBUTE_MODIFIED, this.attrModification, true);
            this.charDataModification = new CharDataModificationHandler();
            eventTarget.addEventListener(CHAR_DATA_MODIFIED, this.charDataModification, true);
        }

        protected void removeDomMutationListeners(Document document) {
            if (document != null) {
                EventTarget eventTarget = (EventTarget)((Object)document);
                eventTarget.removeEventListener(NODE_INSERTED, this.nodeInsertion, true);
                eventTarget.removeEventListener(NODE_REMOVED, this.nodeRemoval, true);
                eventTarget.removeEventListener(ATTRIBUTE_MODIFIED, this.attrModification, true);
                eventTarget.removeEventListener(CHAR_DATA_MODIFIED, this.charDataModification, true);
            }
        }

        protected void addCapturingListener(Document document) {
            EventTarget eventTarget = (EventTarget)((Object)document.getDocumentElement());
            this.capturingListener = new CapturingClickHandler();
            eventTarget.addEventListener("click", this.capturingListener, true);
        }

        protected void removeCapturingListener(Document document) {
            if (document != null) {
                EventTarget eventTarget = (EventTarget)((Object)document.getDocumentElement());
                eventTarget.removeEventListener("click", this.capturingListener, true);
            }
        }

        protected void refreshGUI(Runnable runnable) {
            if (DOMViewer.this.canEdit()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        }

        protected void registerNodeInserted(MutationEvent mutationEvent) {
            Node node = (Node)((Object)mutationEvent.getTarget());
            DOMViewer.this.historyBrowserInterface.addToCurrentCompoundCommand(DOMViewer.this.historyBrowserInterface.createNodeInsertedCommand(node.getParentNode(), node.getNextSibling(), node));
        }

        protected void registerNodeRemoved(MutationEvent mutationEvent) {
            Node node = (Node)((Object)mutationEvent.getTarget());
            DOMViewer.this.historyBrowserInterface.addToCurrentCompoundCommand(DOMViewer.this.historyBrowserInterface.createNodeRemovedCommand(mutationEvent.getRelatedNode(), node.getNextSibling(), node));
        }

        protected void registerAttributeAdded(MutationEvent mutationEvent) {
            Element element = (Element)((Object)mutationEvent.getTarget());
            DOMViewer.this.historyBrowserInterface.addToCurrentCompoundCommand(DOMViewer.this.historyBrowserInterface.createAttributeAddedCommand(element, mutationEvent.getAttrName(), mutationEvent.getNewValue(), null));
        }

        protected void registerAttributeRemoved(MutationEvent mutationEvent) {
            Element element = (Element)((Object)mutationEvent.getTarget());
            DOMViewer.this.historyBrowserInterface.addToCurrentCompoundCommand(DOMViewer.this.historyBrowserInterface.createAttributeRemovedCommand(element, mutationEvent.getAttrName(), mutationEvent.getPrevValue(), null));
        }

        protected void registerAttributeModified(MutationEvent mutationEvent) {
            Element element = (Element)((Object)mutationEvent.getTarget());
            DOMViewer.this.historyBrowserInterface.addToCurrentCompoundCommand(DOMViewer.this.historyBrowserInterface.createAttributeModifiedCommand(element, mutationEvent.getAttrName(), mutationEvent.getPrevValue(), mutationEvent.getNewValue(), null));
        }

        protected void registerAttributeChanged(MutationEvent mutationEvent) {
            switch (mutationEvent.getAttrChange()) {
                case 2: {
                    this.registerAttributeAdded(mutationEvent);
                    break;
                }
                case 3: {
                    this.registerAttributeRemoved(mutationEvent);
                    break;
                }
                case 1: {
                    this.registerAttributeModified(mutationEvent);
                    break;
                }
                default: {
                    this.registerAttributeModified(mutationEvent);
                }
            }
        }

        protected void registerCharDataModified(MutationEvent mutationEvent) {
            Node node = (Node)((Object)mutationEvent.getTarget());
            DOMViewer.this.historyBrowserInterface.addToCurrentCompoundCommand(DOMViewer.this.historyBrowserInterface.createCharDataModifiedCommand(node, mutationEvent.getPrevValue(), mutationEvent.getNewValue()));
        }

        protected boolean shouldRegisterDocumentChange() {
            return DOMViewer.this.canEdit() && DOMViewer.this.historyBrowserInterface.getHistoryBrowser().getState() == 4;
        }

        protected void registerDocumentChange(MutationEvent mutationEvent) {
            if (this.shouldRegisterDocumentChange()) {
                String string = mutationEvent.getType();
                if (string.equals(NODE_INSERTED)) {
                    this.registerNodeInserted(mutationEvent);
                } else if (string.equals(NODE_REMOVED)) {
                    this.registerNodeRemoved(mutationEvent);
                } else if (string.equals(ATTRIBUTE_MODIFIED)) {
                    this.registerAttributeChanged(mutationEvent);
                } else if (string.equals(CHAR_DATA_MODIFIED)) {
                    this.registerCharDataModified(mutationEvent);
                }
            }
        }

        protected MutableTreeNode createTree(Node node, boolean bl) {
            Object object;
            Node node2;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new NodeInfo(node));
            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!bl && node2 instanceof Text && ((String)(object = node2.getNodeValue())).trim().length() == 0) continue;
                defaultMutableTreeNode.add(this.createTree(node2, bl));
            }
            if (node instanceof NodeXBL && (node2 = ((NodeXBL)((Object)node)).getXblShadowTree()) != null) {
                object = new DefaultMutableTreeNode(new ShadowNodeInfo(node2));
                ((DefaultMutableTreeNode)object).add(this.createTree(node2, bl));
                defaultMutableTreeNode.add((MutableTreeNode)object);
            }
            if (node instanceof XBLOMContentElement && (object = ((AbstractDocument)(node2 = (AbstractDocument)node.getOwnerDocument())).getXBLManager()) instanceof DefaultXBLManager) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ContentNodeInfo(node));
                DefaultXBLManager defaultXBLManager = (DefaultXBLManager)object;
                ContentManager contentManager = defaultXBLManager.getContentManager(node);
                if (contentManager != null) {
                    NodeList nodeList = contentManager.getSelectedContent((XBLOMContentElement)node);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        defaultMutableTreeNode2.add(this.createTree(nodeList.item(i), bl));
                    }
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
            }
            return defaultMutableTreeNode;
        }

        protected DefaultMutableTreeNode findNode(JTree jTree, Node node) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getModel().getRoot();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                NodeInfo nodeInfo = (NodeInfo)defaultMutableTreeNode2.getUserObject();
                if (nodeInfo.getNode() != node) continue;
                return defaultMutableTreeNode2;
            }
            return null;
        }

        public void selectNode(final Node node) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultMutableTreeNode defaultMutableTreeNode = Panel.this.findNode(Panel.this.tree, node);
                    if (defaultMutableTreeNode != null) {
                        Object[] objectArray = defaultMutableTreeNode.getPath();
                        TreePath treePath = new TreePath(objectArray);
                        Panel.this.tree.setSelectionPath(treePath);
                        Panel.this.tree.scrollPathToVisible(treePath);
                    }
                }
            });
        }

        protected JMenu createTemplatesMenu(String string) {
            NodeTemplates nodeTemplates = new NodeTemplates();
            JMenu jMenu = new JMenu(string);
            HashMap<String, JMenu> hashMap = new HashMap<String, JMenu>();
            ArrayList arrayList = nodeTemplates.getCategories();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = arrayList.get(i).toString();
                Object object = new JMenu(string2);
                jMenu.add((JMenuItem)object);
                hashMap.put(string2, (JMenu)object);
            }
            ArrayList arrayList2 = new ArrayList(nodeTemplates.getNodeTemplatesMap().values());
            Collections.sort(arrayList2, new Comparator(){

                public int compare(Object object, Object object2) {
                    NodeTemplates.NodeTemplateDescriptor nodeTemplateDescriptor = (NodeTemplates.NodeTemplateDescriptor)object;
                    NodeTemplates.NodeTemplateDescriptor nodeTemplateDescriptor2 = (NodeTemplates.NodeTemplateDescriptor)object2;
                    return nodeTemplateDescriptor.getName().compareTo(nodeTemplateDescriptor2.getName());
                }
            });
            for (Object object : arrayList2) {
                String string3 = ((NodeTemplates.NodeTemplateDescriptor)object).getXmlValue();
                short s = ((NodeTemplates.NodeTemplateDescriptor)object).getType();
                String string4 = ((NodeTemplates.NodeTemplateDescriptor)object).getCategory();
                JMenuItem jMenuItem = new JMenuItem(((NodeTemplates.NodeTemplateDescriptor)object).getName());
                jMenuItem.addActionListener(new NodeTemplateParser(string3, s));
                JMenu jMenu2 = (JMenu)hashMap.get(string4);
                jMenu2.add(jMenuItem);
            }
            return jMenu;
        }

        protected class NodeCSSValuesModel
        extends AbstractTableModel {
            protected Node node;
            protected CSSStyleDeclaration style;
            protected List propertyNames;

            public NodeCSSValuesModel(Node node) {
                this.node = node;
                if (Panel.this.viewCSS != null) {
                    this.style = Panel.this.viewCSS.getComputedStyle((Element)node, null);
                    this.propertyNames = new ArrayList();
                    if (this.style != null) {
                        for (int i = 0; i < this.style.getLength(); ++i) {
                            this.propertyNames.add(this.style.item(i));
                        }
                        Collections.sort(this.propertyNames);
                    }
                }
            }

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return resources.getString("CSSValuesTable.column1");
                }
                return resources.getString("CSSValuesTable.column2");
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                if (this.style == null) {
                    return 0;
                }
                return this.style.getLength();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                String string = (String)this.propertyNames.get(n);
                if (n2 == 0) {
                    return string;
                }
                return this.style.getPropertyValue(string);
            }
        }

        protected class NodeRenderer
        extends DefaultTreeCellRenderer {
            protected ImageIcon elementIcon;
            protected ImageIcon commentIcon;
            protected ImageIcon piIcon;
            protected ImageIcon textIcon;

            public NodeRenderer() {
                String string = resources.getString("Element.icon");
                this.elementIcon = new ImageIcon(this.getClass().getResource(string));
                string = resources.getString("Comment.icon");
                this.commentIcon = new ImageIcon(this.getClass().getResource(string));
                string = resources.getString("PI.icon");
                this.piIcon = new ImageIcon(this.getClass().getResource(string));
                string = resources.getString("Text.icon");
                this.textIcon = new ImageIcon(this.getClass().getResource(string));
            }

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                switch (this.getNodeType(object)) {
                    case 1: {
                        this.setIcon(this.elementIcon);
                        break;
                    }
                    case 8: {
                        this.setIcon(this.commentIcon);
                        break;
                    }
                    case 7: {
                        this.setIcon(this.piIcon);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.setIcon(this.textIcon);
                    }
                }
                return this;
            }

            protected short getNodeType(Object object) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                Object object2 = defaultMutableTreeNode.getUserObject();
                if (object2 instanceof NodeInfo) {
                    Node node = ((NodeInfo)object2).getNode();
                    return node.getNodeType();
                }
                return -1;
            }
        }

        protected class DOMTreeSelectionListener
        implements TreeSelectionListener {
            protected DOMTreeSelectionListener() {
            }

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                DefaultMutableTreeNode defaultMutableTreeNode;
                if (DOMViewer.this.elementOverlayManager != null) {
                    this.handleElementSelection(treeSelectionEvent);
                }
                if ((defaultMutableTreeNode = (DefaultMutableTreeNode)Panel.this.tree.getLastSelectedPathComponent()) == null) {
                    return;
                }
                if (Panel.this.rightPanel.getComponentCount() != 0) {
                    Panel.this.rightPanel.remove(0);
                }
                if ((object = defaultMutableTreeNode.getUserObject()) instanceof NodeInfo) {
                    Node node = ((NodeInfo)object).getNode();
                    switch (node.getNodeType()) {
                        case 9: {
                            Panel.this.documentInfo.setText(this.createDocumentText((Document)node));
                            Panel.this.rightPanel.add(Panel.this.documentInfoPanel);
                            break;
                        }
                        case 1: {
                            Panel.this.propertiesTable.setModel(new NodeCSSValuesModel(node));
                            Panel.this.attributePanel.promptForChanges();
                            Panel.this.attributePanel.setPreviewElement((Element)node);
                            Panel.this.rightPanel.add(Panel.this.elementPanel);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 8: {
                            Panel.this.characterDataPanel.setNode(node);
                            Panel.this.characterDataPanel.getTextArea().setText(node.getNodeValue());
                            Panel.this.rightPanel.add(Panel.this.characterDataPanel);
                        }
                    }
                }
                Panel.this.splitPane.revalidate();
                Panel.this.splitPane.repaint();
            }

            protected String createDocumentText(Document document) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Nodes: ");
                stringBuffer.append(this.nodeCount(document));
                return stringBuffer.toString();
            }

            protected int nodeCount(Node node) {
                int n = 1;
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    n += this.nodeCount(node2);
                }
                return n;
            }

            protected void handleElementSelection(TreeSelectionEvent treeSelectionEvent) {
                TreePath[] treePathArray = treeSelectionEvent.getPaths();
                for (int i = 0; i < treePathArray.length; ++i) {
                    Node node;
                    TreePath treePath = treePathArray[i];
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (!(object instanceof NodeInfo) || (node = ((NodeInfo)object).getNode()).getNodeType() != 1) continue;
                    if (treeSelectionEvent.isAddedPath(treePath)) {
                        DOMViewer.this.elementOverlayManager.addElement((Element)node);
                        continue;
                    }
                    DOMViewer.this.elementOverlayManager.removeElement((Element)node);
                }
                DOMViewer.this.elementOverlayManager.repaint();
            }
        }

        protected class TreeNodeRemover
        implements ActionListener {
            protected TreeNodeRemover() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DOMViewer.this.addChangesToHistory();
                HistoryBrowserInterface.CompoundUpdateCommand compoundUpdateCommand = DOMViewer.this.historyBrowserInterface.createRemoveSelectedTreeNodesCommand(null);
                TreePath[] treePathArray = Panel.this.tree.getSelectionPaths();
                for (int i = 0; treePathArray != null && i < treePathArray.length; ++i) {
                    TreePath treePath = treePathArray[i];
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    NodeInfo nodeInfo = (NodeInfo)defaultMutableTreeNode.getUserObject();
                    if (!DOMUtilities.isParentOf(nodeInfo.getNode(), nodeInfo.getNode().getParentNode())) continue;
                    compoundUpdateCommand.addCommand(DOMViewer.this.historyBrowserInterface.createRemoveChildCommand(nodeInfo.getNode().getParentNode(), nodeInfo.getNode()));
                }
                DOMViewer.this.historyBrowserInterface.performCompoundUpdateCommand(compoundUpdateCommand);
            }
        }

        protected class NodeTemplateParser
        implements ActionListener {
            protected String toParse;
            protected short nodeType;

            public NodeTemplateParser(String string, short s) {
                this.toParse = string;
                this.nodeType = s;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Cloneable cloneable;
                Object object2;
                Object object3;
                Node node = null;
                switch (this.nodeType) {
                    case 1: {
                        object3 = null;
                        if (Panel.this.document instanceof SVGOMDocument) {
                            object3 = ((SVGOMDocument)Panel.this.document).getURLObject();
                        }
                        object2 = object3 == null ? "" : object3.toString();
                        cloneable = new HashMap<String, String>();
                        cloneable.put("xmlns", "http://www.w3.org/2000/svg");
                        cloneable.put("xmlns:xlink", "http://www.w3.org/1999/xlink");
                        object = new SAXDocumentFactory(Panel.this.document.getImplementation(), XMLResourceDescriptor.getXMLParserClassName());
                        DocumentFragment documentFragment = (DocumentFragment)DOMUtilities.parseXML(this.toParse, Panel.this.document, (String)object2, (Map)((Object)cloneable), "svg", (SAXDocumentFactory)object);
                        node = documentFragment.getFirstChild();
                        break;
                    }
                    case 3: {
                        node = Panel.this.document.createTextNode(this.toParse);
                        break;
                    }
                    case 8: {
                        node = Panel.this.document.createComment(this.toParse);
                        break;
                    }
                    case 4: {
                        node = Panel.this.document.createCDATASection(this.toParse);
                    }
                }
                object3 = Panel.this.tree.getSelectionPaths();
                if (object3 != null) {
                    object2 = object3[((TreePath[])object3).length - 1];
                    cloneable = (DefaultMutableTreeNode)((TreePath)object2).getLastPathComponent();
                    object = (NodeInfo)((DefaultMutableTreeNode)cloneable).getUserObject();
                    DOMViewer.this.addChangesToHistory();
                    DOMViewer.this.historyBrowserInterface.appendChild(((NodeInfo)object).getNode(), node);
                }
            }
        }

        protected class TreeNodeAdder
        implements ActionListener {
            protected TreeNodeAdder() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodePickerPanel.NameEditorDialog nameEditorDialog = new NodePickerPanel.NameEditorDialog(DOMViewer.this);
                nameEditorDialog.setLocationRelativeTo(DOMViewer.this);
                int n = nameEditorDialog.showDialog();
                if (n == 0) {
                    Element element = Panel.this.document.createElementNS("http://www.w3.org/2000/svg", nameEditorDialog.getResults());
                    if (Panel.this.rightPanel.getComponentCount() != 0) {
                        Panel.this.rightPanel.remove(0);
                    }
                    Panel.this.rightPanel.add(Panel.this.elementPanel);
                    TreePath[] treePathArray = Panel.this.tree.getSelectionPaths();
                    if (treePathArray != null) {
                        TreePath treePath = treePathArray[treePathArray.length - 1];
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        NodeInfo nodeInfo = (NodeInfo)defaultMutableTreeNode.getUserObject();
                        Panel.this.attributePanel.enterAddNewElementMode(element, nodeInfo.getNode());
                    }
                }
            }
        }

        protected class TreePopUpListener
        extends MouseAdapter {
            protected JPopupMenu treePopupMenu = new JPopupMenu();

            public TreePopUpListener() {
                this.treePopupMenu.add(Panel.this.createTemplatesMenu(resources.getString("ContextMenuItem.insertNewNode")));
                JMenuItem jMenuItem = new JMenuItem(resources.getString("ContextMenuItem.createNewElement"));
                this.treePopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new TreeNodeAdder());
                jMenuItem = new JMenuItem(resources.getString("ContextMenuItem.removeSelection"));
                jMenuItem.addActionListener(new TreeNodeRemover());
                this.treePopupMenu.add(jMenuItem);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1 && Panel.this.tree.getSelectionPaths() != null) {
                    this.showPopUp(mouseEvent);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTree jTree = (JTree)mouseEvent.getSource();
                TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                    jTree.setSelectionPath(treePath);
                } else {
                    jTree.addSelectionPath(treePath);
                }
                if (mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1) {
                    this.showPopUp(mouseEvent);
                }
            }

            private void showPopUp(MouseEvent mouseEvent) {
                TreePath treePath;
                if (DOMViewer.this.canEdit() && (treePath = Panel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.getPathCount() > 1) {
                    this.treePopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        protected class CapturingClickHandler
        implements EventListener {
            protected CapturingClickHandler() {
            }

            @Override
            public void handleEvent(Event event) {
                if (DOMViewer.this.isCapturingClickEnabled) {
                    Element element = (Element)((Object)event.getTarget());
                    Panel.this.selectNode(element);
                }
            }
        }

        protected class CharDataModificationHandler
        implements EventListener {
            protected CharDataModificationHandler() {
            }

            @Override
            public void handleEvent(final Event event) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MutationEvent mutationEvent = (MutationEvent)event;
                        Node node = (Node)((Object)mutationEvent.getTarget());
                        if (Panel.this.characterDataPanel.getNode() == node) {
                            Panel.this.characterDataPanel.getTextArea().setText(node.getNodeValue());
                            Panel.this.attributePanel.updateOnDocumentChange(mutationEvent.getType(), node);
                        }
                    }
                };
                Panel.this.refreshGUI(runnable);
                if (Panel.this.characterDataPanel.getNode() == event.getTarget()) {
                    Panel.this.registerDocumentChange((MutationEvent)event);
                }
            }
        }

        protected class AttributeModificationHandler
        implements EventListener {
            protected AttributeModificationHandler() {
            }

            @Override
            public void handleEvent(final Event event) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MutationEvent mutationEvent = (MutationEvent)event;
                        Element element = (Element)((Object)mutationEvent.getTarget());
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)Panel.this.tree.getModel();
                        defaultTreeModel.nodeChanged(Panel.this.findNode(Panel.this.tree, element));
                        Panel.this.attributePanel.updateOnDocumentChange(mutationEvent.getType(), element);
                    }
                };
                Panel.this.refreshGUI(runnable);
                Panel.this.registerDocumentChange((MutationEvent)event);
            }
        }

        protected class NodeRemovalHandler
        implements EventListener {
            protected NodeRemovalHandler() {
            }

            @Override
            public void handleEvent(final Event event) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MutationEvent mutationEvent = (MutationEvent)event;
                        Node node = (Node)((Object)mutationEvent.getTarget());
                        DefaultMutableTreeNode defaultMutableTreeNode = Panel.this.findNode(Panel.this.tree, node);
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)Panel.this.tree.getModel();
                        if (defaultMutableTreeNode != null) {
                            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                        }
                        Panel.this.attributePanel.updateOnDocumentChange(mutationEvent.getType(), node);
                    }
                };
                Panel.this.refreshGUI(runnable);
                Panel.this.registerDocumentChange((MutationEvent)event);
            }
        }

        protected class NodeInsertionHandler
        implements EventListener {
            protected NodeInsertionHandler() {
            }

            @Override
            public void handleEvent(final Event event) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MutationEvent mutationEvent = (MutationEvent)event;
                        Node node = (Node)((Object)mutationEvent.getTarget());
                        DefaultMutableTreeNode defaultMutableTreeNode = Panel.this.findNode(Panel.this.tree, node.getParentNode());
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Panel.this.createTree(node, DOMViewer.this.showWhitespace);
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)Panel.this.tree.getModel();
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)Panel.this.createTree(node.getParentNode(), DOMViewer.this.showWhitespace);
                        int n = NodeInsertionHandler.this.findIndexToInsert(defaultMutableTreeNode, defaultMutableTreeNode3);
                        if (n != -1) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
                        }
                        Panel.this.attributePanel.updateOnDocumentChange(mutationEvent.getType(), node);
                    }
                };
                Panel.this.refreshGUI(runnable);
                Panel.this.registerDocumentChange((MutationEvent)event);
            }

            protected int findIndexToInsert(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
                int n = -1;
                if (defaultMutableTreeNode == null || defaultMutableTreeNode2 == null) {
                    return n;
                }
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode2.children();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    Node node;
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration2.nextElement();
                    Node node2 = ((NodeInfo)defaultMutableTreeNode3.getUserObject()).getNode();
                    if (node2 != (node = ((NodeInfo)defaultMutableTreeNode4.getUserObject()).getNode())) {
                        return n2;
                    }
                    ++n2;
                }
                return n2;
            }
        }

        protected class CharacterPanel
        extends JPanel {
            protected Node node;
            protected JTextArea textArea;

            public CharacterPanel(BorderLayout borderLayout) {
                super(borderLayout);
                this.textArea = new JTextArea();
            }

            public JTextArea getTextArea() {
                return this.textArea;
            }

            public void setTextArea(JTextArea jTextArea) {
                this.textArea = jTextArea;
            }

            public Node getNode() {
                return this.node;
            }

            public void setNode(Node node) {
                this.node = node;
            }
        }
    }

    protected class DOMViewerElementOverlayController
    implements ElementOverlayController {
        protected DOMViewerElementOverlayController() {
        }

        @Override
        public boolean isOverlayEnabled() {
            return DOMViewer.this.canEdit() && DOMViewer.this.isElementOverlayEnabled;
        }
    }

    protected class DOMViewerDOMDocumentTreeController
    implements DOMDocumentTreeController {
        protected DOMViewerDOMDocumentTreeController() {
        }

        @Override
        public boolean isDNDSupported() {
            return DOMViewer.this.canEdit();
        }
    }

    protected class DOMViewerNodePickerController
    implements NodePickerController {
        protected DOMViewerNodePickerController() {
        }

        @Override
        public boolean isEditable() {
            return DOMViewer.this.canEdit();
        }

        @Override
        public boolean canEdit(Element element) {
            if (DOMViewer.this.panel == null || DOMViewer.this.panel.document != null) {
                // empty if block
            }
            return true;
        }
    }

    protected class OverlayButtonAction
    extends AbstractAction {
        protected OverlayButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DOMViewer.this.toggleOverlay();
        }
    }

    protected class CapturingClickButtonAction
    extends AbstractAction {
        protected CapturingClickButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            DOMViewer.this.isCapturingClickEnabled = jToggleButton.isSelected();
            if (!DOMViewer.this.isCapturingClickEnabled) {
                jToggleButton.setToolTipText(resources.getString("CapturingClickButton.tooltip"));
            } else {
                jToggleButton.setToolTipText(resources.getString("CapturingClickButton.disableText"));
            }
        }
    }

    protected class RedoButtonAction
    extends AbstractAction {
        protected RedoButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DOMViewer.this.addChangesToHistory();
            DOMViewer.this.historyBrowserInterface.getHistoryBrowser().redo();
        }
    }

    protected class UndoButtonAction
    extends AbstractAction {
        protected UndoButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DOMViewer.this.addChangesToHistory();
            DOMViewer.this.historyBrowserInterface.getHistoryBrowser().undo();
        }
    }

    protected class CloseButtonAction
    extends AbstractAction {
        protected CloseButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DOMViewer.this.panel.attributePanel.panelHiding()) {
                DOMViewer.this.panel.tree.setSelectionRow(0);
                DOMViewer.this.dispose();
            }
        }
    }
}

