/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.ParsedURL;

public class ImageCompareTest
extends AbstractTest {
    public static final String ERROR_COULD_NOT_OPEN_IMAGE = "ImageCompareTest.error.could.not.open.image";
    public static final String ERROR_COULD_NOT_LOAD_IMAGE = "ImageCompareTest.error.could.not.load.image";
    public static final String ERROR_DIFFERENCES = "ImageCompareTest.error.differences";
    public static final String ERROR_WHILE_COMPARING_FILES = "ImageCompareTest.error.while.comparing.files";
    public static final String ENTRY_KEY_FIRST_IMAGE = "ImageCompareTest.entry.key.first.image";
    public static final String ENTRY_KEY_SECOND_IMAGE = "ImageCompareTest.entry.key.second.image";
    public static final String ENTRY_KEY_COMPARISON = "ImageCompareTest.entry.key.comparison";
    public static final String ENTRY_KEY_DIFFERENCE = "ImageCompareTest.entry.key.difference";
    public static final String ENTRY_KEY_IMAGE_URL = "ImageCompareTest.entry.key.image.url";
    public static final String IMAGE_TYPE_DIFFERENCE = "_diff";
    public static final String IMAGE_TYPE_COMPARISON = "_cmp";
    public static final String TEMP_FILE_PREFIX = "ImageCompareTest";
    public static final String TEMP_FILE_SUFFIX = "";
    protected String urlAStr;
    protected URL urlA;
    protected String urlBStr;
    protected URL urlB;

    protected URL resolveURL(String url) {
        File f = new File(url).getAbsoluteFile();
        if (f.exists()) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException();
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url);
        }
    }

    public ImageCompareTest(String urlA, String urlB) {
        this.urlAStr = urlA;
        this.urlBStr = urlB;
    }

    protected void initURLs() {
        if (this.urlA == null) {
            throw new IllegalArgumentException();
        }
        if (this.urlB == null) {
            throw new IllegalArgumentException();
        }
        this.urlA = this.resolveURL(this.urlAStr);
        this.urlB = this.resolveURL(this.urlBStr);
    }

    public TestReport rumImpl() throws Exception {
        this.initURLs();
        BufferedInputStream streamA = null;
        try {
            streamA = new BufferedInputStream(this.urlA.openStream());
        }
        catch (IOException e) {
            return this.reportException(ERROR_COULD_NOT_OPEN_IMAGE, e);
        }
        BufferedInputStream streamB = null;
        try {
            streamB = new BufferedInputStream(this.urlB.openStream());
        }
        catch (IOException e) {
            return this.reportException(ERROR_COULD_NOT_OPEN_IMAGE, e);
        }
        boolean accurate = false;
        try {
            accurate = ImageCompareTest.compare(streamA, streamB);
        }
        catch (IOException e) {
            TestReport report = this.reportException(ERROR_WHILE_COMPARING_FILES, e);
            report.addDescriptionEntry(ENTRY_KEY_FIRST_IMAGE, (Object)this.urlA.toString());
            report.addDescriptionEntry(ENTRY_KEY_SECOND_IMAGE, (Object)this.urlB.toString());
            return report;
        }
        if (accurate) {
            return this.reportSuccess();
        }
        BufferedImage imageA = this.getImage(this.urlA);
        if (imageA == null) {
            TestReport report = this.reportError(ERROR_COULD_NOT_LOAD_IMAGE);
            report.addDescriptionEntry(ENTRY_KEY_IMAGE_URL, (Object)this.urlA.toString());
            return report;
        }
        BufferedImage imageB = this.getImage(this.urlB);
        if (imageB == null) {
            TestReport report = this.reportError(ERROR_COULD_NOT_LOAD_IMAGE);
            report.addDescriptionEntry(ENTRY_KEY_IMAGE_URL, (Object)this.urlB.toString());
            return report;
        }
        BufferedImage diff = ImageCompareTest.buildDiffImage(imageA, imageB);
        BufferedImage cmp = this.buildCompareImage(imageA, imageB);
        File tmpDiff = this.imageToFile(diff, IMAGE_TYPE_DIFFERENCE);
        File tmpCmp = this.imageToFile(cmp, IMAGE_TYPE_COMPARISON);
        TestReport report = this.reportError(ERROR_DIFFERENCES);
        report.addDescriptionEntry(ENTRY_KEY_COMPARISON, (Object)tmpCmp);
        report.addDescriptionEntry(ENTRY_KEY_DIFFERENCE, (Object)tmpDiff);
        return report;
    }

    protected BufferedImage buildCompareImage(BufferedImage ref, BufferedImage gen) {
        BufferedImage cmp = new BufferedImage(ref.getWidth() * 2, ref.getHeight(), 2);
        Graphics2D g = cmp.createGraphics();
        g.setPaint(Color.white);
        g.fillRect(0, 0, cmp.getWidth(), cmp.getHeight());
        g.drawImage((Image)ref, 0, 0, null);
        g.translate(ref.getWidth(), 0);
        g.drawImage((Image)gen, 0, 0, null);
        g.dispose();
        return cmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File imageToFile(BufferedImage img, String imageType) throws IOException {
        File imageFile = this.makeRandomFileName(imageType);
        imageFile.deleteOnExit();
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        FileOutputStream out = new FileOutputStream(imageFile);
        try {
            writer.writeImage((RenderedImage)img, (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
        }
        return imageFile;
    }

    protected File makeRandomFileName(String imageType) throws IOException {
        return File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX + imageType, null);
    }

    public static BufferedImage buildDiffImage(BufferedImage ref, BufferedImage gen) {
        ColorModel cm;
        boolean genPre;
        BufferedImage diff = new BufferedImage(ref.getWidth(), ref.getHeight(), 2);
        WritableRaster refWR = ref.getRaster();
        WritableRaster genWR = gen.getRaster();
        WritableRaster dstWR = diff.getRaster();
        boolean refPre = ref.isAlphaPremultiplied();
        if (!refPre) {
            ColorModel cm2 = ref.getColorModel();
            cm2 = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm2, (boolean)true);
            ref = new BufferedImage(cm2, refWR, true, null);
        }
        if (!(genPre = gen.isAlphaPremultiplied())) {
            ColorModel cm3 = gen.getColorModel();
            cm3 = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm3, (boolean)true);
            gen = new BufferedImage(cm3, genWR, true, null);
        }
        int w = ref.getWidth();
        int h = ref.getHeight();
        int[] refPix = null;
        int[] genPix = null;
        for (int y = 0; y < h; ++y) {
            refPix = refWR.getPixels(0, y, w, 1, refPix);
            genPix = genWR.getPixels(0, y, w, 1, genPix);
            for (int i = 0; i < refPix.length; ++i) {
                int val = (refPix[i] - genPix[i]) * 10 + 128;
                if ((val & 0xFFFFFF00) != 0) {
                    val = (val & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                genPix[i] = val;
            }
            dstWR.setPixels(0, y, w, 1, genPix);
        }
        if (!genPre) {
            cm = gen.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm, (boolean)false);
        }
        if (!refPre) {
            cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)false);
        }
        return diff;
    }

    public static boolean compare(InputStream refStream, InputStream newStream) throws IOException {
        int nb;
        int b;
        do {
            b = refStream.read();
            nb = newStream.read();
        } while (b != -1 && nb != -1 && b == nb);
        refStream.close();
        newStream.close();
        return b == nb;
    }

    protected BufferedImage getImage(URL url) {
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        Filter filt = reg.readURL(new ParsedURL(url));
        if (filt == null) {
            return null;
        }
        RenderedImage red = filt.createDefaultRendering();
        if (red == null) {
            return null;
        }
        BufferedImage img = new BufferedImage(red.getWidth(), red.getHeight(), 2);
        red.copyData(img.getRaster());
        return img;
    }
}

