/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.batik.dom.util.DocumentDescriptor;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.dom.util.HashTableStack;
import org.apache.batik.dom.util.SAXIOException;
import org.apache.batik.util.HaltingThread;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXDocumentFactory
extends DefaultHandler
implements LexicalHandler,
DocumentFactory {
    protected DOMImplementation implementation;
    protected String parserClassName;
    protected XMLReader parser;
    protected Document document;
    protected DocumentDescriptor documentDescriptor;
    protected boolean createDocumentDescriptor;
    protected Node currentNode;
    protected Locator locator;
    protected StringBuffer stringBuffer = new StringBuffer();
    protected boolean stringContent;
    protected boolean inDTD;
    protected boolean inCDATA;
    protected boolean inProlog;
    protected boolean isValidating;
    protected boolean isStandalone;
    protected String xmlVersion;
    protected HashTableStack namespaces;
    protected ErrorHandler errorHandler;
    protected List preInfo;
    static SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    public SAXDocumentFactory(DOMImplementation dOMImplementation, String string) {
        this.implementation = dOMImplementation;
        this.parserClassName = string;
    }

    public SAXDocumentFactory(DOMImplementation dOMImplementation, String string, boolean bl) {
        this.implementation = dOMImplementation;
        this.parserClassName = string;
        this.createDocumentDescriptor = bl;
    }

    public Document createDocument(String string, String string2, String string3) throws IOException {
        return this.createDocument(string, string2, string3, new InputSource(string3));
    }

    public Document createDocument(String string) throws IOException {
        return this.createDocument(new InputSource(string));
    }

    public Document createDocument(String string, String string2, String string3, InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string3);
        return this.createDocument(string, string2, string3, inputSource);
    }

    public Document createDocument(String string, InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.createDocument(inputSource);
    }

    public Document createDocument(String string, String string2, String string3, Reader reader) throws IOException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string3);
        return this.createDocument(string, string2, string3, inputSource);
    }

    public Document createDocument(String string, String string2, String string3, XMLReader xMLReader) throws IOException {
        xMLReader.setContentHandler(this);
        xMLReader.setDTDHandler(this);
        xMLReader.setEntityResolver(this);
        try {
            xMLReader.parse(string3);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null && exception instanceof InterruptedIOException) {
                throw (InterruptedIOException)exception;
            }
            throw new SAXIOException(sAXException);
        }
        this.currentNode = null;
        Document document = this.document;
        this.document = null;
        return document;
    }

    public Document createDocument(String string, Reader reader) throws IOException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        return this.createDocument(inputSource);
    }

    protected Document createDocument(String string, String string2, String string3, InputSource inputSource) throws IOException {
        String string4;
        Document document = this.createDocument(inputSource);
        Element element = document.getDocumentElement();
        String string5 = string2;
        String string6 = string;
        if (string == null) {
            int n = string5.indexOf(58);
            String string7 = n == -1 || n == string5.length() - 1 ? "" : string5.substring(0, n);
            string6 = this.namespaces.get(string7);
            if (n != -1 && n != string5.length() - 1) {
                string5 = string5.substring(n + 1);
            }
        }
        if (!((string4 = element.getNamespaceURI()) == string6 || string4 != null && string4.equals(string6))) {
            throw new IOException("Root element namespace does not match that requested:\nRequested: " + string6 + "\n" + "Found: " + string4);
        }
        if (string4 != null) {
            if (!element.getLocalName().equals(string5)) {
                throw new IOException("Root element does not match that requested:\nRequested: " + string5 + "\n" + "Found: " + element.getLocalName());
            }
        } else if (!element.getNodeName().equals(string5)) {
            throw new IOException("Root element does not match that requested:\nRequested: " + string5 + "\n" + "Found: " + element.getNodeName());
        }
        return document;
    }

    protected Document createDocument(InputSource inputSource) throws IOException {
        Object object;
        try {
            if (this.parserClassName != null) {
                this.parser = XMLReaderFactory.createXMLReader(this.parserClassName);
            } else {
                try {
                    object = saxFactory.newSAXParser();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException("Could not create SAXParser: " + parserConfigurationException.getMessage());
                }
                this.parser = ((SAXParser)object).getXMLReader();
            }
            this.parser.setContentHandler(this);
            this.parser.setDTDHandler(this);
            this.parser.setEntityResolver(this);
            this.parser.setErrorHandler(this.errorHandler == null ? this : this.errorHandler);
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            this.parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.parser.setFeature("http://xml.org/sax/features/validation", this.isValidating);
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null && exception instanceof InterruptedIOException) {
                throw (InterruptedIOException)exception;
            }
            throw new SAXIOException(sAXException);
        }
        this.currentNode = null;
        object = this.document;
        this.document = null;
        this.locator = null;
        this.parser = null;
        return object;
    }

    public DocumentDescriptor getDocumentDescriptor() {
        return this.documentDescriptor;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setValidating(boolean bl) {
        this.isValidating = bl;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public DOMImplementation getDOMImplementation(String string) {
        return this.implementation;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.preInfo = new LinkedList();
        this.namespaces = new HashTableStack();
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.namespaces.put("", null);
        this.inDTD = false;
        this.inCDATA = false;
        this.inProlog = true;
        this.currentNode = null;
        this.document = null;
        this.isStandalone = false;
        this.xmlVersion = "1.0";
        this.stringBuffer.setLength(0);
        this.stringContent = false;
        this.documentDescriptor = this.createDocumentDescriptor ? new DocumentDescriptor() : null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Element element;
        String string4;
        if (HaltingThread.hasBeenHalted()) {
            throw new SAXException(new InterruptedIOException());
        }
        if (this.inProlog) {
            this.inProlog = false;
            try {
                this.isStandalone = this.parser.getFeature("http://xml.org/sax/features/is-standalone");
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            try {
                this.xmlVersion = (String)this.parser.getProperty("http://xml.org/sax/properties/document-xml-version");
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        int n = attributes.getLength();
        this.namespaces.push();
        String string5 = null;
        for (int i = 0; i < n; ++i) {
            String string6 = attributes.getQName(i);
            int n2 = string6.length();
            if (n2 < 5) continue;
            if (string6.equals("version")) {
                string5 = attributes.getValue(i);
                continue;
            }
            if (!string6.startsWith("xmlns")) continue;
            if (n2 == 5) {
                string4 = attributes.getValue(i);
                if (string4.length() == 0) {
                    string4 = null;
                }
                this.namespaces.put("", string4);
                continue;
            }
            if (string6.charAt(5) != ':') continue;
            string4 = attributes.getValue(i);
            if (string4.length() == 0) {
                string4 = null;
            }
            this.namespaces.put(string6.substring(6), string4);
        }
        this.appendStringData();
        int n3 = string3.indexOf(58);
        String string7 = n3 == -1 || n3 == string3.length() - 1 ? "" : string3.substring(0, n3);
        string4 = this.namespaces.get(string7);
        if (this.currentNode == null) {
            this.implementation = this.getDOMImplementation(string5);
            this.document = this.implementation.createDocument(string4, string3, null);
            Iterator iterator = this.preInfo.iterator();
            element = this.document.getDocumentElement();
            this.currentNode = element;
            while (iterator.hasNext()) {
                object = (PreInfo)iterator.next();
                Node node = object.createNode(this.document);
                this.document.insertBefore(node, element);
            }
            this.preInfo = null;
        } else {
            element = this.document.createElementNS(string4, string3);
            this.currentNode.appendChild(element);
            this.currentNode = element;
        }
        if (this.createDocumentDescriptor && this.locator != null) {
            this.documentDescriptor.setLocation(element, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        for (int i = 0; i < n; ++i) {
            object = attributes.getQName(i);
            if (((String)object).equals("xmlns")) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", (String)object, attributes.getValue(i));
                continue;
            }
            n3 = ((String)object).indexOf(58);
            string4 = n3 == -1 ? null : this.namespaces.get(((String)object).substring(0, n3));
            element.setAttributeNS(string4, (String)object, attributes.getValue(i));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.appendStringData();
        if (this.currentNode != null) {
            this.currentNode = this.currentNode.getParentNode();
        }
        this.namespaces.pop();
    }

    public void appendStringData() {
        if (!this.stringContent) {
            return;
        }
        String string = this.stringBuffer.toString();
        this.stringBuffer.setLength(0);
        this.stringContent = false;
        if (this.currentNode == null) {
            if (this.inCDATA) {
                this.preInfo.add(new CDataInfo(string));
            } else {
                this.preInfo.add(new TextInfo(string));
            }
        } else {
            Text text = this.inCDATA ? this.document.createCDATASection(string) : this.document.createTextNode(string);
            this.currentNode.appendChild(text);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.stringBuffer.append(cArray, n, n2);
        this.stringContent = true;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.stringBuffer.append(cArray, n, n2);
        this.stringContent = true;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.appendStringData();
        if (this.currentNode == null) {
            this.preInfo.add(new ProcessingInstructionInfo(string, string2));
        } else {
            this.currentNode.appendChild(this.document.createProcessingInstruction(string, string2));
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.appendStringData();
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.appendStringData();
        this.inCDATA = true;
        this.stringContent = true;
    }

    public void endCDATA() throws SAXException {
        this.appendStringData();
        this.inCDATA = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.appendStringData();
        String string = new String(cArray, n, n2);
        if (this.currentNode == null) {
            this.preInfo.add(new CommentInfo(string));
        } else {
            this.currentNode.appendChild(this.document.createComment(string));
        }
    }

    static {
        try {
            saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    static class TextInfo
    implements PreInfo {
        public String text;

        public TextInfo(String string) {
            this.text = string;
        }

        public Node createNode(Document document) {
            return document.createTextNode(this.text);
        }
    }

    static class CDataInfo
    implements PreInfo {
        public String cdata;

        public CDataInfo(String string) {
            this.cdata = string;
        }

        public Node createNode(Document document) {
            return document.createCDATASection(this.cdata);
        }
    }

    static class CommentInfo
    implements PreInfo {
        public String comment;

        public CommentInfo(String string) {
            this.comment = string;
        }

        public Node createNode(Document document) {
            return document.createComment(this.comment);
        }
    }

    static class ProcessingInstructionInfo
    implements PreInfo {
        public String target;
        public String data;

        public ProcessingInstructionInfo(String string, String string2) {
            this.target = string;
            this.data = string2;
        }

        public Node createNode(Document document) {
            return document.createProcessingInstruction(this.target, this.data);
        }
    }

    protected static interface PreInfo {
        public Node createNode(Document var1);
    }
}

