/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.batik.apps.svgbrowser.HistoryBrowser;
import org.apache.batik.apps.svgbrowser.HistoryBrowserInterface;
import org.apache.batik.util.gui.DropDownComponent;
import org.apache.batik.util.resources.ResourceManager;

public class DropDownHistoryModel
implements DropDownComponent.ScrollablePopupMenuModel {
    private static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.DropDownHistoryModelMessages";
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.DropDownHistoryModelMessages", Locale.getDefault());
    private static ResourceManager resources = new ResourceManager(bundle);
    protected ArrayList items = new ArrayList();
    protected HistoryBrowserInterface historyBrowserInterface;
    protected DropDownComponent.ScrollablePopupMenu parent;

    public DropDownHistoryModel(DropDownComponent.ScrollablePopupMenu scrollablePopupMenu, HistoryBrowserInterface historyBrowserInterface) {
        this.parent = scrollablePopupMenu;
        this.historyBrowserInterface = historyBrowserInterface;
        historyBrowserInterface.getHistoryBrowser().addListener(new HistoryBrowser.HistoryBrowserAdapter(){

            public void historyReset(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                DropDownHistoryModel.this.clearAllScrollablePopupMenuItems("");
            }
        });
    }

    public String getFooterText() {
        return "";
    }

    public DropDownComponent.ScrollablePopupMenuItem createItem(String string) {
        return new DropDownComponent.DefaultScrollablePopupMenuItem(this.parent, string);
    }

    protected void addItem(DropDownComponent.ScrollablePopupMenuItem scrollablePopupMenuItem, String string) {
        int n = this.items.size();
        this.items.add(0, scrollablePopupMenuItem);
        this.parent.add(scrollablePopupMenuItem, 0, n, this.items.size());
        this.parent.fireItemsWereAdded(new DropDownComponent.ScrollablePopupMenuEvent((Object)this.parent, 1, 1, string));
    }

    protected void removeItem(DropDownComponent.ScrollablePopupMenuItem scrollablePopupMenuItem, String string) {
        int n = this.items.size();
        this.items.remove(scrollablePopupMenuItem);
        this.parent.remove(scrollablePopupMenuItem, n, this.items.size());
        this.parent.fireItemsWereRemoved(new DropDownComponent.ScrollablePopupMenuEvent((Object)this.parent, 2, 1, string));
    }

    protected boolean removeLastScrollablePopupMenuItem(String string) {
        int n = this.items.size() - 1;
        if (n >= 0) {
            DropDownComponent.ScrollablePopupMenuItem scrollablePopupMenuItem = (DropDownComponent.ScrollablePopupMenuItem)this.items.get(n);
            this.removeItem(scrollablePopupMenuItem, string);
            return true;
        }
        return false;
    }

    protected boolean removeFirstScrollablePopupMenuItem(String string) {
        int n = 0;
        if (n < this.items.size()) {
            DropDownComponent.ScrollablePopupMenuItem scrollablePopupMenuItem = (DropDownComponent.ScrollablePopupMenuItem)this.items.get(n);
            this.removeItem(scrollablePopupMenuItem, string);
            return true;
        }
        return false;
    }

    protected void clearAllScrollablePopupMenuItems(String string) {
        while (this.removeLastScrollablePopupMenuItem(string)) {
        }
    }

    public void processItemClicked() {
    }

    public void processBeforeShowed() {
        this.historyBrowserInterface.performCurrentCompoundCommand();
    }

    public void processAfterShowed() {
    }

    static /* synthetic */ ResourceManager access$000() {
        return resources;
    }

    public static class RedoPopUpMenuModel
    extends DropDownHistoryModel {
        protected static String REDO_FOOTER_TEXT = DropDownHistoryModel.access$000().getString("RedoModel.footerText");
        protected static String REDO_TOOLTIP_PREFIX = DropDownHistoryModel.access$000().getString("RedoModel.tooltipPrefix");

        public RedoPopUpMenuModel(DropDownComponent.ScrollablePopupMenu scrollablePopupMenu, HistoryBrowserInterface historyBrowserInterface) {
            super(scrollablePopupMenu, historyBrowserInterface);
            this.init();
        }

        private void init() {
            this.historyBrowserInterface.getHistoryBrowser().addListener(new HistoryBrowser.HistoryBrowserAdapter(this){
                private final /* synthetic */ RedoPopUpMenuModel this$0;
                {
                    this.this$0 = redoPopUpMenuModel;
                }

                public void executePerformed(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                    HistoryBrowser.CommandNamesInfo commandNamesInfo = (HistoryBrowser.CommandNamesInfo)historyBrowserEvent.getSource();
                    String string = RedoPopUpMenuModel.REDO_TOOLTIP_PREFIX + commandNamesInfo.getLastRedoableCommandName();
                    this.this$0.clearAllScrollablePopupMenuItems(string);
                }

                public void undoPerformed(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                    HistoryBrowser.CommandNamesInfo commandNamesInfo = (HistoryBrowser.CommandNamesInfo)historyBrowserEvent.getSource();
                    String string = RedoPopUpMenuModel.REDO_TOOLTIP_PREFIX + commandNamesInfo.getLastRedoableCommandName();
                    this.this$0.addItem(this.this$0.createItem(commandNamesInfo.getCommandName()), string);
                }

                public void redoPerformed(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                    HistoryBrowser.CommandNamesInfo commandNamesInfo = (HistoryBrowser.CommandNamesInfo)historyBrowserEvent.getSource();
                    String string = RedoPopUpMenuModel.REDO_TOOLTIP_PREFIX + commandNamesInfo.getLastRedoableCommandName();
                    this.this$0.removeFirstScrollablePopupMenuItem(string);
                }

                public void doCompoundEdit(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                    if (this.this$0.parent.isEnabled()) {
                        this.this$0.parent.setEnabled(false);
                    }
                }

                public void compoundEditPerformed(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                }
            });
        }

        public String getFooterText() {
            return REDO_FOOTER_TEXT;
        }

        public void processItemClicked() {
            this.historyBrowserInterface.getHistoryBrowser().compoundRedo(this.parent.getSelectedItemsCount());
        }
    }

    public static class UndoPopUpMenuModel
    extends DropDownHistoryModel {
        protected static String UNDO_FOOTER_TEXT = DropDownHistoryModel.access$000().getString("UndoModel.footerText");
        protected static String UNDO_TOOLTIP_PREFIX = DropDownHistoryModel.access$000().getString("UndoModel.tooltipPrefix");

        public UndoPopUpMenuModel(DropDownComponent.ScrollablePopupMenu scrollablePopupMenu, HistoryBrowserInterface historyBrowserInterface) {
            super(scrollablePopupMenu, historyBrowserInterface);
            this.init();
        }

        private void init() {
            this.historyBrowserInterface.getHistoryBrowser().addListener(new HistoryBrowser.HistoryBrowserAdapter(this){
                private final /* synthetic */ UndoPopUpMenuModel this$0;
                {
                    this.this$0 = undoPopUpMenuModel;
                }

                public void executePerformed(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                    HistoryBrowser.CommandNamesInfo commandNamesInfo = (HistoryBrowser.CommandNamesInfo)historyBrowserEvent.getSource();
                    String string = UndoPopUpMenuModel.UNDO_TOOLTIP_PREFIX + commandNamesInfo.getLastUndoableCommandName();
                    this.this$0.addItem(this.this$0.createItem(commandNamesInfo.getCommandName()), string);
                }

                public void undoPerformed(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                    HistoryBrowser.CommandNamesInfo commandNamesInfo = (HistoryBrowser.CommandNamesInfo)historyBrowserEvent.getSource();
                    String string = UndoPopUpMenuModel.UNDO_TOOLTIP_PREFIX + commandNamesInfo.getLastUndoableCommandName();
                    this.this$0.removeFirstScrollablePopupMenuItem(string);
                }

                public void redoPerformed(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                    HistoryBrowser.CommandNamesInfo commandNamesInfo = (HistoryBrowser.CommandNamesInfo)historyBrowserEvent.getSource();
                    String string = UndoPopUpMenuModel.UNDO_TOOLTIP_PREFIX + commandNamesInfo.getLastUndoableCommandName();
                    this.this$0.addItem(this.this$0.createItem(commandNamesInfo.getCommandName()), string);
                }

                public void doCompoundEdit(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                    if (!this.this$0.parent.isEnabled()) {
                        this.this$0.parent.setEnabled(true);
                    }
                }

                public void compoundEditPerformed(HistoryBrowser.HistoryBrowserEvent historyBrowserEvent) {
                }
            });
        }

        public String getFooterText() {
            return UNDO_FOOTER_TEXT;
        }

        public void processItemClicked() {
            this.historyBrowserInterface.getHistoryBrowser().compoundUndo(this.parent.getSelectedItemsCount());
        }
    }
}

