/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.swing.Messages;
import org.apache.batik.swing.gvt.AbstractImageZoomInteractor;
import org.apache.batik.swing.gvt.AbstractJGVTComponent;
import org.apache.batik.swing.gvt.AbstractPanInteractor;
import org.apache.batik.swing.gvt.AbstractResetTransformInteractor;
import org.apache.batik.swing.gvt.AbstractRotateInteractor;
import org.apache.batik.swing.gvt.AbstractZoomInteractor;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.svg.AbstractJSVGComponent;
import org.apache.batik.swing.svg.JSVGComponent;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.XMLConstants;
import org.apache.batik.util.gui.JErrorPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

public class JSVGCanvas
extends JSVGComponent {
    public static final String SCROLL_RIGHT_ACTION = "ScrollRight";
    public static final String SCROLL_LEFT_ACTION = "ScrollLeft";
    public static final String SCROLL_UP_ACTION = "ScrollUp";
    public static final String SCROLL_DOWN_ACTION = "ScrollDown";
    public static final String FAST_SCROLL_RIGHT_ACTION = "FastScrollRight";
    public static final String FAST_SCROLL_LEFT_ACTION = "FastScrollLeft";
    public static final String FAST_SCROLL_UP_ACTION = "FastScrollUp";
    public static final String FAST_SCROLL_DOWN_ACTION = "FastScrollDown";
    public static final String ZOOM_IN_ACTION = "ZoomIn";
    public static final String ZOOM_OUT_ACTION = "ZoomOut";
    public static final String RESET_TRANSFORM_ACTION = "ResetTransform";
    private boolean isZoomInteractorEnabled = true;
    private boolean isImageZoomInteractorEnabled = true;
    private boolean isPanInteractorEnabled = true;
    private boolean isRotateInteractorEnabled = true;
    private boolean isResetTransformInteractorEnabled = true;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected String uri;
    protected LocationListener locationListener = new LocationListener();
    protected Map toolTipMap = null;
    protected EventListener toolTipListener = new ToolTipModifier();
    protected EventTarget lastTarget = null;
    protected Map toolTipDocs = null;
    protected static final Object MAP_TOKEN = new Object();
    protected long lastToolTipEventTimeStamp;
    protected EventTarget lastToolTipEventTarget;
    protected Interactor zoomInteractor = new AbstractZoomInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 501 && (n & 0x10) != 0 && (n & 2) != 0;
        }
    };
    protected Interactor imageZoomInteractor = new AbstractImageZoomInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 501 && (n & 4) != 0 && (n & 1) != 0;
        }
    };
    protected Interactor panInteractor = new AbstractPanInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 501 && (n & 0x10) != 0 && (n & 1) != 0;
        }
    };
    protected Interactor rotateInteractor = new AbstractRotateInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 501 && (n & 4) != 0 && (n & 2) != 0;
        }
    };
    protected Interactor resetTransformInteractor = new AbstractResetTransformInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 500 && (n & 4) != 0 && (n & 1) != 0 && (n & 2) != 0;
        }
    };

    public JSVGCanvas() {
        this(null, true, true);
        this.addMouseMotionListener(this.locationListener);
    }

    public JSVGCanvas(SVGUserAgent sVGUserAgent, boolean bl, boolean bl2) {
        super(sVGUserAgent, bl, bl2);
        this.setPreferredSize(new Dimension(200, 200));
        this.setMinimumSize(new Dimension(100, 100));
        List list = this.getInteractors();
        list.add(this.zoomInteractor);
        list.add(this.imageZoomInteractor);
        list.add(this.panInteractor);
        list.add(this.rotateInteractor);
        list.add(this.resetTransformInteractor);
        this.installActions();
        if (bl) {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    JSVGCanvas.this.requestFocus();
                }
            });
            this.installKeyboardActions();
        }
        this.addMouseMotionListener(this.locationListener);
    }

    protected void installActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put(SCROLL_RIGHT_ACTION, new ScrollRightAction(10));
        actionMap.put(SCROLL_LEFT_ACTION, new ScrollLeftAction(10));
        actionMap.put(SCROLL_UP_ACTION, new ScrollUpAction(10));
        actionMap.put(SCROLL_DOWN_ACTION, new ScrollDownAction(10));
        actionMap.put(FAST_SCROLL_RIGHT_ACTION, new ScrollRightAction(30));
        actionMap.put(FAST_SCROLL_LEFT_ACTION, new ScrollLeftAction(30));
        actionMap.put(FAST_SCROLL_UP_ACTION, new ScrollUpAction(30));
        actionMap.put(FAST_SCROLL_DOWN_ACTION, new ScrollDownAction(30));
        actionMap.put(ZOOM_IN_ACTION, new ZoomInAction());
        actionMap.put(ZOOM_OUT_ACTION, new ZoomOutAction());
        actionMap.put(RESET_TRANSFORM_ACTION, new ResetTransformAction());
    }

    public void setDisableInteractions(boolean bl) {
        super.setDisableInteractions(bl);
        ActionMap actionMap = this.getActionMap();
        actionMap.get(SCROLL_RIGHT_ACTION).setEnabled(!bl);
        actionMap.get(SCROLL_LEFT_ACTION).setEnabled(!bl);
        actionMap.get(SCROLL_UP_ACTION).setEnabled(!bl);
        actionMap.get(SCROLL_DOWN_ACTION).setEnabled(!bl);
        actionMap.get(FAST_SCROLL_RIGHT_ACTION).setEnabled(!bl);
        actionMap.get(FAST_SCROLL_LEFT_ACTION).setEnabled(!bl);
        actionMap.get(FAST_SCROLL_UP_ACTION).setEnabled(!bl);
        actionMap.get(FAST_SCROLL_DOWN_ACTION).setEnabled(!bl);
        actionMap.get(ZOOM_IN_ACTION).setEnabled(!bl);
        actionMap.get(ZOOM_OUT_ACTION).setEnabled(!bl);
        actionMap.get(RESET_TRANSFORM_ACTION).setEnabled(!bl);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 0);
        inputMap.put(keyStroke, SCROLL_RIGHT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(37, 0);
        inputMap.put(keyStroke, SCROLL_LEFT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        inputMap.put(keyStroke, SCROLL_UP_ACTION);
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(keyStroke, SCROLL_DOWN_ACTION);
        keyStroke = KeyStroke.getKeyStroke(39, 1);
        inputMap.put(keyStroke, FAST_SCROLL_RIGHT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(37, 1);
        inputMap.put(keyStroke, FAST_SCROLL_LEFT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(38, 1);
        inputMap.put(keyStroke, FAST_SCROLL_UP_ACTION);
        keyStroke = KeyStroke.getKeyStroke(40, 1);
        inputMap.put(keyStroke, FAST_SCROLL_DOWN_ACTION);
        keyStroke = KeyStroke.getKeyStroke(73, 2);
        inputMap.put(keyStroke, ZOOM_IN_ACTION);
        keyStroke = KeyStroke.getKeyStroke(79, 2);
        inputMap.put(keyStroke, ZOOM_OUT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(84, 2);
        inputMap.put(keyStroke, RESET_TRANSFORM_ACTION);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void setEnableZoomInteractor(boolean bl) {
        if (this.isZoomInteractorEnabled != bl) {
            boolean bl2 = this.isZoomInteractorEnabled;
            this.isZoomInteractorEnabled = bl;
            if (this.isZoomInteractorEnabled) {
                this.getInteractors().add(this.zoomInteractor);
            } else {
                this.getInteractors().remove(this.zoomInteractor);
            }
            this.pcs.firePropertyChange("enableZoomInteractor", bl2, bl);
        }
    }

    public boolean getEnableZoomInteractor() {
        return this.isZoomInteractorEnabled;
    }

    public void setEnableImageZoomInteractor(boolean bl) {
        if (this.isImageZoomInteractorEnabled != bl) {
            boolean bl2 = this.isImageZoomInteractorEnabled;
            this.isImageZoomInteractorEnabled = bl;
            if (this.isImageZoomInteractorEnabled) {
                this.getInteractors().add(this.imageZoomInteractor);
            } else {
                this.getInteractors().remove(this.imageZoomInteractor);
            }
            this.pcs.firePropertyChange("enableImageZoomInteractor", bl2, bl);
        }
    }

    public boolean getEnableImageZoomInteractor() {
        return this.isImageZoomInteractorEnabled;
    }

    public void setEnablePanInteractor(boolean bl) {
        if (this.isPanInteractorEnabled != bl) {
            boolean bl2 = this.isPanInteractorEnabled;
            this.isPanInteractorEnabled = bl;
            if (this.isPanInteractorEnabled) {
                this.getInteractors().add(this.panInteractor);
            } else {
                this.getInteractors().remove(this.panInteractor);
            }
            this.pcs.firePropertyChange("enablePanInteractor", bl2, bl);
        }
    }

    public boolean getEnablePanInteractor() {
        return this.isPanInteractorEnabled;
    }

    public void setEnableRotateInteractor(boolean bl) {
        if (this.isRotateInteractorEnabled != bl) {
            boolean bl2 = this.isRotateInteractorEnabled;
            this.isRotateInteractorEnabled = bl;
            if (this.isRotateInteractorEnabled) {
                this.getInteractors().add(this.rotateInteractor);
            } else {
                this.getInteractors().remove(this.rotateInteractor);
            }
            this.pcs.firePropertyChange("enableRotateInteractor", bl2, bl);
        }
    }

    public boolean getEnableRotateInteractor() {
        return this.isRotateInteractorEnabled;
    }

    public void setEnableResetTransformInteractor(boolean bl) {
        if (this.isResetTransformInteractorEnabled != bl) {
            boolean bl2 = this.isResetTransformInteractorEnabled;
            this.isResetTransformInteractorEnabled = bl;
            if (this.isResetTransformInteractorEnabled) {
                this.getInteractors().add(this.resetTransformInteractor);
            } else {
                this.getInteractors().remove(this.resetTransformInteractor);
            }
            this.pcs.firePropertyChange("enableResetTransformInteractor", bl2, bl);
        }
    }

    public boolean getEnableResetTransformInteractor() {
        return this.isResetTransformInteractorEnabled;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String string) {
        String string2 = this.uri;
        this.uri = string;
        if (this.uri != null) {
            this.loadSVGDocument(this.uri);
        } else {
            this.setSVGDocument(null);
        }
        this.pcs.firePropertyChange("URI", string2, this.uri);
    }

    protected UserAgent createUserAgent() {
        return new CanvasUserAgent();
    }

    protected AbstractJGVTComponent.Listener createListener() {
        return new CanvasSVGListener();
    }

    protected void installSVGDocument(SVGDocument sVGDocument) {
        if (this.toolTipDocs != null) {
            Iterator iterator = this.toolTipDocs.keySet().iterator();
            while (iterator.hasNext()) {
                NodeEventTarget nodeEventTarget;
                SVGDocument sVGDocument2 = (SVGDocument)iterator.next();
                if (sVGDocument2 == null || (nodeEventTarget = (NodeEventTarget)sVGDocument2.getRootElement()) == null) continue;
                nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.toolTipListener, false);
                nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.toolTipListener, false);
            }
            this.toolTipDocs = null;
        }
        this.lastTarget = null;
        if (this.toolTipMap != null) {
            this.toolTipMap.clear();
        }
        super.installSVGDocument(sVGDocument);
    }

    public void setLastToolTipEvent(long l, EventTarget eventTarget) {
        this.lastToolTipEventTimeStamp = l;
        this.lastToolTipEventTarget = eventTarget;
    }

    public boolean matchLastToolTipEvent(long l, EventTarget eventTarget) {
        return this.lastToolTipEventTimeStamp == l && this.lastToolTipEventTarget == eventTarget;
    }

    protected class ToolTipRunnable
    implements Runnable {
        String theToolTip;

        public ToolTipRunnable(String string) {
            this.theToolTip = string;
        }

        public void run() {
            JSVGCanvas.this.setToolTipText(this.theToolTip);
            if (this.theToolTip != null) {
                MouseEvent mouseEvent = new MouseEvent(JSVGCanvas.this, 504, System.currentTimeMillis(), 0, JSVGCanvas.this.locationListener.getLastX(), JSVGCanvas.this.locationListener.getLastY(), 0, false);
                ToolTipManager.sharedInstance().mouseEntered(mouseEvent);
                mouseEvent = new MouseEvent(JSVGCanvas.this, 503, System.currentTimeMillis(), 0, JSVGCanvas.this.locationListener.getLastX(), JSVGCanvas.this.locationListener.getLastY(), 0, false);
                ToolTipManager.sharedInstance().mouseMoved(mouseEvent);
            } else {
                MouseEvent mouseEvent = new MouseEvent(JSVGCanvas.this, 503, System.currentTimeMillis(), 0, JSVGCanvas.this.locationListener.getLastX(), JSVGCanvas.this.locationListener.getLastY(), 0, false);
                ToolTipManager.sharedInstance().mouseMoved(mouseEvent);
            }
        }
    }

    protected class ToolTipModifier
    implements EventListener {
        protected CanvasUserAgent canvasUserAgent;

        public void handleEvent(Event event) {
            Object object;
            if (JSVGCanvas.this.matchLastToolTipEvent(event.getTimeStamp(), event.getTarget())) {
                return;
            }
            JSVGCanvas.this.setLastToolTipEvent(event.getTimeStamp(), event.getTarget());
            EventTarget eventTarget = JSVGCanvas.this.lastTarget;
            if ("mouseover".equals(event.getType())) {
                JSVGCanvas.this.lastTarget = event.getTarget();
            } else if ("mouseout".equals(event.getType())) {
                object = (org.w3c.dom.events.MouseEvent)event;
                JSVGCanvas.this.lastTarget = object.getRelatedTarget();
            }
            if (JSVGCanvas.this.toolTipMap != null) {
                object = (Element)((Object)JSVGCanvas.this.lastTarget);
                Object var4_4 = null;
                while (object != null && (var4_4 = JSVGCanvas.this.toolTipMap.get(object)) == null) {
                    object = CSSEngine.getParentCSSStylableElement((Element)object);
                }
                String string = var4_4;
                if (eventTarget != JSVGCanvas.this.lastTarget) {
                    EventQueue.invokeLater(new ToolTipRunnable(string));
                }
            }
        }
    }

    protected class LocationListener
    extends MouseMotionAdapter {
        protected int lastX = 0;
        protected int lastY = 0;

        public void mouseMoved(MouseEvent mouseEvent) {
            this.lastX = mouseEvent.getX();
            this.lastY = mouseEvent.getY();
        }

        public int getLastX() {
            return this.lastX;
        }

        public int getLastY() {
            return this.lastY;
        }
    }

    protected class CanvasUserAgent
    extends AbstractJSVGComponent.BridgeUserAgent
    implements XMLConstants {
        final String TOOLTIP_TITLE_ONLY = "JSVGCanvas.CanvasUserAgent.ToolTip.titleOnly";
        final String TOOLTIP_DESC_ONLY = "JSVGCanvas.CanvasUserAgent.ToolTip.descOnly";
        final String TOOLTIP_TITLE_AND_TEXT = "JSVGCanvas.CanvasUserAgent.ToolTip.titleAndDesc";

        protected CanvasUserAgent() {
            super(JSVGCanvas.this);
        }

        public void handleElement(Element element, Object object) {
            super.handleElement(element, object);
            if (!JSVGCanvas.this.isInteractive()) {
                return;
            }
            if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
                return;
            }
            if (element.getParentNode() == element.getOwnerDocument().getDocumentElement()) {
                return;
            }
            Element element2 = object instanceof Element ? (Element)object : (Element)element.getParentNode();
            Element element3 = null;
            Element element4 = null;
            if (element.getLocalName().equals("title")) {
                if (object == Boolean.TRUE) {
                    element4 = element;
                }
                element3 = this.getPeerWithTag(element2, "http://www.w3.org/2000/svg", "desc");
            } else if (element.getLocalName().equals("desc")) {
                if (object == Boolean.TRUE) {
                    element3 = element;
                }
                element4 = this.getPeerWithTag(element2, "http://www.w3.org/2000/svg", "title");
            }
            String string = null;
            if (element4 != null) {
                element4.normalize();
                if (element4.getFirstChild() != null) {
                    string = element4.getFirstChild().getNodeValue();
                }
            }
            String string2 = null;
            if (element3 != null) {
                element3.normalize();
                if (element3.getFirstChild() != null) {
                    string2 = element3.getFirstChild().getNodeValue();
                }
            }
            String string3 = string != null && string.length() != 0 ? (string2 != null && string2.length() != 0 ? Messages.formatMessage("JSVGCanvas.CanvasUserAgent.ToolTip.titleAndDesc", new Object[]{this.toFormattedHTML(string), this.toFormattedHTML(string2)}) : Messages.formatMessage("JSVGCanvas.CanvasUserAgent.ToolTip.titleOnly", new Object[]{this.toFormattedHTML(string)})) : (string2 != null && string2.length() != 0 ? Messages.formatMessage("JSVGCanvas.CanvasUserAgent.ToolTip.descOnly", new Object[]{this.toFormattedHTML(string2)}) : null);
            if (string3 == null) {
                this.removeToolTip(element2);
                return;
            }
            if (JSVGCanvas.this.lastTarget != element2) {
                this.setToolTip(element2, string3);
            } else {
                Object var9_9 = null;
                if (JSVGCanvas.this.toolTipMap != null) {
                    var9_9 = JSVGCanvas.this.toolTipMap.get(element2);
                    JSVGCanvas.this.toolTipMap.put(element2, string3);
                }
                if (var9_9 != null) {
                    EventQueue.invokeLater(new Runnable(this, string3){
                        private final /* synthetic */ String val$toolTip;
                        private final /* synthetic */ CanvasUserAgent this$1;
                        {
                            this.this$1 = canvasUserAgent;
                            this.val$toolTip = string;
                        }

                        public void run() {
                            CanvasUserAgent.access$200(this.this$1).setToolTipText(this.val$toolTip);
                            MouseEvent mouseEvent = new MouseEvent(CanvasUserAgent.access$200(this.this$1), 503, System.currentTimeMillis(), 0, CanvasUserAgent.access$200((CanvasUserAgent)this.this$1).locationListener.getLastX(), CanvasUserAgent.access$200((CanvasUserAgent)this.this$1).locationListener.getLastY(), 0, false);
                            ToolTipManager.sharedInstance().mouseMoved(mouseEvent);
                        }
                    });
                } else {
                    EventQueue.invokeLater(new ToolTipRunnable(string3));
                }
            }
        }

        public String toFormattedHTML(String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            this.replace(stringBuffer, '&', "&amp;");
            this.replace(stringBuffer, '<', "&lt;");
            this.replace(stringBuffer, '>', "&gt;");
            this.replace(stringBuffer, '\"', "&quot;");
            this.replace(stringBuffer, '\n', "<br>");
            return stringBuffer.toString();
        }

        protected void replace(StringBuffer stringBuffer, char c, String string) {
            String string2 = stringBuffer.toString();
            int n = string2.length();
            while ((n = string2.lastIndexOf(c, n - 1)) != -1) {
                stringBuffer.deleteCharAt(n);
                stringBuffer.insert(n, string);
            }
        }

        public Element getPeerWithTag(Element element, String string, String string2) {
            Element element2 = element;
            if (element2 == null) {
                return null;
            }
            for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!string.equals(node.getNamespaceURI()) || !string2.equals(node.getLocalName()) || node.getNodeType() != 1) continue;
                return (Element)node;
            }
            return null;
        }

        public boolean hasPeerWithTag(Element element, String string, String string2) {
            return this.getPeerWithTag(element, string, string2) != null;
        }

        public void setToolTip(Element element, String string) {
            SVGDocument sVGDocument;
            if (JSVGCanvas.this.toolTipMap == null) {
                JSVGCanvas.this.toolTipMap = new WeakHashMap();
            }
            if (JSVGCanvas.this.toolTipDocs == null) {
                JSVGCanvas.this.toolTipDocs = new WeakHashMap();
            }
            if (JSVGCanvas.this.toolTipDocs.put(sVGDocument = (SVGDocument)element.getOwnerDocument(), MAP_TOKEN) == null) {
                NodeEventTarget nodeEventTarget = (NodeEventTarget)sVGDocument.getRootElement();
                nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", JSVGCanvas.this.toolTipListener, false, null);
                nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", JSVGCanvas.this.toolTipListener, false, null);
            }
            JSVGCanvas.this.toolTipMap.put(element, string);
            if (element == JSVGCanvas.this.lastTarget) {
                EventQueue.invokeLater(new ToolTipRunnable(string));
            }
        }

        public void removeToolTip(Element element) {
            if (JSVGCanvas.this.toolTipMap != null) {
                JSVGCanvas.this.toolTipMap.remove(element);
            }
            if (JSVGCanvas.this.lastTarget == element) {
                EventQueue.invokeLater(new ToolTipRunnable(null));
            }
        }

        public void displayError(String string) {
            if (JSVGCanvas.this.svgUserAgent != null) {
                super.displayError(string);
            } else {
                JOptionPane jOptionPane = new JOptionPane(string, 0);
                JDialog jDialog = jOptionPane.createDialog(JSVGCanvas.this, "ERROR");
                jDialog.setModal(false);
                jDialog.setVisible(true);
            }
        }

        public void displayError(Exception exception) {
            if (JSVGCanvas.this.svgUserAgent != null) {
                super.displayError(exception);
            } else {
                JErrorPane jErrorPane = new JErrorPane((Throwable)exception, 0);
                JDialog jDialog = jErrorPane.createDialog((Component)JSVGCanvas.this, "ERROR");
                jDialog.setModal(false);
                jDialog.setVisible(true);
            }
        }

        static /* synthetic */ JSVGCanvas access$200(CanvasUserAgent canvasUserAgent) {
            return canvasUserAgent.JSVGCanvas.this;
        }
    }

    public class ScrollDownAction
    extends ScrollAction {
        public ScrollDownAction(int n) {
            super(0.0, -n);
        }
    }

    public class ScrollUpAction
    extends ScrollAction {
        public ScrollUpAction(int n) {
            super(0.0, n);
        }
    }

    public class ScrollLeftAction
    extends ScrollAction {
        public ScrollLeftAction(int n) {
            super(n, 0.0);
        }
    }

    public class ScrollRightAction
    extends ScrollAction {
        public ScrollRightAction(int n) {
            super(-n, 0.0);
        }
    }

    public class ScrollAction
    extends AffineAction {
        public ScrollAction(double d, double d2) {
            super(AffineTransform.getTranslateInstance(d, d2));
        }
    }

    public class RotateAction
    extends AffineAction {
        public RotateAction(double d) {
            super(AffineTransform.getRotateInstance(d));
        }
    }

    public class ZoomOutAction
    extends ZoomAction {
        ZoomOutAction() {
            super(0.5);
        }
    }

    public class ZoomInAction
    extends ZoomAction {
        ZoomInAction() {
            super(2.0);
        }
    }

    public class ZoomAction
    extends AffineAction {
        public ZoomAction(double d) {
            super(AffineTransform.getScaleInstance(d, d));
        }

        public ZoomAction(double d, double d2) {
            super(AffineTransform.getScaleInstance(d, d2));
        }
    }

    public class AffineAction
    extends AbstractAction {
        AffineTransform at;

        public AffineAction(AffineTransform affineTransform) {
            this.at = affineTransform;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGCanvas.this.gvtRoot == null) {
                return;
            }
            AffineTransform affineTransform = JSVGCanvas.this.getRenderingTransform();
            if (this.at != null) {
                Dimension dimension = JSVGCanvas.this.getSize();
                int n = dimension.width / 2;
                int n2 = dimension.height / 2;
                AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(n, n2);
                affineTransform2.concatenate(this.at);
                affineTransform2.translate(-n, -n2);
                affineTransform2.concatenate(affineTransform);
                JSVGCanvas.this.setRenderingTransform(affineTransform2);
            }
        }
    }

    public class ResetTransformAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGCanvas.this.fragmentIdentifier = null;
            JSVGCanvas.this.resetRenderingTransform();
        }
    }

    protected class CanvasSVGListener
    extends JSVGComponent.ExtendedSVGListener {
        protected CanvasSVGListener() {
            super(JSVGCanvas.this);
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            super.documentLoadingStarted(sVGDocumentLoaderEvent);
            JSVGCanvas.this.setToolTipText(null);
        }
    }
}

