/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.batik.apps.rasterizer.SVGConverterSource;

public class SVGConverterFileSource
implements SVGConverterSource {
    File file;
    String ref;

    public SVGConverterFileSource(File file) {
        this.file = file;
    }

    public SVGConverterFileSource(File file, String ref) {
        this.file = file;
        this.ref = ref;
    }

    public String getName() {
        String name = this.file.getName();
        if (this.ref != null && !"".equals(this.ref)) {
            name = name + '#' + this.ref;
        }
        return name;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.getName();
    }

    public String getURI() {
        try {
            String uri = this.file.toURL().toString();
            if (this.ref != null && !"".equals(this.ref)) {
                uri = uri + '#' + this.ref;
            }
            return uri;
        }
        catch (MalformedURLException e) {
            throw new Error(e.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SVGConverterFileSource)) {
            return false;
        }
        return this.file.equals(((SVGConverterFileSource)o).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public InputStream openStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public boolean isSameAs(String srcStr) {
        return this.file.toString().equals(srcStr);
    }

    public boolean isReadable() {
        return this.file.canRead();
    }
}

