/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.util.Locale;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;

public class XJavac
extends Javac {
    public void execute() throws BuildException {
        if (this.isJDK14OrHigher()) {
            Properties properties = null;
            try {
                properties = System.getProperties();
            }
            catch (Exception exception) {
                throw new BuildException("unable to determine java vendor because could not access system properties!");
            }
            String string = ((String)properties.get("java.vendor")).toUpperCase(Locale.ENGLISH);
            if (string.indexOf("IBM") >= 0) {
                this.setBootclasspath(this.createIBMJDKBootclasspath());
            } else if (string.indexOf("SUN") >= 0 || string.indexOf("ORACLE") >= 0 || string.indexOf("BLACKDOWN") >= 0 || string.indexOf("APPLE") >= 0 || string.indexOf("HEWLETT-PACKARD") >= 0 || string.indexOf("KAFFE") >= 0 || string.indexOf("SABLE") >= 0 || string.indexOf("FREEBSD") >= 0) {
                Path path = this.createBootclasspath();
                Path path2 = this.getClasspath();
                path.append(path2);
                String string2 = (String)properties.get("sun.boot.class.path");
                Path path3 = new Path(null);
                path3.createPathElement().setPath(string2);
                path.append(path3);
                this.setBootclasspath(path);
            }
        }
        super.execute();
    }

    private Path createIBMJDKBootclasspath() {
        Path path = this.createBootclasspath();
        String string = System.getProperty("java.home");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append("/bin/default/jclSC170/vm.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/ppc/default/jclSC170/vm.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/charsets.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/core.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/math.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/vm.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/java.util.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/rt.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/graphics.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/javaws.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/jaws.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/security.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/server.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/ext/JawBridge.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/ext/gskikm.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/ext/ibmjceprovider.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/ext/indicim.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/ext/jaccess.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/ext/ldapsec.jar:");
        path.createPathElement().setPath(stringBuffer.toString());
        stringBuffer.replace(string.length(), stringBuffer.length(), "/lib/ext/oldcertpath.jar");
        path.createPathElement().setPath(stringBuffer.toString());
        return path;
    }

    private boolean isJDK14OrHigher() {
        String string = JavaEnvUtils.getJavaVersion();
        return string.equals("1.4") || !string.equals("1.3") && !string.equals("1.2") && !string.equals("1.1") && !string.equals("1.0");
    }
}

