/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.core.request.ClientInfo;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClientInfo
extends ClientInfo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WebClientInfo.class);
    private final String userAgent;
    private final ClientProperties properties;

    public WebClientInfo(RequestCycle requestCycle) {
        this(requestCycle, new ClientProperties());
    }

    public WebClientInfo(RequestCycle requestCycle, ClientProperties properties) {
        this(requestCycle, ((ServletWebRequest)requestCycle.getRequest()).getContainerRequest().getHeader("User-Agent"), properties);
    }

    public WebClientInfo(RequestCycle requestCycle, String userAgent) {
        this(requestCycle, userAgent, new ClientProperties());
    }

    public WebClientInfo(RequestCycle requestCycle, String userAgent, ClientProperties properties) {
        this.userAgent = userAgent;
        this.properties = properties;
        properties.setRemoteAddress(this.getRemoteAddr(requestCycle));
    }

    public final ClientProperties getProperties() {
        return this.properties;
    }

    public final String getUserAgent() {
        return this.userAgent;
    }

    private String getUserAgentStringLc() {
        return this.getUserAgent() != null ? this.getUserAgent().toLowerCase(Locale.ROOT) : "";
    }

    protected String getRemoteAddr(RequestCycle requestCycle) {
        ServletWebRequest request = (ServletWebRequest)requestCycle.getRequest();
        HttpServletRequest req = request.getContainerRequest();
        String remoteAddr = request.getHeader("X-Forwarded-For");
        if (remoteAddr != null) {
            if (remoteAddr.contains(",")) {
                remoteAddr = Strings.split((String)remoteAddr, (char)',')[0].trim();
            }
            try {
                InetAddress.getByName(remoteAddr);
            }
            catch (UnknownHostException e) {
                remoteAddr = req.getRemoteAddr();
            }
        } else {
            remoteAddr = req.getRemoteAddr();
        }
        return remoteAddr;
    }
}

