/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.protocol.http.OriginResourceIsolationPolicy;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="9.1.0")
public class CsrfPreventionRequestCycleListener
extends OriginResourceIsolationPolicy
implements IRequestCycleListener {
    private static final Logger log = LoggerFactory.getLogger(CsrfPreventionRequestCycleListener.class);
    private CsrfAction noOriginAction = CsrfAction.ABORT;
    private CsrfAction conflictingOriginAction = CsrfAction.ABORT;
    private int errorCode = 400;
    private String errorMessage = "Origin does not correspond to request";

    @Override
    public CsrfPreventionRequestCycleListener addAcceptedOrigin(String acceptedOrigin) {
        super.addAcceptedOrigin(acceptedOrigin);
        return this;
    }

    public CsrfPreventionRequestCycleListener setNoOriginAction(CsrfAction action) {
        this.noOriginAction = action;
        return this;
    }

    public CsrfPreventionRequestCycleListener setConflictingOriginAction(CsrfAction action) {
        this.conflictingOriginAction = action;
        return this;
    }

    public CsrfPreventionRequestCycleListener setErrorCode(int errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public CsrfPreventionRequestCycleListener setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Override
    public void onBeginRequest(RequestCycle cycle) {
        if (log.isDebugEnabled()) {
            HttpServletRequest containerRequest = (HttpServletRequest)cycle.getRequest().getContainerRequest();
            log.debug("Request Source URI: {}", (Object)this.getSourceUri(containerRequest));
        }
    }

    protected boolean isEnabled() {
        return true;
    }

    protected boolean isChecked(IRequestablePage targetedPage) {
        return true;
    }

    protected boolean isChecked(IRequestHandler handler) {
        return handler instanceof IPageRequestHandler && !(handler instanceof RenderPageRequestHandler);
    }

    protected IRequestHandler unwrap(IRequestHandler handler) {
        while (handler instanceof IRequestHandlerDelegate) {
            handler = ((IRequestHandlerDelegate)handler).getDelegateHandler();
        }
        return handler;
    }

    @Override
    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        if (!this.isEnabled()) {
            log.trace("CSRF listener is disabled, no checks performed");
            return;
        }
        if (this.isChecked(handler = this.unwrap(handler))) {
            IPageRequestHandler prh = (IPageRequestHandler)handler;
            IRequestablePage targetedPage = prh.getPage();
            HttpServletRequest containerRequest = (HttpServletRequest)cycle.getRequest().getContainerRequest();
            String sourceUri = this.getSourceUri(containerRequest);
            if (this.isChecked(targetedPage)) {
                this.checkRequest(containerRequest, sourceUri, targetedPage);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Targeted page {} was opted out of the CSRF origin checks, allowed", (Object)targetedPage.getClass().getName());
                }
                this.allowHandler(containerRequest, sourceUri, targetedPage);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Resolved handler {} doesn't target an action on a page, no CSRF check performed", (Object)handler.getClass().getName());
        }
    }

    protected String getSourceUri(HttpServletRequest containerRequest) {
        String sourceUri = containerRequest.getHeader("Origin");
        if (Strings.isEmpty((CharSequence)sourceUri)) {
            sourceUri = containerRequest.getHeader("Referer");
        }
        return this.normalizeUri(sourceUri);
    }

    protected void checkRequest(HttpServletRequest request, String sourceUri, IRequestablePage page) {
        if (sourceUri == null || sourceUri.isEmpty()) {
            log.debug("Source URI not present in request, {}", (Object)this.noOriginAction);
            switch (this.noOriginAction) {
                case ALLOW: {
                    this.allowHandler(request, sourceUri, page);
                    break;
                }
                case SUPPRESS: {
                    this.suppressHandler(request, sourceUri, page);
                    break;
                }
                case ABORT: {
                    this.abortHandler(request, sourceUri, page);
                }
            }
            return;
        }
        if (this.isWhitelistedHost(sourceUri = sourceUri.toLowerCase(Locale.ROOT))) {
            this.whitelistedHandler(request, sourceUri, page);
            return;
        }
        if (!this.isLocalOrigin(request, sourceUri)) {
            log.debug("Source URI conflicts with request origin, {}", (Object)this.conflictingOriginAction);
            switch (this.conflictingOriginAction) {
                case ALLOW: {
                    this.allowHandler(request, sourceUri, page);
                    break;
                }
                case SUPPRESS: {
                    this.suppressHandler(request, sourceUri, page);
                    break;
                }
                case ABORT: {
                    this.abortHandler(request, sourceUri, page);
                }
            }
        } else {
            this.matchingOrigin(request, sourceUri, page);
        }
    }

    protected void whitelistedHandler(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onWhitelisted(request, origin, page);
        if (log.isDebugEnabled()) {
            log.debug("CSRF Origin {} was whitelisted, allowed for page {}", (Object)origin, (Object)page.getClass().getName());
        }
    }

    protected void onWhitelisted(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    protected void matchingOrigin(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onMatchingOrigin(request, origin, page);
        if (log.isDebugEnabled()) {
            log.debug("CSRF Origin {} matched requested resource, allowed for page {}", (Object)origin, (Object)page.getClass().getName());
        }
    }

    protected void onMatchingOrigin(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    protected void allowHandler(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onAllowed(request, origin, page);
        log.info("Possible CSRF attack, request URL: {}, Origin: {}, action: allowed", (Object)request.getRequestURL(), (Object)origin);
    }

    protected void onAllowed(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    protected void suppressHandler(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onSuppressed(request, origin, page);
        log.info("Possible CSRF attack, request URL: {}, Origin: {}, action: suppressed", (Object)request.getRequestURL(), (Object)origin);
        throw new RestartResponseException(page);
    }

    protected void onSuppressed(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    protected void abortHandler(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onAborted(request, origin, page);
        log.info("Possible CSRF attack, request URL: {}, Origin: {}, action: aborted with error {} {}", new Object[]{request.getRequestURL(), origin, this.errorCode, this.errorMessage});
        throw new AbortWithHttpErrorCodeException(this.errorCode, this.errorMessage);
    }

    protected void onAborted(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    public static enum CsrfAction {
        ABORT{

            public String toString() {
                return "aborted";
            }
        }
        ,
        SUPPRESS{

            public String toString() {
                return "suppressed";
            }
        }
        ,
        ALLOW{

            public String toString() {
                return "allowed";
            }
        };

    }
}

