/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Session;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.request.cycle.RequestCycle;

public class DefaultPageContext
implements IPageContext {
    @Override
    public String getSessionId(boolean bind) {
        Session session = Session.get();
        if (bind) {
            session.bind();
        }
        return session.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Serializable> T getSessionAttribute(String key, Supplier<T> defaultValue) {
        Session session;
        Session session2 = session = Session.get();
        synchronized (session2) {
            Serializable value = session.getAttribute(key);
            if (value == null && (value = (Serializable)defaultValue.get()) != null) {
                session.bind();
                session.setAttribute(key, value);
            }
            return (T)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Serializable> T getSessionData(MetaDataKey<T> key, Supplier<T> defaultValue) {
        Session session;
        Session session2 = session = Session.get();
        synchronized (session2) {
            Object value = session.getMetaData((MetaDataKey)key);
            if (value != null) {
                return (T)value;
            }
            value = (Serializable)defaultValue.get();
            if (value != null) {
                session.bind();
                session.setMetaData(key, value);
            }
            return (T)value;
        }
    }

    @Override
    public <T> T getRequestData(MetaDataKey<T> key, Supplier<T> defaultValue) {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            throw new IllegalStateException("Not a request thread.");
        }
        T value = requestCycle.getMetaData(key);
        if (value == null && (value = defaultValue.get()) != null) {
            requestCycle.setMetaData((MetaDataKey)key, (Object)value);
        }
        return value;
    }
}

