/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

public class Button
extends FormComponent<String>
implements IFormSubmittingComponent {
    private static final long serialVersionUID = 1L;
    private boolean defaultFormProcessing = true;

    public Button(String id) {
        this(id, (IModel<String>)null);
    }

    public Button(String id, IModel<String> model) {
        super(id, model);
        this.setVersioned(true);
        this.setOutputMarkupId(true);
        this.setEscapeModelStrings(false);
    }

    protected IModel<String> initModel() {
        return null;
    }

    @Override
    public Form<?> getForm() {
        return Form.findForm(this);
    }

    @Override
    public final boolean getDefaultFormProcessing() {
        return this.defaultFormProcessing;
    }

    @Override
    public final Button setDefaultFormProcessing(boolean defaultFormProcessing) {
        if (this.defaultFormProcessing != defaultFormProcessing) {
            this.addStateChange();
        }
        this.defaultFormProcessing = defaultFormProcessing;
        return this;
    }

    @Override
    public void updateModel() {
    }

    protected String getOnClickScript() {
        return null;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        String value;
        super.onComponentTag(tag);
        if ("input".equals(tag.getName()) && !Strings.isEmpty((CharSequence)(value = this.getDefaultModelObjectAsString()))) {
            tag.put("value", value);
        }
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String onClickJavaScript = this.getOnClickScript();
        if (onClickJavaScript != null) {
            response.render(OnEventHeaderItem.forComponent(this, "click", onClickJavaScript));
        }
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        String modelObjectAsString;
        if ("button".equals(openTag.getName()) && !Strings.isEmpty((CharSequence)(modelObjectAsString = this.getDefaultModelObjectAsString()))) {
            this.replaceComponentTagBody(markupStream, openTag, modelObjectAsString);
            return;
        }
        super.onComponentTagBody(markupStream, openTag);
    }

    @Override
    public void onError() {
    }

    @Override
    public void onSubmit() {
    }

    @Override
    public void onAfterSubmit() {
    }
}

