/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.wicket.markup.head.AbstractCssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IReferenceHeaderItem;
import org.apache.wicket.markup.html.CrossOrigin;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.IResourceBundle;
import org.apache.wicket.util.string.Strings;

public class CssReferenceHeaderItem
extends AbstractCssReferenceHeaderItem
implements IReferenceHeaderItem {
    private static final long serialVersionUID = 1L;
    private final ResourceReference reference;
    private final PageParameters pageParameters;

    public CssReferenceHeaderItem(ResourceReference reference, PageParameters pageParameters, String media) {
        super(media, null);
        this.reference = reference;
        this.pageParameters = pageParameters;
    }

    public CssReferenceHeaderItem(ResourceReference reference, PageParameters pageParameters, String media, String rel) {
        super(media, rel);
        this.reference = reference;
        this.pageParameters = pageParameters;
    }

    @Override
    public ResourceReference getReference() {
        return this.reference;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    @Override
    public CrossOrigin getCrossOrigin() {
        return null;
    }

    @Override
    public String getIntegrity() {
        return null;
    }

    @Override
    public List<HeaderItem> getDependencies() {
        return this.getReference().getDependencies();
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        if (this.getReference() instanceof IResourceBundle) {
            return ((IResourceBundle)((Object)this.getReference())).getProvidedResources();
        }
        return super.getProvidedResources();
    }

    @Override
    public void render(Response response) {
        this.internalRenderCSSReference(response, this.getUrl());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Arrays.asList("css-" + Strings.stripJSessionId((String)this.getUrl()) + "-" + this.getMedia());
    }

    public String toString() {
        return "CSSReferenceHeaderItem(" + this.getReference() + ", " + this.getPageParameters() + ")";
    }

    private String getUrl() {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(this.getReference(), this.getPageParameters());
        return RequestCycle.get().urlFor(handler).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reference, this.getMedia(), this.pageParameters, this.getRel());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssReferenceHeaderItem that = (CssReferenceHeaderItem)o;
        return Objects.equals(this.reference, that.reference) && Objects.equals(this.getMedia(), that.getMedia()) && Objects.equals(this.getRel(), that.getRel()) && Objects.equals(this.pageParameters, that.pageParameters);
    }
}

