/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.crypt;

import java.security.Provider;
import java.security.Security;
import java.util.UUID;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Session;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.crypt.SunJceCrypt;
import org.apache.wicket.util.lang.Args;

public class KeyInSessionSunJceCryptFactory
implements ICryptFactory {
    private static final MetaDataKey<String> KEY = new MetaDataKey<String>(){
        private static final long serialVersionUID = 1L;
    };
    private final String cryptMethod;

    public KeyInSessionSunJceCryptFactory() {
        this("PBEWithMD5AndDES");
    }

    public KeyInSessionSunJceCryptFactory(String cryptMethod) {
        this.cryptMethod = (String)Args.notNull((Object)cryptMethod, (String)"Crypt method");
        Provider[] providers = Security.getProviders("Cipher." + cryptMethod);
        if (providers == null || providers.length == 0) {
            try {
                Class<?> clazz = Class.forName("com.sun.crypto.provider.SunJCE");
                Provider provider = (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Security.addProvider(provider);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to load SunJCE service provider", ex);
            }
        }
    }

    public ICrypt newCrypt() {
        Session session = Session.get();
        session.bind();
        Object key = (String)session.getMetaData((MetaDataKey)KEY);
        if (key == null) {
            key = session.getId() + "." + UUID.randomUUID().toString();
            session.setMetaData(KEY, key);
        }
        ICrypt crypt = this.createCrypt();
        crypt.setKey((String)key);
        return crypt;
    }

    protected ICrypt createCrypt() {
        return new SunJceCrypt(this.cryptMethod);
    }
}

