/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler.logger;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPageAndComponentProvider;
import org.apache.wicket.core.request.handler.logger.PageLogData;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.request.component.IRequestableComponent;

public class ListenerLogData
extends PageLogData {
    private static final long serialVersionUID = 1L;
    private final Class<? extends IRequestableComponent> componentClass;
    private final String componentPath;
    private final Integer behaviorIndex;
    private Class<? extends Behavior> behaviorClass;
    private Class<? extends IRequestableComponent> submittingComponentClass;
    private String submittingComponentPath;

    public ListenerLogData(IPageAndComponentProvider pageAndComponentProvider, Integer behaviorIndex) {
        super(pageAndComponentProvider);
        Component formSubmitter;
        this.componentClass = ListenerLogData.tryToGetComponentClass(pageAndComponentProvider);
        this.componentPath = ListenerLogData.tryToGetComponentPath(pageAndComponentProvider);
        this.behaviorIndex = behaviorIndex;
        if (behaviorIndex != null && this.componentClass != null) {
            try {
                this.behaviorClass = pageAndComponentProvider.getComponent().getBehaviorById(behaviorIndex).getClass();
            }
            catch (Exception ignore) {
                this.behaviorClass = null;
            }
        } else {
            this.behaviorClass = null;
        }
        if ((formSubmitter = ListenerLogData.tryToGetFormSubmittingComponent(pageAndComponentProvider)) != null) {
            this.submittingComponentClass = formSubmitter.getClass();
            this.submittingComponentPath = formSubmitter.getPageRelativePath();
        }
    }

    private static Class<? extends IRequestableComponent> tryToGetComponentClass(IPageAndComponentProvider pageAndComponentProvider) {
        try {
            return pageAndComponentProvider.getComponent().getClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String tryToGetComponentPath(IPageAndComponentProvider pageAndComponentProvider) {
        try {
            return pageAndComponentProvider.getComponentPath();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Component tryToGetFormSubmittingComponent(IPageAndComponentProvider pageAndComponentProvider) {
        try {
            IRequestableComponent component = pageAndComponentProvider.getComponent();
            if (component instanceof Form) {
                IFormSubmittingComponent submitter = ((Form)component).findSubmitter();
                return submitter instanceof Component ? (Component)((Object)submitter) : null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final Class<? extends IRequestableComponent> getComponentClass() {
        return this.componentClass;
    }

    public final String getComponentPath() {
        return this.componentPath;
    }

    public final Integer getBehaviorIndex() {
        return this.behaviorIndex;
    }

    public final Class<? extends Behavior> getBehaviorClass() {
        return this.behaviorClass;
    }

    public Class<? extends IRequestableComponent> getSubmittingComponentClass() {
        return this.submittingComponentClass;
    }

    public String getSubmittingComponentPath() {
        return this.submittingComponentPath;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.setCharAt(sb.length() - 1, ',');
        if (this.getComponentClass() != null) {
            sb.append("componentClass=");
            sb.append(this.getComponentClass().getName());
            sb.append(',');
        }
        if (this.getComponentPath() != null) {
            sb.append("componentPath=");
            sb.append(this.getComponentPath());
            sb.append(',');
        }
        sb.append("behaviorIndex=");
        sb.append(this.getBehaviorIndex());
        if (this.getBehaviorClass() != null) {
            sb.append(",behaviorClass=");
            sb.append(this.getBehaviorClass().getName());
        }
        if (this.getSubmittingComponentClass() != null) {
            sb.append(",submittingComponentClass=");
            sb.append(this.getSubmittingComponentClass().getName());
        }
        if (this.getSubmittingComponentPath() != null) {
            sb.append(",submittingComponentPath=");
            sb.append(this.getSubmittingComponentPath());
        }
        sb.append("}");
        return sb.toString();
    }
}

