/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.protocol.ws.javax.app;

import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.HttpsMapper;
import org.apache.wicket.protocol.ws.javax.app.charts.ChartWebSocketResource;
import org.apache.wicket.protocol.ws.WebSocketSettings;

/**
 * Application object for your web application. If you want to run this application without deploying, run the Start class.
 * 
 * @see org.apache.wicket.protocol.ws.javax.Start#main(String[])
 */
public class JSR356Application extends WebApplication
{    	
	/**
	 * @see org.apache.wicket.Application#getHomePage()
	 */
	@Override
	public Class<HomePage> getHomePage()
	{
		return HomePage.class;
	}

	/**
	 * @see org.apache.wicket.Application#init()
	 */
	@Override
	public void init()
	{
		super.init();

		mountPage("/behavior", WebSocketBehaviorDemoPage.class);
		mountPage("/resource", WebSocketResourceDemoPage.class);

		setRootRequestMapper(new HttpsMapper(getRootRequestMapper(), new HttpsConfig()));

		getSharedResources().add(ChartWebSocketResource.NAME, new ChartWebSocketResource());

		if (System.getenv("OPENSHIFT_APP_NAME") != null)
		{
			// OpenShift uses special proxy for WebSocket connections
			// https://blog.openshift.com/paas-websockets/
			final WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get(this);
			webSocketSettings.setPort(8000);
			webSocketSettings.setSecurePort(8443);
		}
	}
}
