/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.example;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.util.introspection.Info;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class EventExample
extends MarkerIgnoringBase
implements ReferenceInsertionEventHandler,
MethodExceptionEventHandler {
    private boolean logOutput = false;
    private boolean exceptionSwitch = false;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;

    public static void main(String[] args) {
        EventExample ee = new EventExample();
    }

    public EventExample() {
        try {
            Velocity.setProperty((String)"runtime.log.instance", (Object)((Object)this));
            Velocity.init();
        }
        catch (Exception e) {
            System.out.println("Problem initializing Velocity : " + e);
            return;
        }
        VelocityContext context = new VelocityContext();
        context.put("name", (Object)"Velocity");
        EventCartridge ec = new EventCartridge();
        ec.addEventHandler((EventHandler)this);
        ec.attachToContext((Context)context);
        try {
            System.out.println("");
            System.out.println("Velocity Event Handling Demo");
            System.out.println("============================");
            System.out.println("");
            String s = "The word 'Velocity' should be bounded by emoticons :  $name.";
            StringWriter w = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)w, (String)"mystring", (String)s);
            System.out.println("Reference Insertion Test : ");
            System.out.println("   " + w.toString());
            System.out.println("");
            s = "There is no reference $floobie, $nullvalue or anything in the brackets : >$!silentnull<";
            w = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)w, (String)"mystring", (String)s);
            System.out.println("Reference Insertion Test with null references : ");
            System.out.println("   " + w.toString());
            System.out.println("");
            this.logOutput = true;
            s = "#set($settest = $NotAReference)";
            w = new StringWriter();
            System.out.println("NullSetEventHandler test : ");
            System.out.print("      There should be nothing between >");
            Velocity.evaluate((Context)context, (Writer)w, (String)"mystring", (String)s);
            System.out.println("< the brackets.");
            System.out.println("");
            s = "#set($logthis = $NotAReference)";
            w = new StringWriter();
            System.out.println("NullSetEventHandler test : ");
            System.out.print("     There should be a log message between >");
            Velocity.evaluate((Context)context, (Writer)w, (String)"mystring", (String)s);
            System.out.println("< the brackets.");
            System.out.println("");
            this.logOutput = false;
            this.exceptionSwitch = true;
            context.put("this", (Object)this);
            s = " $this.throwException()";
            w = new StringWriter();
            System.out.println("MethodExceptionEventHandler test : ");
            System.out.print("    This exception will be controlled and converted into a string : ");
            Velocity.evaluate((Context)context, (Writer)w, (String)"mystring", (String)s);
            System.out.println("   " + w.toString());
            System.out.println("");
            this.exceptionSwitch = false;
            s = " $this.throwException()";
            w = new StringWriter();
            System.out.println("MethodExceptionEventHandler test : ");
            System.out.println("    This exception will NOT be controlled.  The next thing you should see is the catch() output ");
            Velocity.evaluate((Context)context, (Writer)w, (String)"mystring", (String)s);
            System.out.println("If you see this, it didn't work!");
        }
        catch (ParseErrorException pee) {
            System.out.println("ParseErrorException : " + (Object)((Object)pee));
        }
        catch (MethodInvocationException mee) {
            System.out.println("   Catch Block : MethodInvocationException : " + (Object)((Object)mee));
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
        }
    }

    public void throwException() throws Exception {
        throw new Exception("Hello from throwException()");
    }

    public Object referenceInsert(Context context, String reference, Object value) {
        String s = null;
        if (value != null) {
            s = " ;) " + value.toString() + " :-)";
        } else if (reference.equals("floobie")) {
            s = "<no floobie value>";
        }
        return s;
    }

    public boolean shouldLogOnNullSet(String lhs, String rhs) {
        return !lhs.equals("$settest");
    }

    public Object methodException(Context context, Class claz, String method, Exception e, Info info) {
        if (this.exceptionSwitch && method.equals("throwException")) {
            return "Hello from the methodException() event handler method.";
        }
        throw new RuntimeException(e);
    }

    public void log(int level, String message) {
        if (this.logOutput) {
            System.out.println("level : " + level + " msg : " + message);
        }
    }

    public void log(int level, String message, Throwable t) {
        if (this.logOutput) {
            System.out.println("level : " + level + " msg : " + message + " t : " + t.getMessage());
        }
    }

    public void formatAndLog(int level, String format, Object ... arguments) {
        if (this.logOutput) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.log(level, tp.getMessage());
        }
    }

    public boolean isLevelEnabled(int level) {
        return true;
    }

    public String getName() {
        return "EventExample";
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public void trace(String msg) {
        this.log(1, msg);
    }

    public void trace(String format, Object param1) {
        this.formatAndLog(1, format, param1);
    }

    public void trace(String format, Object param1, Object param2) {
        this.formatAndLog(1, format, param1, param2);
    }

    public void trace(String format, Object ... argArray) {
        this.formatAndLog(1, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(1, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public void debug(String msg) {
        this.log(2, msg);
    }

    public void debug(String format, Object param1) {
        this.formatAndLog(2, format, param1);
    }

    public void debug(String format, Object param1, Object param2) {
        this.formatAndLog(2, format, param1, param2);
    }

    public void debug(String format, Object ... argArray) {
        this.formatAndLog(2, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.log(2, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public void info(String msg) {
        this.log(3, msg);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(3, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(3, format, arg1, arg2);
    }

    public void info(String format, Object ... argArray) {
        this.formatAndLog(3, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.log(3, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    public void warn(String msg) {
        this.log(4, msg);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(4, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(4, format, arg1, arg2);
    }

    public void warn(String format, Object ... argArray) {
        this.formatAndLog(4, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.log(4, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public void error(String msg) {
        this.log(5, msg);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(5, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(5, format, arg1, arg2);
    }

    public void error(String format, Object ... argArray) {
        this.formatAndLog(5, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(5, msg, t);
    }
}

