/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.example;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.util.introspection.Info;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class EventExample
extends MarkerIgnoringBase
implements ReferenceInsertionEventHandler,
MethodExceptionEventHandler {
    private boolean logOutput = false;
    private boolean exceptionSwitch = false;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;

    public static void main(String[] stringArray) {
        EventExample eventExample = new EventExample();
    }

    public EventExample() {
        try {
            Velocity.setProperty((String)"runtime.log.instance", (Object)((Object)this));
            Velocity.init();
        }
        catch (Exception exception) {
            System.out.println("Problem initializing Velocity : " + exception);
            return;
        }
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("name", (Object)"Velocity");
        EventCartridge eventCartridge = new EventCartridge();
        eventCartridge.addEventHandler((EventHandler)this);
        eventCartridge.attachToContext((Context)velocityContext);
        try {
            System.out.println("");
            System.out.println("Velocity Event Handling Demo");
            System.out.println("============================");
            System.out.println("");
            String string = "The word 'Velocity' should be bounded by emoticons :  $name.";
            StringWriter stringWriter = new StringWriter();
            Velocity.evaluate((Context)velocityContext, (Writer)stringWriter, (String)"mystring", (String)string);
            System.out.println("Reference Insertion Test : ");
            System.out.println("   " + stringWriter.toString());
            System.out.println("");
            string = "There is no reference $floobie, $nullvalue or anything in the brackets : >$!silentnull<";
            stringWriter = new StringWriter();
            Velocity.evaluate((Context)velocityContext, (Writer)stringWriter, (String)"mystring", (String)string);
            System.out.println("Reference Insertion Test with null references : ");
            System.out.println("   " + stringWriter.toString());
            System.out.println("");
            this.logOutput = true;
            string = "#set($settest = $NotAReference)";
            stringWriter = new StringWriter();
            System.out.println("NullSetEventHandler test : ");
            System.out.print("      There should be nothing between >");
            Velocity.evaluate((Context)velocityContext, (Writer)stringWriter, (String)"mystring", (String)string);
            System.out.println("< the brackets.");
            System.out.println("");
            string = "#set($logthis = $NotAReference)";
            stringWriter = new StringWriter();
            System.out.println("NullSetEventHandler test : ");
            System.out.print("     There should be a log message between >");
            Velocity.evaluate((Context)velocityContext, (Writer)stringWriter, (String)"mystring", (String)string);
            System.out.println("< the brackets.");
            System.out.println("");
            this.logOutput = false;
            this.exceptionSwitch = true;
            velocityContext.put("this", (Object)this);
            string = " $this.throwException()";
            stringWriter = new StringWriter();
            System.out.println("MethodExceptionEventHandler test : ");
            System.out.print("    This exception will be controlled and converted into a string : ");
            Velocity.evaluate((Context)velocityContext, (Writer)stringWriter, (String)"mystring", (String)string);
            System.out.println("   " + stringWriter.toString());
            System.out.println("");
            this.exceptionSwitch = false;
            string = " $this.throwException()";
            stringWriter = new StringWriter();
            System.out.println("MethodExceptionEventHandler test : ");
            System.out.println("    This exception will NOT be controlled.  The next thing you should see is the catch() output ");
            Velocity.evaluate((Context)velocityContext, (Writer)stringWriter, (String)"mystring", (String)string);
            System.out.println("If you see this, it didn't work!");
        }
        catch (ParseErrorException parseErrorException) {
            System.out.println("ParseErrorException : " + (Object)((Object)parseErrorException));
        }
        catch (MethodInvocationException methodInvocationException) {
            System.out.println("   Catch Block : MethodInvocationException : " + (Object)((Object)methodInvocationException));
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
        }
    }

    public void throwException() throws Exception {
        throw new Exception("Hello from throwException()");
    }

    public Object referenceInsert(Context context, String string, Object object) {
        String string2 = null;
        if (object != null) {
            string2 = " ;) " + object.toString() + " :-)";
        } else if (string.equals("floobie")) {
            string2 = "<no floobie value>";
        }
        return string2;
    }

    public boolean shouldLogOnNullSet(String string, String string2) {
        return !string.equals("$settest");
    }

    public Object methodException(Context context, Class clazz, String string, Exception exception, Info info) {
        if (this.exceptionSwitch && string.equals("throwException")) {
            return "Hello from the methodException() event handler method.";
        }
        throw new RuntimeException(exception);
    }

    public void log(int n, String string) {
        if (this.logOutput) {
            System.out.println("level : " + n + " msg : " + string);
        }
    }

    public void log(int n, String string, Throwable throwable) {
        if (this.logOutput) {
            System.out.println("level : " + n + " msg : " + string + " t : " + throwable.getMessage());
        }
    }

    public void formatAndLog(int n, String string, Object ... objectArray) {
        if (this.logOutput) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)string, (Object[])objectArray);
            this.log(n, formattingTuple.getMessage());
        }
    }

    public boolean isLevelEnabled(int n) {
        return true;
    }

    public String getName() {
        return "EventExample";
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public void trace(String string) {
        this.log(1, string);
    }

    public void trace(String string, Object object) {
        this.formatAndLog(1, string, object);
    }

    public void trace(String string, Object object, Object object2) {
        this.formatAndLog(1, string, object, object2);
    }

    public void trace(String string, Object ... objectArray) {
        this.formatAndLog(1, string, objectArray);
    }

    public void trace(String string, Throwable throwable) {
        this.log(1, string, throwable);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public void debug(String string) {
        this.log(2, string);
    }

    public void debug(String string, Object object) {
        this.formatAndLog(2, string, object);
    }

    public void debug(String string, Object object, Object object2) {
        this.formatAndLog(2, string, object, object2);
    }

    public void debug(String string, Object ... objectArray) {
        this.formatAndLog(2, string, objectArray);
    }

    public void debug(String string, Throwable throwable) {
        this.log(2, string, throwable);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public void info(String string) {
        this.log(3, string);
    }

    public void info(String string, Object object) {
        this.formatAndLog(3, string, object);
    }

    public void info(String string, Object object, Object object2) {
        this.formatAndLog(3, string, object, object2);
    }

    public void info(String string, Object ... objectArray) {
        this.formatAndLog(3, string, objectArray);
    }

    public void info(String string, Throwable throwable) {
        this.log(3, string, throwable);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    public void warn(String string) {
        this.log(4, string);
    }

    public void warn(String string, Object object) {
        this.formatAndLog(4, string, object);
    }

    public void warn(String string, Object object, Object object2) {
        this.formatAndLog(4, string, object, object2);
    }

    public void warn(String string, Object ... objectArray) {
        this.formatAndLog(4, string, objectArray);
    }

    public void warn(String string, Throwable throwable) {
        this.log(4, string, throwable);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public void error(String string) {
        this.log(5, string);
    }

    public void error(String string, Object object) {
        this.formatAndLog(5, string, object);
    }

    public void error(String string, Object object, Object object2) {
        this.formatAndLog(5, string, object, object2);
    }

    public void error(String string, Object ... objectArray) {
        this.formatAndLog(5, string, objectArray);
    }

    public void error(String string, Throwable throwable) {
        this.log(5, string, throwable);
    }
}

