package org.apache.velocity.runtime.parser.node;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Interface used in implementation of visitor pattern.  Based on
 * code autogenerated by JavaCC. Formerly found in package
 * org.apache.velocity.runtime.parser.
 *
 * @version $Id: ParserVisitor.java 1780734 2017-01-28 19:21:08Z cbrisson $
 * @since 1.5
 */
public interface ParserVisitor
{
  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(SimpleNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */

  Object visit(ASTprocess node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTText node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTEscapedDirective node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTEscape node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTComment node, Object data);
  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTTextblock node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTFloatingPointLiteral node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTIntegerLiteral node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTStringLiteral node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTIdentifier node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTWord node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */

  Object visit(ASTDirectiveAssign node, Object data);
  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTDirective node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTBlock node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTMap node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTObjectArray node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTIntegerRange node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTMethod node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTIndex node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTReference node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTTrue node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTFalse node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTIfStatement node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTElseStatement node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTElseIfStatement node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTSetDirective node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTExpression node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTAssignment node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTOrNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTAndNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTEQNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTNENode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTLTNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTGTNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTLENode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTGENode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTAddNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTSubtractNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTMulNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTDivNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTModNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
  Object visit(ASTNotNode node, Object data);

  /**
   * @param node
   * @param data
   * @return The object rendered by this node.
   */
}
