/** \file api.hpp .
-----------------------------------------------------------------------------

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.

-----------------------------------------------------------------------------

   Description:

-------------------------------------------------------------------------- */

#ifndef UIMA_API_HPP
#define UIMA_API_HPP

/* ----------------------------------------------------------------------- */
/*       Include dependencies                                              */
/* ----------------------------------------------------------------------- */

#include "uima/pragmas.hpp"

#include "uima/annotator_context.hpp"
#include "uima/ccsid.hpp"
#include "uima/language.hpp"
#include "uima/log.hpp"
#include "uima/strtools.hpp"
#include "uima/result_specification.hpp"
#include "uima/token_properties.hpp"
#include "uima/timedatetools.hpp"
#include "uima/cas.hpp"
#include "uima/xmltypesystemreader.hpp"
#include "uima/fsindexrepository.hpp"
#include "uima/lowlevel_typesystem.hpp"
#include "uima/lowlevel_fsheap.hpp"
#include "uima/lowlevel_indexrepository.hpp"
#include "uima/fsindex.hpp"
#include "uima/listfs.hpp"
#include "uima/arrayfs.hpp"
#include "uima/unistrref.hpp"
#include "uima/resmgr.hpp"
#include "uima/fsindexrepository.hpp"
#include "uima/msg.h"
#include "uima/config_tools.hpp"
#include "uima/comp_ids.h"                             /* for trace */
#include "uima/annotator_abase.hpp"
#include "uima/engine.hpp"
#include "uima/taespecifierbuilder.hpp"
#include "uima/log.hpp"




/* ----------------------------------------------------------------------- */
#endif /* UIMA_API_HPP */

/* <EOF> */

