/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.impl;

import org.apache.uima.annotator.regex.Feature;
import org.apache.uima.annotator.regex.extension.Normalization;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorConfigException;
import org.apache.uima.cas.Type;
import org.apache.uima.resource.ResourceInitializationException;

public class Feature_impl
implements Feature {
    private final int type;
    private final int normalizationType;
    private final boolean hasNormalizer;
    private final String name;
    private final String value;
    private final String implClass;
    private Normalization normalizer;
    private org.apache.uima.cas.Feature feature;

    public Feature_impl(int type, String name, String value, int normalizationType, String implClass) {
        this.type = type;
        this.name = name;
        this.value = value;
        this.feature = null;
        this.normalizationType = normalizationType;
        this.implClass = implClass;
        this.normalizer = null;
        this.hasNormalizer = this.normalizationType > 0;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public org.apache.uima.cas.Feature getFeature() {
        return this.feature;
    }

    public String normalize(String input, String ruleId) throws Exception {
        if (this.hasNormalizer) {
            if (this.normalizationType == 1) {
                return this.normalizer.normalize(input, ruleId);
            }
            if (this.normalizationType == 2) {
                return input.toLowerCase();
            }
            if (this.normalizationType == 3) {
                return input.toUpperCase();
            }
            if (this.normalizationType == 4) {
                return input.trim();
            }
        }
        return input;
    }

    public void typeInit(Type annotationType) throws ResourceInitializationException {
        this.feature = annotationType.getFeatureByBaseName(this.name);
        if (this.feature == null) {
            throw new ResourceInitializationException("annotator_ex_feature_not_found", new Object[]{Feature_impl.class.getName(), this.name});
        }
    }

    public void initialize() throws RegexAnnotatorConfigException {
        if (this.normalizationType == 1) {
            if (this.implClass == null) {
                throw new RegexAnnotatorConfigException("regex_annotator_error_custom_normalizer_not_specified", new Object[]{this.name});
            }
            try {
                Class<?> normalizerClass = this.getClass().getClassLoader().loadClass(this.implClass);
                Object obj = normalizerClass.newInstance();
                if (!(obj instanceof Normalization)) {
                    throw new RegexAnnotatorConfigException("regex_annotator_error_custom_normalizer_wrong_interface", new Object[]{this.implClass});
                }
                this.normalizer = (Normalization)obj;
            }
            catch (Exception ex) {
                throw new RegexAnnotatorConfigException("regex_annotator_error_creating_custom_normalizer", new Object[]{this.implClass}, ex);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Feature: ");
        buffer.append("\n  Name: ");
        buffer.append(this.name);
        if (this.type == 3) {
            buffer.append("\n  Type: float");
        } else if (this.type == 2) {
            buffer.append("\n  Type: integer");
        } else if (this.type == 1) {
            buffer.append("\n  Type: string");
        } else if (this.type == 4) {
            buffer.append("\n  Type: reference");
        } else if (this.type == 5) {
            buffer.append("\n  Type: confidence");
        } else if (this.type == 6) {
            buffer.append("\n  Type: ruleId");
        }
        buffer.append("\n  Value: ");
        buffer.append(this.value);
        if (this.normalizationType > 0) {
            if (this.normalizationType == 2) {
                buffer.append("\n  Normalization: ToLowerCase");
            } else if (this.normalizationType == 3) {
                buffer.append("\n  Normalization: ToUpperCase");
            } else if (this.normalizationType == 4) {
                buffer.append("\n  Normalization: Trim");
            }
            if (this.normalizationType == 1) {
                buffer.append("\n  Normalization: " + this.implClass);
            }
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

