/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.impl;

import java.util.ArrayList;
import org.apache.uima.annotator.regex.Annotation;
import org.apache.uima.annotator.regex.Feature;
import org.apache.uima.annotator.regex.Position;
import org.apache.uima.annotator.regex.extension.Validation;
import org.apache.uima.annotator.regex.impl.Feature_impl;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorConfigException;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceInitializationException;

public class Annotation_impl
implements Annotation {
    private final String annotationId;
    private final String annotationTypeStr;
    private final Position begin;
    private final Position end;
    private final String validationClass;
    private Validation validator;
    private boolean hasValidator;
    private ArrayList<Feature> features;
    private Type annotationType;

    public Annotation_impl(String annotId, String annotType, Position begin, Position end, String validationClass) {
        this.annotationId = annotId;
        this.annotationTypeStr = annotType;
        this.begin = begin;
        this.end = end;
        this.features = new ArrayList();
        this.validationClass = validationClass;
        this.validator = null;
        this.hasValidator = false;
    }

    public Type getAnnotationType() {
        return this.annotationType;
    }

    public Position getBegin() {
        return this.begin;
    }

    public Position getEnd() {
        return this.end;
    }

    public String getId() {
        return this.annotationId;
    }

    public void addFeature(Feature aFeature) {
        this.features.add(aFeature);
    }

    public Feature[] getFeatures() {
        return this.features.toArray(new Feature[0]);
    }

    public boolean validate(String coveredText, String ruleID) throws Exception {
        if (this.validator != null) {
            return this.validator.validate(coveredText, ruleID);
        }
        return true;
    }

    public boolean hasValidator() {
        return this.hasValidator;
    }

    public void typeInit(TypeSystem ts) throws ResourceInitializationException {
        if (this.annotationTypeStr != null) {
            this.annotationType = ts.getType(this.annotationTypeStr);
            if (this.annotationType == null) {
                throw new RegexAnnotatorConfigException("regex_annotator_error_resolving_types", new Object[]{this.annotationTypeStr});
            }
        }
        Feature[] featureList = this.getFeatures();
        for (int i = 0; i < featureList.length; ++i) {
            ((Feature_impl)featureList[i]).typeInit(this.annotationType);
        }
    }

    public void initialize() throws RegexAnnotatorConfigException {
        Feature[] featureList = this.getFeatures();
        for (int i = 0; i < featureList.length; ++i) {
            ((Feature_impl)featureList[i]).initialize();
        }
        if (this.validationClass != null) {
            try {
                Class<?> validatorClass = this.getClass().getClassLoader().loadClass(this.validationClass);
                Object obj = validatorClass.newInstance();
                if (!(obj instanceof Validation)) {
                    throw new RegexAnnotatorConfigException("regex_annotator_error_custom_validator_wrong_interface", new Object[]{this.validationClass});
                }
                this.validator = (Validation)obj;
                this.hasValidator = true;
            }
            catch (Exception ex) {
                throw new RegexAnnotatorConfigException("regex_annotator_error_creating_custom_validator", new Object[]{this.validationClass}, ex);
            }
        }
    }

    public String toString() {
        Feature[] featureList;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Annotation: ");
        buffer.append("\n  ID: ");
        buffer.append(this.annotationId);
        buffer.append("\n  Type: ");
        buffer.append(this.annotationTypeStr);
        buffer.append("\n  Begin: ");
        buffer.append(this.begin.toString());
        buffer.append("\n  End: ");
        buffer.append(this.end.toString());
        if (this.validationClass != null) {
            buffer.append("\n  Validation class: ");
            buffer.append(this.validationClass);
        }
        if ((featureList = this.getFeatures()).length > 0) {
            buffer.append("\nFeatures: \n");
        }
        for (int i = 0; i < featureList.length; ++i) {
            buffer.append(featureList[i].toString());
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

