/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.extension.impl;

import org.apache.uima.annotator.regex.extension.Validation;

public class ISBNNumberValidator
implements Validation {
    public boolean validate(String coveredText, String ruleID) throws Exception {
        coveredText = coveredText.replaceAll("-", "");
        char[] isbnCharArray = coveredText.toCharArray();
        if (coveredText.length() == 10) {
            int[] isbnDigits = new int[9];
            for (int i = 0; i < 9; ++i) {
                isbnDigits[i] = Character.digit(isbnCharArray[i], 10);
            }
            int checkDigit = 11 - (10 * isbnDigits[0] + 9 * isbnDigits[1] + 8 * isbnDigits[2] + 7 * isbnDigits[3] + 6 * isbnDigits[4] + 5 * isbnDigits[5] + 4 * isbnDigits[6] + 3 * isbnDigits[7] + 2 * isbnDigits[8]) % 11;
            if (checkDigit == 10) {
                if (isbnCharArray[9] == 'X' || isbnCharArray[9] == 'x') {
                    return true;
                }
            } else {
                if (Character.digit(isbnCharArray[9], 10) == checkDigit) {
                    return true;
                }
                if (checkDigit == 11) {
                    return true;
                }
            }
        } else if (coveredText.length() == 13) {
            int[] isbnDigits = new int[12];
            for (int i = 0; i < 12; ++i) {
                isbnDigits[i] = Character.digit(isbnCharArray[i], 10);
            }
            int checkDigit = 10 - (isbnDigits[0] + 3 * isbnDigits[1] + isbnDigits[2] + 3 * isbnDigits[3] + isbnDigits[4] + 3 * isbnDigits[5] + isbnDigits[6] + 3 * isbnDigits[7] + isbnDigits[8] + 3 * isbnDigits[9] + isbnDigits[10] + 3 * isbnDigits[11]) % 10;
            if (checkDigit == 10 ? Character.digit(isbnCharArray[12], 10) == 0 : Character.digit(isbnCharArray[12], 10) == checkDigit) {
                return true;
            }
        }
        return false;
    }
}

