/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.dict_annot.dictionary.impl;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.annotator.dict_annot.dictionary.Dictionary;
import org.apache.uima.annotator.dict_annot.dictionary.DictionaryBuilder;
import org.apache.uima.annotator.dict_annot.dictionary.impl.HashMapDictionary;

public class HashMapDictionaryBuilder
implements DictionaryBuilder {
    private boolean createMultiWordEntries;
    private HashMapDictionary dictionary = new HashMapDictionary(true);
    private String multiWordSeparator = " ";

    public String getMultiWordSeparator() {
        return this.multiWordSeparator;
    }

    public void setDictionaryProperties(String language, String typeName, boolean caseNormalization, boolean multiWordEntries, String multiWordSeparator) {
        if (!caseNormalization) {
            this.dictionary = new HashMapDictionary(caseNormalization);
        }
        this.dictionary.setDictionaryLanguage(language);
        this.dictionary.setTypeName(typeName);
        this.createMultiWordEntries = multiWordEntries;
        if (multiWordSeparator != null) {
            this.multiWordSeparator = multiWordSeparator;
        }
    }

    private String[] multiTokenTokenizer(String input) {
        StringTokenizer tokenizer = new StringTokenizer(input, this.multiWordSeparator);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        String[] multiWord = tokens.toArray(new String[0]);
        return multiWord;
    }

    public void addWord(String word) {
        if (this.createMultiWordEntries) {
            String[] multiWord = this.multiTokenTokenizer(word);
            if (multiWord.length == 1) {
                this.dictionary.addWord(multiWord[0]);
            } else {
                this.dictionary.addMultiWord(multiWord);
            }
        } else {
            this.dictionary.addWord(word);
        }
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }
}

