/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.dict_annot.dictionary.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.uima.annotator.dict_annot.dictionary.Dictionary;
import org.apache.uima.annotator.dict_annot.dictionary.DictionaryMatch;
import org.apache.uima.annotator.dict_annot.dictionary.impl.DictionaryEntry;
import org.apache.uima.annotator.dict_annot.dictionary.impl.DictionaryMatchImpl;
import org.apache.uima.annotator.dict_annot.dictionary.impl.EntryMetaDataImpl;
import org.apache.uima.annotator.dict_annot.dictionary.impl.FeaturePathInfo;
import org.apache.uima.cas.text.AnnotationFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapDictionary
implements Dictionary {
    private HashMap<String, DictionaryEntry> dictionary = new HashMap(100);
    private int idCounter = 0;
    private String language;
    private String typeName;
    private boolean caseNormalization = true;

    public HashMapDictionary(boolean caseNormalization) {
        this.caseNormalization = caseNormalization;
        this.language = null;
        this.typeName = null;
    }

    @Override
    public boolean contains(String word) {
        DictionaryEntry entry = this.dictionary.get(this.normalizeString(word));
        if (entry != null) {
            return entry.isComplete();
        }
        return false;
    }

    @Override
    public boolean contains(String[] multiWord) {
        DictionaryEntry entry = this.containsMultiWord(multiWord);
        if (entry != null) {
            return entry.isComplete();
        }
        return false;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    private DictionaryEntry containsMultiWord(String[] multiWord) {
        HashMap<String, DictionaryEntry> currentMap = this.dictionary;
        DictionaryEntry entry = null;
        for (int i = 0; i < multiWord.length; ++i) {
            entry = currentMap.get(this.normalizeString(multiWord[i]));
            if (entry == null) {
                return null;
            }
            currentMap = entry.getSubBranch();
        }
        return entry;
    }

    @Override
    public DictionaryMatch matchEntry(int pos, AnnotationFS[] annotFSs, FeaturePathInfo featPathInfo) {
        DictionaryMatchImpl match = new DictionaryMatchImpl();
        int offset = 0;
        this.checkMatches(pos, annotFSs, featPathInfo, this.dictionary, match, offset);
        if (match.isValidMatch()) {
            return match;
        }
        return null;
    }

    @Override
    public int getEntryCount() {
        return this.idCounter;
    }

    public int addWord(String word) {
        DictionaryEntry entry = this.dictionary.get(this.normalizeString(word));
        if (entry != null) {
            if (entry.isComplete()) {
                return -1;
            }
            entry.setComplete();
            ++this.idCounter;
            EntryMetaDataImpl metaData = new EntryMetaDataImpl(this.idCounter);
            entry.setEntryMetaData(metaData);
            return this.idCounter;
        }
        ++this.idCounter;
        EntryMetaDataImpl metaData = new EntryMetaDataImpl(this.idCounter);
        this.dictionary.put(this.normalizeString(word), new DictionaryEntry(true, metaData));
        return this.idCounter;
    }

    public int addMultiWord(String[] multiWord) {
        DictionaryEntry entry = this.containsMultiWord(multiWord);
        if (entry != null) {
            if (entry.isComplete()) {
                return -1;
            }
            entry.setComplete();
            ++this.idCounter;
            EntryMetaDataImpl metaData = new EntryMetaDataImpl(this.idCounter);
            entry.setEntryMetaData(metaData);
            return this.idCounter;
        }
        ++this.idCounter;
        EntryMetaDataImpl metaData = new EntryMetaDataImpl(this.idCounter);
        HashMap<String, DictionaryEntry> currentMap = this.dictionary;
        for (int i = 0; i < multiWord.length; ++i) {
            if (currentMap.containsKey(this.normalizeString(multiWord[i]))) {
                currentMap = currentMap.get(this.normalizeString(multiWord[i])).getSubBranch();
                continue;
            }
            entry = i == multiWord.length - 1 ? new DictionaryEntry(true, metaData) : new DictionaryEntry(false, null);
            currentMap.put(this.normalizeString(multiWord[i]), entry);
            currentMap = entry.getSubBranch();
        }
        return this.idCounter;
    }

    public void printDictionary(Writer out) throws IOException {
        this.printBranch(this.dictionary, null, out);
    }

    public void setDictionaryLanguage(String language) {
        this.language = language;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    private void checkMatches(int pos, AnnotationFS[] annotFSs, FeaturePathInfo featPathInfo, HashMap<String, DictionaryEntry> dict, DictionaryMatchImpl match, int offset) {
        String normalizedValue;
        String value = featPathInfo.getValue(annotFSs[pos + offset]);
        if (value != null && dict.containsKey(normalizedValue = this.normalizeString(value))) {
            DictionaryEntry currentEntry = dict.get(normalizedValue);
            match.storeMatch(currentEntry.getEntryMetaData(), currentEntry.isComplete());
            if (annotFSs.length > pos + ++offset) {
                this.checkMatches(pos, annotFSs, featPathInfo, currentEntry.getSubBranch(), match, offset);
            }
        }
    }

    private void printBranch(HashMap<String, DictionaryEntry> map, ArrayList<String> previousTokens, Writer out) throws IOException {
        for (String currentToken : map.keySet()) {
            DictionaryEntry dictEntry = map.get(currentToken);
            if (dictEntry.isComplete()) {
                if (previousTokens != null) {
                    String previous = this.getString(previousTokens);
                    if (out == null) {
                        System.out.println(previous + currentToken);
                    } else {
                        out.write(previous + currentToken);
                        out.write(System.getProperty("line.separator"));
                    }
                } else if (out == null) {
                    System.out.println(currentToken);
                } else {
                    out.write(currentToken);
                    out.write(System.getProperty("line.separator"));
                }
            }
            HashMap<String, DictionaryEntry> subBranch = dictEntry.getSubBranch();
            if (previousTokens == null) {
                previousTokens = new ArrayList();
            }
            previousTokens.add(currentToken);
            this.printBranch(subBranch, previousTokens, out);
            previousTokens.remove(previousTokens.size() - 1);
        }
    }

    private String getString(ArrayList<String> stringList) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < stringList.size(); ++i) {
            buf.append(stringList.get(i));
            buf.append(" ");
        }
        return buf.toString();
    }

    private String normalizeString(String input) {
        if (this.caseNormalization) {
            return input.toLowerCase().trim();
        }
        return input.trim();
    }
}

