/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.dict_annot.dictionary.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.incubator.uima.DictionaryDocument;
import org.apache.incubator.uima.DictionaryMetaDataDocument;
import org.apache.incubator.uima.EntriesDocument;
import org.apache.incubator.uima.EntryDocument;
import org.apache.incubator.uima.TypeCollectionDocument;
import org.apache.uima.annotator.dict_annot.dictionary.Dictionary;
import org.apache.uima.annotator.dict_annot.dictionary.DictionaryBuilder;
import org.apache.uima.annotator.dict_annot.dictionary.DictionaryFileParser;
import org.apache.uima.annotator.dict_annot.impl.DictionaryAnnotatorConfigException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.xmlbeans.XmlOptions;

public class DictionaryFileParserImpl
implements DictionaryFileParser {
    public Dictionary parseDictionaryFile(String dictionaryFilePath, InputStream dictionaryFileStream, DictionaryBuilder dictBuilder) throws ResourceInitializationException {
        DictionaryDocument dictionaryDoc;
        try {
            dictionaryDoc = DictionaryDocument.Factory.parse(dictionaryFileStream);
        }
        catch (Exception ex) {
            throw new DictionaryAnnotatorConfigException("dictionary_annotator_error_parsing_dictionary_file", new Object[]{dictionaryFilePath}, ex);
        }
        ArrayList validationErrors = new ArrayList();
        XmlOptions validationOptions = new XmlOptions();
        validationOptions.setErrorListener(validationErrors);
        boolean isValid = dictionaryDoc.validate(validationOptions);
        if (!isValid) {
            Iterator iter = validationErrors.iterator();
            StringBuffer errorMessages = new StringBuffer();
            while (iter.hasNext()) {
                errorMessages.append("\n>> ");
                errorMessages.append(iter.next());
            }
            throw new DictionaryAnnotatorConfigException("dictionary_annotator_error_xml_validation", new Object[]{dictionaryFilePath, errorMessages.toString()});
        }
        DictionaryDocument.Dictionary dictionary = dictionaryDoc.getDictionary();
        TypeCollectionDocument.TypeCollection typeCollection = dictionary.getTypeCollection();
        DictionaryMetaDataDocument.DictionaryMetaData dictMetaData = typeCollection.getDictionaryMetaData();
        boolean caseNormalization = true;
        boolean multiWordEntries = true;
        String multiWordSeparator = null;
        if (dictMetaData != null) {
            caseNormalization = dictMetaData.getCaseNormalization();
            multiWordEntries = dictMetaData.getMultiWordEntries();
            multiWordSeparator = dictMetaData.getMultiWordSeparator();
        }
        String language = typeCollection.getLanguageId();
        String typeName = typeCollection.getTypeDescription().getTypeName();
        dictBuilder.setDictionaryProperties(language, typeName, caseNormalization, multiWordEntries, multiWordSeparator);
        EntriesDocument.Entries entries = typeCollection.getEntries();
        EntryDocument.Entry[] entryArray = entries.getEntryArray();
        for (int i = 0; i < entryArray.length; ++i) {
            dictBuilder.addWord(entryArray[i].getKey().getStringValue());
        }
        return dictBuilder.getDictionary();
    }
}

