/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tika;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.tika.FeatureValue;
import org.apache.uima.tika.MarkupHandler;
import org.apache.uima.tika.SourceDocumentAnnotation;
import org.xml.sax.ContentHandler;

public class TIKAWrapper {
    private TikaConfig config = null;

    public TIKAWrapper() throws TikaException {
        this.config = TikaConfig.getDefaultConfig();
    }

    public TIKAWrapper(String configLocation) throws TikaException {
        if (configLocation != null) {
            try {
                this.config = new TikaConfig(configLocation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.config == null) {
            this.config = TikaConfig.getDefaultConfig();
        }
    }

    public void populateCASfromURL(CAS cas, URL uri, String language) throws CASException {
        this.populateCASfromURL(cas, uri, null, language);
    }

    public void populateCASfromURL(CAS cas, URL url, String mime, String language) throws CASException {
        int i;
        BufferedInputStream originalStream = null;
        try {
            originalStream = new BufferedInputStream(url.openStream());
        }
        catch (IOException e1) {
            new CASException((Throwable)e1);
        }
        AutoDetectParser parser = null;
        if (mime != null && !mime.equals("")) {
            parser = this.config.getParser(mime);
        }
        if (parser == null) {
            parser = new AutoDetectParser(this.config);
        }
        Metadata md = new Metadata();
        MarkupHandler handler = new MarkupHandler();
        try {
            parser.parse((InputStream)originalStream, (ContentHandler)handler, md);
        }
        catch (Exception e) {
            throw new CASException((Throwable)e);
        }
        finally {
            if (language != null) {
                cas.setDocumentLanguage(language);
            }
            try {
                ((InputStream)originalStream).close();
            }
            catch (IOException e) {}
        }
        handler.populateCAS(cas);
        JCas jcas = cas.getJCas();
        SourceDocumentAnnotation docAnnotation = new SourceDocumentAnnotation(jcas);
        if (docAnnotation.getFeatures() == null) {
            docAnnotation.setFeatures((FSArray)cas.createArrayFS(md.size() + 1));
        }
        for (i = 0; i < md.size(); ++i) {
            String name = md.names()[i];
            String value = md.get(name);
            FeatureValue fv = new FeatureValue(cas.getJCas());
            fv.setName(name);
            fv.setValue(value);
            docAnnotation.setFeatures(i, fv);
        }
        FeatureValue fv = new FeatureValue(jcas);
        fv.setName("url");
        fv.setValue(url.toString());
        docAnnotation.setFeatures(i, fv);
        docAnnotation.addToIndexes();
    }
}

