/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fsvars.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.fsvars.FsVariables;
import org.apache.uima.fsvars.FsVariablesException;

public class FsVariablesImpl
implements FsVariables {
    private static final String messageCatalog = "org.apache.uima.fsvars.messages";
    private CAS cas;
    private FSIndex index;
    private Type fsVariableType;
    private Feature nameFeature;
    private Feature typeFeature;
    private Feature valueFeature;

    public void declareFsVariable(String name, Type type) {
        if (this.isFsVariable(name)) {
            throw new FsVariablesException(messageCatalog, "fsvars_variable_already_defined", new Object[]{name});
        }
        FeatureStructure fs = this.cas.createFS(this.fsVariableType);
        fs.setStringValue(this.nameFeature, name);
        fs.setStringValue(this.typeFeature, type.getName());
        this.cas.addFsToIndexes(fs);
    }

    public Type getFsVariableType(String name) {
        FeatureStructure fs = this.getFsVarForName(name);
        String typeName = fs.getStringValue(this.typeFeature);
        Type type = this.cas.getTypeSystem().getType(typeName);
        if (type == null) {
            throw new FsVariablesException(messageCatalog, "bad_typename_in_fsvar", new Object[]{typeName, name});
        }
        return type;
    }

    public FeatureStructure getVariableValue(String name) {
        FeatureStructure fsvar = this.getFsVarForName(name);
        return fsvar.getFeatureValue(this.valueFeature);
    }

    public boolean isFsVariable(String name) {
        FeatureStructure fs = this.getFsVarNoExc(name);
        return fs != null && fs.getStringValue(this.nameFeature).equals(name);
    }

    public List listFsVariables() {
        ArrayList<String> list = new ArrayList<String>();
        FSIterator it = this.index.iterator();
        while (it.isValid()) {
            list.add(it.get().getStringValue(this.nameFeature));
            it.moveToNext();
        }
        return list;
    }

    public List listFsVariables(Type type) {
        ArrayList<String> list = new ArrayList<String>();
        TypeSystem ts = this.cas.getTypeSystem();
        FSIterator it = this.index.iterator();
        while (it.isValid()) {
            String typeName = it.get().getStringValue(this.typeFeature);
            if (ts.subsumes(type, ts.getType(typeName))) {
                list.add(it.get().getStringValue(this.nameFeature));
            }
            it.moveToNext();
        }
        return list;
    }

    public void setVariable(String name, FeatureStructure fs) {
        FeatureStructure fsvar = this.getFsVarForName(name);
        Type type = this.cas.getTypeSystem().getType(fsvar.getStringValue(this.typeFeature));
        if (type == null) {
            throw new FsVariablesException(messageCatalog, "bad_typename_in_fsvar", new Object[]{fsvar.getStringValue(this.nameFeature), name});
        }
        if (!this.cas.getTypeSystem().subsumes(type, fs.getType())) {
            throw new FsVariablesException(messageCatalog, "illegal_fsvar_value", new Object[]{fs.getType().getName(), name, type.getName()});
        }
        fsvar.setFeatureValue(this.valueFeature, fs);
    }

    public void init(CAS cas) {
        this.cas = cas;
        if (this.cas == null) {
            throw new NullPointerException("CAS");
        }
        this.index = this.cas.getIndexRepository().getIndex("org.apache.uima.fsvars");
        if (this.index == null) {
            throw new FsVariablesException(messageCatalog, "fsvars_index_doesnt_exist", new Object[]{"org.apache.uima.fsvars"});
        }
        this.fsVariableType = this.cas.getTypeSystem().getType("org.apache.uima.FsVariable");
        if (this.fsVariableType == null) {
            throw new FsVariablesException(messageCatalog, "fsvars_type_doesnt_exist", new Object[]{"org.apache.uima.FsVariable"});
        }
        this.nameFeature = this.fsVariableType.getFeatureByBaseName("name");
        if (this.nameFeature == null) {
            throw new FsVariablesException(messageCatalog, "fsvars_feature_doesnt_exist", new Object[]{"name"});
        }
        this.typeFeature = this.fsVariableType.getFeatureByBaseName("type");
        if (this.typeFeature == null) {
            throw new FsVariablesException(messageCatalog, "fsvars_feature_doesnt_exist", new Object[]{"type"});
        }
        this.valueFeature = this.fsVariableType.getFeatureByBaseName("value");
        if (this.valueFeature == null) {
            throw new FsVariablesException(messageCatalog, "fsvars_feature_doesnt_exist", new Object[]{"value"});
        }
    }

    public boolean checkCas(CAS cas) {
        FSIndex variableIndex = cas.getIndexRepository().getIndex("org.apache.uima.fsvars");
        if (variableIndex == null) {
            return false;
        }
        TypeSystem ts = cas.getTypeSystem();
        Type type = ts.getType("org.apache.uima.FsVariable");
        if (type == null) {
            return false;
        }
        if (type.getFeatureByBaseName("name") == null) {
            return false;
        }
        return type.getFeatureByBaseName("value") != null;
    }

    private final FeatureStructure getFsVarForName(String name) {
        FeatureStructure fs = this.getFsVarNoExc(name);
        if (fs != null && fs.getStringValue(this.nameFeature).equals(name)) {
            return fs;
        }
        throw new FsVariablesException(messageCatalog, "no_such_fsvar", new Object[]{name});
    }

    private final FeatureStructure getFsVarNoExc(String name) {
        FSIterator it = this.index.iterator();
        FeatureStructure fs = this.cas.createFS(this.fsVariableType);
        fs.setStringValue(this.nameFeature, name);
        it.moveTo(fs);
        if (it.isValid()) {
            return it.get();
        }
        return null;
    }
}

