/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.uima.TokenAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.Language;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.danishStemmer;
import org.tartarus.snowball.ext.dutchStemmer;
import org.tartarus.snowball.ext.englishStemmer;
import org.tartarus.snowball.ext.finnishStemmer;
import org.tartarus.snowball.ext.frenchStemmer;
import org.tartarus.snowball.ext.germanStemmer;
import org.tartarus.snowball.ext.hungarianStemmer;
import org.tartarus.snowball.ext.italianStemmer;
import org.tartarus.snowball.ext.norwegianStemmer;
import org.tartarus.snowball.ext.portugueseStemmer;
import org.tartarus.snowball.ext.russianStemmer;
import org.tartarus.snowball.ext.spanishStemmer;
import org.tartarus.snowball.ext.swedishStemmer;

public class SnowballAnnotator
extends JCasAnnotator_ImplBase {
    private Logger logger;
    private HashMap<String, SnowballProgram> stemmers;
    private static final Object[] emptyArgs = new Object[0];

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        this.logger.log(Level.INFO, "Snowball annotator starts processing");
        String language = new Language(aJCas.getDocumentLanguage()).getLanguagePart();
        SnowballProgram stemmer = this.stemmers.get(language);
        if (stemmer != null) {
            Method stemmerStemMethod;
            try {
                stemmerStemMethod = stemmer.getClass().getMethod("stem", new Class[0]);
            }
            catch (Exception ex) {
                throw new AnalysisEngineProcessException((Throwable)ex);
            }
            for (TokenAnnotation annot : aJCas.getAnnotationIndex(TokenAnnotation.type)) {
                String span = annot.getCoveredText();
                try {
                    stemmer.setCurrent(span);
                    stemmerStemMethod.invoke((Object)stemmer, emptyArgs);
                }
                catch (Exception ex) {
                    throw new AnalysisEngineProcessException((Throwable)ex);
                }
                annot.setStem(stemmer.getCurrent());
            }
        } else if (language.equals("x")) {
            this.logger.log(Level.WARNING, "Language of the CAS is set to 'x', SnowballAnnotator skipped processing.");
        }
        this.logger.log(Level.INFO, "Snowball annotator processing finished");
    }

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.logger = aContext.getLogger();
            this.stemmers = new HashMap();
            this.stemmers.put("da", new danishStemmer());
            this.stemmers.put("nl", new dutchStemmer());
            this.stemmers.put("en", new englishStemmer());
            this.stemmers.put("fi", new finnishStemmer());
            this.stemmers.put("fr", new frenchStemmer());
            this.stemmers.put("de", new germanStemmer());
            this.stemmers.put("hu", new hungarianStemmer());
            this.stemmers.put("it", new italianStemmer());
            this.stemmers.put("no", new norwegianStemmer());
            this.stemmers.put("pt", new portugueseStemmer());
            this.stemmers.put("ru", new russianStemmer());
            this.stemmers.put("es", new spanishStemmer());
            this.stemmers.put("sw", new swedishStemmer());
        }
        catch (Exception ex) {
            throw new ResourceInitializationException((Throwable)ex);
        }
        this.logger.log(Level.INFO, "Snowball annotator successfully initialized");
    }
}

