/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import javax.servlet.Servlet;
import org.apache.uima.simpleserver.servlet.SimpleServerServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyUtils {
    private static final String uimaServletUrlFile = "/uima";

    public static final Server startJettyServer(String analysisEngineDescriptor, String mappingFile) throws Exception {
        Server server = JettyUtils.createServer();
        SimpleServerServlet uimaServlet = new SimpleServerServlet(true);
        File descriptorFile = new File(analysisEngineDescriptor);
        File specFile = new File(mappingFile);
        uimaServlet.init(descriptorFile, specFile);
        JettyUtils.addServletWithMapping(server, (Servlet)uimaServlet, uimaServletUrlFile);
        server.start();
        return server;
    }

    public static final void stopJettyServer(Server server) throws Exception {
        server.stop();
        server.join();
    }

    public static final String getServletUrl(Server server) {
        StringBuffer buf = new StringBuffer();
        buf.append("http://");
        buf.append(JettyUtils.getHost(server));
        buf.append(":");
        buf.append(Integer.toString(JettyUtils.getPort(server)));
        buf.append(uimaServletUrlFile);
        buf.append("?mode=form");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        String line;
        Server server = null;
        server = JettyUtils.startJettyServer(args[0], args[1]);
        String servletUrl = JettyUtils.getServletUrl(server);
        System.out.println("Use the following URL to access the servlet: " + servletUrl);
        String prompt = "Type 'stop' to exit> ";
        String stop = "stop";
        System.out.println(prompt);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((line = reader.readLine()) != null && !line.equals(stop)) {
            System.out.println(prompt);
        }
        JettyUtils.stopJettyServer(server);
        if (server == null) return;
        try {
            JettyUtils.stopJettyServer(server);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return;
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (server == null) return;
            }
            catch (Throwable throwable) {
                if (server == null) throw throwable;
                try {
                    JettyUtils.stopJettyServer(server);
                    throw throwable;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                JettyUtils.stopJettyServer(server);
                return;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            return;
        }
    }

    public static Server createServer() {
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        int port = JettyUtils.findFreePort();
        if (port <= 0) {
            return null;
        }
        System.out.println("Using port: " + port);
        connector.setPort(port);
        connector.setHost("127.0.0.1");
        server.addConnector((Connector)connector);
        server.setStopAtShutdown(true);
        server.setHandler((Handler)new ServletHandler());
        return server;
    }

    public static void addServletWithMapping(Server server, Class<?> servlet, String pathSpec) {
        ((ServletHandler)server.getHandler()).addServletWithMapping(servlet, pathSpec);
    }

    public static void addServletWithMapping(Server server, Servlet servlet, String pathSpec) {
        ((ServletHandler)server.getHandler()).addServletWithMapping(new ServletHolder(servlet), pathSpec);
    }

    public static String getHost(Server server) {
        return server.getConnectors()[0].getHost();
    }

    public static int getPort(Server server) {
        return server.getConnectors()[0].getPort();
    }

    private static final int findFreePort() {
        int p = -1;
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            p = serverSocket.getLocalPort();
            serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p;
    }
}

