/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.simpleserver.config.impl.ServerSpecImpl;
import org.apache.uima.simpleserver.output.ResultEntry;
import org.apache.uima.simpleserver.output.impl.ResultImpl;
import org.apache.uima.simpleserver.servlet.ServiceReaderThread;
import org.apache.uima.simpleserver.servlet.SimpleServerServlet;

public class ResultMerger
extends SimpleServerServlet {
    private static final long serialVersionUID = -2326819932388842032L;

    public String constructHtmlDescription(String servletURL) {
        return this.getHtmlDescription(servletURL);
    }

    private String getHtmlDescription(String urlstring) {
        String html = "<html><head><title>Description of the XML Result Merger service</title></head><body><h2>Service Result Merger</h2><p>This service merges the results of other simple UIMA servicesand returns the combined result in the specified format. </p><h3>Usage</h3>In odrer to use this service, a POST-request should be sent to the server with the following URL:<pre>" + urlstring + "</pre>" + "The following request parameters are expected:" + "<ul>" + "<li/><b>text</b> - the value of this parameter is the text to analyze. Expected " + "encoding is UTF-8. This parameter must always be set." + "<li/><b>mode</b> - the value of this parameter is either " + "&quot;<b>xml</b>&quot; or &quot;<b>inline</b>&quot;." + "This parameter allows you to define, which view of the result should be returned. " + "&quot;<b>xml</b>&quot; means to output the result as a XML-document containing a list of found entities, and" + "&quot;<b>inline</b>&quot; returns inline-xml containing the analyzed text in which all found entities are" + " represented by tags." + "If this parameter is not set, xml output will be produced." + "" + "<li/><b>url1</b>, <b>url2</b>, <b>url3</b>, etc. - the values of these parameters are the " + "URLs of other simple UIMA services which are to be invoked." + "</ul>" + "" + "<h3>Result</h3>" + "The returned result will be merged from results of the specified services. " + "For output details see the description of the services which you use." + "" + "" + "" + "" + "";
        return html;
    }

    public boolean initServer() {
        ServerSpecImpl res = new ServerSpecImpl("Result Merger", "Result Merger - merge results of other UIMA services");
        return true;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String urlStr;
        ArrayList<ResultEntry> resultEntries = new ArrayList<ResultEntry>();
        request.setCharacterEncoding("UTF-8");
        String text = request.getParameter("text");
        String mode = request.getParameter("mode");
        String lang = request.getParameter("lang");
        if (lang == null || lang.equals("")) {
            lang = "en";
        }
        LinkedList<ServiceReaderThread> threads = new LinkedList<ServiceReaderThread>();
        int i = 1;
        while ((urlStr = request.getParameter("url" + i)) != null) {
            ServiceReaderThread thread = new ServiceReaderThread(urlStr, text, lang);
            threads.add(thread);
            ++i;
        }
        for (ServiceReaderThread thread : threads) {
            thread.start();
        }
        for (ServiceReaderThread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (ServiceReaderThread thread : threads) {
            resultEntries.addAll(thread.getResultEntries());
        }
        response.setCharacterEncoding("UTF-8");
        response.getWriter().print(this.transformResult(new ResultImpl(resultEntries, text), mode));
        response.getWriter().close();
    }

    public String getHtmlForm(String serverUrl) {
        String str = "<html><head><title> Sorry, tryout not supported </title><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" ></head><body><h2>Sorry, the tryout form of " + serverUrl + " is not available. Tryout is not supported for this service. </h2>" + "</body>" + "</html>";
        return str;
    }
}

