/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver.output;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.uima.simpleserver.output.Result;
import org.apache.uima.simpleserver.output.ResultEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineXMLGenerator {
    public static String getInlineXML(Result result) {
        List beginningTags;
        List empTags;
        TreeSet<Integer> beginPositions = new TreeSet<Integer>();
        TreeSet<Integer> endPositions = new TreeSet<Integer>();
        TreeSet<Integer> emptyPositions = new TreeSet<Integer>();
        TreeSet<Integer> allPositions = new TreeSet<Integer>();
        HashMap beginTags = new HashMap(result.getResultEntries().size());
        HashMap endTags = new HashMap(result.getResultEntries().size());
        HashMap<Integer, LinkedList<ResultEntry>> emptyTags = new HashMap<Integer, LinkedList<ResultEntry>>();
        block2: for (ResultEntry entry : result.getResultEntries()) {
            LinkedList<ResultEntry> endTagList;
            int i;
            Integer end;
            Integer begin;
            try {
                begin = new Integer(entry.getBegin());
                end = new Integer(entry.getEnd());
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (begin.equals(end)) {
                emptyPositions.add(begin);
                LinkedList<ResultEntry> emptyTagList = (LinkedList<ResultEntry>)emptyTags.get(end);
                if (emptyTagList == null) {
                    emptyTagList = new LinkedList<ResultEntry>();
                    emptyTags.put(end, emptyTagList);
                }
                emptyTagList.add(entry);
                continue;
            }
            SortedSet<Integer> conflictPoints = beginPositions.subSet(begin + 1, end);
            Iterator i$ = conflictPoints.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                for (ResultEntry e : (List)beginTags.get(i)) {
                    if (!InlineXMLGenerator.isConflict(e, begin, end)) continue;
                    continue block2;
                }
            }
            conflictPoints = endPositions.subSet(begin + 1, end);
            i$ = conflictPoints.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                for (ResultEntry e : (List)endTags.get(i)) {
                    if (!InlineXMLGenerator.isConflict(e, begin, end)) continue;
                    continue block2;
                }
            }
            beginPositions.add(begin);
            endPositions.add(end);
            LinkedList<ResultEntry> beginTagList = (LinkedList<ResultEntry>)beginTags.get(begin);
            if (beginTagList == null) {
                beginTagList = new LinkedList<ResultEntry>();
                beginTags.put(begin, beginTagList);
            }
            if ((endTagList = (LinkedList<ResultEntry>)endTags.get(end)) == null) {
                endTagList = new LinkedList<ResultEntry>();
                endTags.put(end, endTagList);
            }
            beginTagList.add(entry);
            endTagList.add(entry);
        }
        allPositions.addAll(beginPositions);
        allPositions.addAll(endPositions);
        allPositions.addAll(emptyPositions);
        allPositions.add(0);
        StringBuffer sourceText = new StringBuffer(result.getText());
        allPositions.add(sourceText.length());
        StringBuffer resultSB = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<result>");
        int begin = 0;
        Iterator i$ = allPositions.iterator();
        while (i$.hasNext()) {
            List beginningTags2;
            List empTags2;
            int end = (Integer)i$.next();
            List endingTags = (List)endTags.get(begin);
            if (endingTags != null) {
                InlineXMLGenerator.printEndTags(endingTags, resultSB);
            }
            if ((empTags2 = (List)emptyTags.get(begin)) != null) {
                InlineXMLGenerator.printEmptyTags(empTags2, resultSB);
            }
            if ((beginningTags2 = (List)beginTags.get(begin)) != null) {
                InlineXMLGenerator.printBeginTags(beginningTags2, resultSB);
            }
            resultSB.append(InlineXMLGenerator.xmlEscape(sourceText.substring(begin, end)));
            begin = end;
        }
        List endingTags = (List)endTags.get(begin);
        if (endingTags != null) {
            InlineXMLGenerator.printEndTags(endingTags, resultSB);
        }
        if ((empTags = (List)emptyTags.get(begin)) != null) {
            InlineXMLGenerator.printEmptyTags(empTags, resultSB);
        }
        if ((beginningTags = (List)beginTags.get(begin)) != null) {
            InlineXMLGenerator.printBeginTags(beginningTags, resultSB);
        }
        resultSB.append("\n</result>");
        return resultSB.toString();
    }

    private static void printBeginTags(List<ResultEntry> list, StringBuffer sb) {
        while (!list.isEmpty()) {
            ResultEntry selectedEntry = null;
            int maxlen = -1;
            for (ResultEntry e : list) {
                if (InlineXMLGenerator.len(e) <= maxlen) continue;
                maxlen = InlineXMLGenerator.len(e);
                selectedEntry = e;
            }
            sb.append(InlineXMLGenerator.constructBeginTag(selectedEntry));
            list.remove(selectedEntry);
        }
    }

    private static void printEndTags(List<ResultEntry> list, StringBuffer sb) {
        while (!list.isEmpty()) {
            ResultEntry selectedEntry = null;
            int minlen = Integer.MAX_VALUE;
            for (ResultEntry e : list) {
                if (InlineXMLGenerator.len(e) > minlen) continue;
                minlen = InlineXMLGenerator.len(e);
                selectedEntry = e;
            }
            sb.append(InlineXMLGenerator.constructEndTag(selectedEntry));
            list.remove(selectedEntry);
        }
    }

    private static void printEmptyTags(List<ResultEntry> list, StringBuffer sb) {
        for (ResultEntry entry : list) {
            sb.append(InlineXMLGenerator.constructEmptyTag(entry));
        }
        list.clear();
    }

    private static int len(ResultEntry entry) {
        return entry.getEnd() - entry.getBegin() + 1;
    }

    private static String constructBeginTag(ResultEntry entry) {
        StringBuffer result = new StringBuffer("");
        result.append("<");
        result.append(entry.getEntryName());
        for (String attribute : entry.getAttributeNames()) {
            result.append(" ");
            result.append(attribute);
            result.append("=\"");
            result.append(InlineXMLGenerator.xmlEscape(entry.getAttriuteValue(attribute)));
            result.append("\"");
        }
        result.append(">");
        return result.toString();
    }

    private static String constructEndTag(ResultEntry entry) {
        return "</" + entry.getEntryName() + ">";
    }

    private static String constructEmptyTag(ResultEntry entry) {
        StringBuffer result = new StringBuffer("");
        result.append("<");
        result.append(entry.getEntryName());
        for (String attribute : entry.getAttributeNames()) {
            if (attribute.equals("coveredText")) continue;
            result.append(" ");
            result.append(attribute);
            result.append("=\"");
            result.append(InlineXMLGenerator.xmlEscape(entry.getAttriuteValue(attribute)));
            result.append("\"");
        }
        result.append("/>");
        return result.toString();
    }

    private static StringBuffer xmlEscape(String s) {
        StringBuffer sb = new StringBuffer();
        InlineXMLGenerator.normalize(s, sb, false);
        return sb;
    }

    public static void normalize(String aStr, StringBuffer aResultBuf, boolean aNewlinesToSpaces) {
        if (aStr != null) {
            int len = aStr.length();
            block9: for (int i = 0; i < len; ++i) {
                char c = aStr.charAt(i);
                switch (c) {
                    case '<': {
                        aResultBuf.append("&lt;");
                        continue block9;
                    }
                    case '>': {
                        aResultBuf.append("&gt;");
                        continue block9;
                    }
                    case '&': {
                        aResultBuf.append("&amp;");
                        continue block9;
                    }
                    case '\"': {
                        aResultBuf.append("&quot;");
                        continue block9;
                    }
                    case '\'': {
                        aResultBuf.append("&apos;");
                        continue block9;
                    }
                    case '\n': {
                        aResultBuf.append(aNewlinesToSpaces ? " " : "\n");
                        continue block9;
                    }
                    case '\r': {
                        aResultBuf.append(aNewlinesToSpaces ? " " : "\r");
                        continue block9;
                    }
                    default: {
                        aResultBuf.append(c);
                    }
                }
            }
        }
    }

    private static boolean isConflict(ResultEntry entry, int begin, int end) {
        return InlineXMLGenerator.isConflict(entry.getBegin(), entry.getEnd(), begin, end);
    }

    private static boolean isConflict(int b1, int e1, int b2, int e2) {
        if (b1 == b2) {
            return false;
        }
        if (e1 == e2) {
            return false;
        }
        if (b1 > b2) {
            return InlineXMLGenerator.isConflict(b2, e2, b1, e1);
        }
        return e1 > b2 && e1 < e2;
    }
}

