/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.simpleserver;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.InternationalizedException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.tools.PackageInstaller;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.simpleserver.ResultExtractor;
import org.apache.uima.simpleserver.SimpleServerException;
import org.apache.uima.simpleserver.config.ConfigFactory;
import org.apache.uima.simpleserver.config.Output;
import org.apache.uima.simpleserver.config.ServerSpec;
import org.apache.uima.simpleserver.config.TypeMap;
import org.apache.uima.simpleserver.config.impl.XmlConfigReader;
import org.apache.uima.simpleserver.output.Result;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.XMLInputSource;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Service {
    private static final String noDescriptionProvided = "No description provided";
    private static final Logger logger = UIMAFramework.getLogger(Service.class);
    private AnalysisEngine ae = null;
    protected CAS cas = null;
    protected ServerSpec serviceSpec = null;
    protected ResultExtractor resultExtractor = new ResultExtractor();
    protected volatile boolean initialized = false;

    public static Logger getLogger() {
        return logger;
    }

    public void configureAnalysisEngine(File descriptorFile, File resultSpecXMLFile) throws SimpleServerException, IOException, XmlException {
        assert (descriptorFile != null);
        try {
            this.loadDescriptor(descriptorFile);
        }
        catch (InternationalizedException e) {
            SimpleServerException sse = new SimpleServerException("uima_initialization_error", new Object[0], e);
            throw sse;
        }
        this.configure(resultSpecXMLFile);
    }

    public void configurePear(File pearFile, File pearInstallationDir, File serviceSpecFile) throws IOException, SimpleServerException, XmlException {
        try {
            this.loadPear(pearFile, pearInstallationDir);
        }
        catch (InternationalizedException e) {
            SimpleServerException sse = new SimpleServerException("uima_initialization_error", new Object[0], e);
            throw sse;
        }
        this.configure(serviceSpecFile);
    }

    protected void configure(File serviceSpecFile) throws IOException, SimpleServerException, XmlException {
        if (serviceSpecFile == null) {
            this.serviceSpec = ConfigFactory.newServerSpec(noDescriptionProvided, noDescriptionProvided, true);
        } else {
            this.serviceSpec = XmlConfigReader.readServerSpec(serviceSpecFile);
            this.validateResultSpec();
        }
        this.initialized = true;
    }

    protected final void logInitializationError() {
        SimpleServerException e = new SimpleServerException("service_state_exception", new Object[0]);
        Service.getLogger().log(Level.SEVERE, "", (Throwable)((Object)e));
    }

    public String getXMLResultXSD() {
        if (!this.initialized) {
            this.logInitializationError();
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document document = impl.createDocument(null, null, null);
            Element root = document.createElement("schema");
            root.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
            document.appendChild(root);
            Element resultElement = document.createElement("element");
            resultElement.setAttribute("name", "result");
            root.appendChild(resultElement);
            Element complexTypeElement = document.createElement("complexType");
            resultElement.appendChild(complexTypeElement);
            Element sequenceElement = document.createElement("sequence");
            complexTypeElement.appendChild(sequenceElement);
            for (TypeMap tSpec : this.serviceSpec.getTypeSpecs()) {
                Element element = document.createElement("element");
                element.setAttribute("name", tSpec.getOutputTag());
                element.setAttribute("maxOccurs", "unbounded");
                element.setAttribute("minOccurs", "0");
                Element complexType = document.createElement("complexType");
                element.appendChild(complexType);
                Element simpleContent = document.createElement("simpleContent");
                complexType.appendChild(simpleContent);
                Element extension = document.createElement("extension");
                extension.setAttribute("base", "string");
                simpleContent.appendChild(extension);
                for (Output output : tSpec.getOutputs()) {
                    Element attributeElement = document.createElement("attribute");
                    extension.appendChild(attributeElement);
                    attributeElement.setAttribute("name", output.getAttribute());
                    attributeElement.setAttribute("type", "string");
                    attributeElement.setAttribute("use", "optional");
                }
                sequenceElement.appendChild(element);
            }
            DOMSource source = new DOMSource(document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(source, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException e) {
            Service.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Service.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
        return null;
    }

    public synchronized Result process(String text, String lang) {
        if (!this.initialized) {
            this.logInitializationError();
            return null;
        }
        this.cas.reset();
        this.cas.setDocumentText(text);
        if (lang != null) {
            this.cas.setDocumentLanguage(lang);
        }
        try {
            this.ae.process(this.cas);
        }
        catch (AnalysisEngineProcessException e) {
            Service.getLogger().log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
        return this.resultExtractor.getResult(this.cas, this.serviceSpec);
    }

    public Result process(String text) {
        return this.process(text, null);
    }

    public ServerSpec getServiceSpec() {
        return this.serviceSpec;
    }

    private void loadDescriptor(File descriptorFile) throws IOException, InvalidXMLException, ResourceInitializationException {
        XMLInputSource in = new XMLInputSource(descriptorFile);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        ResourceManager manager = UIMAFramework.newDefaultResourceManager();
        this.ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier, (ResourceManager)manager, null);
        this.cas = this.ae.newCAS();
    }

    private void loadPear(File pearFile, File installationDir) throws IOException, InvalidXMLException, ResourceInitializationException {
        boolean doVerification = true;
        PackageBrowser instPear = PackageInstaller.installPackage((File)installationDir, (File)pearFile, (boolean)doVerification);
        String pearDescriptorFileName = instPear.getComponentPearDescPath();
        this.loadDescriptor(new File(pearDescriptorFileName));
    }

    private void validateResultSpec() {
        List<SimpleServerException> exc = this.serviceSpec.validate(this.cas.getTypeSystem());
        if (exc.size() > 0) {
            SimpleServerException e = new SimpleServerException("validation_warning", new Object[]{this.serviceSpec.getShortDescription()});
            Service.getLogger().log(Level.WARNING, e.getLocalizedMessage());
            for (SimpleServerException sse : exc) {
                Service.getLogger().log(Level.WARNING, sse.getLocalizedMessage());
            }
        }
    }

    public String getServiceDescription() {
        if (!this.initialized) {
            this.logInitializationError();
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document document = impl.createDocument(null, null, null);
            Element root = document.createElement("uimaService");
            root.setAttribute("shortDescription", this.serviceSpec.getShortDescription());
            document.appendChild(root);
            for (TypeMap tspec : this.serviceSpec.getTypeSpecs()) {
                Element typeDescription = document.createElement("element");
                root.appendChild(typeDescription);
                typeDescription.setAttribute("name", tspec.getOutputTag());
                typeDescription.setAttribute("shortDescription", tspec.getShortDescription());
                for (Output output : tspec.getOutputs()) {
                    Element outputSpec = document.createElement("attribute");
                    typeDescription.appendChild(outputSpec);
                    outputSpec.setAttribute("name", output.getAttribute());
                    outputSpec.setAttribute("shortDescription", output.getShortDescription());
                }
                if (!tspec.isOutputCoveredText()) continue;
                Element outputSpec = document.createElement("attribute");
                typeDescription.appendChild(outputSpec);
                outputSpec.setAttribute("name", "coveredText");
                outputSpec.setAttribute("shortDescription", "Text covered by annotation");
            }
            DOMSource source = new DOMSource(document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(source, streamResult);
            return stringWriter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

